
import type { DefineComponent, SlotsType } from 'vue'
type IslandComponent<T extends DefineComponent> = T & DefineComponent<{}, {refresh: () => Promise<void>}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, SlotsType<{ fallback: { error: unknown } }>>
type HydrationStrategies = {
  hydrateOnVisible?: IntersectionObserverInit | true
  hydrateOnIdle?: number | true
  hydrateOnInteraction?: keyof HTMLElementEventMap | Array<keyof HTMLElementEventMap> | true
  hydrateOnMediaQuery?: string
  hydrateAfter?: number
  hydrateWhen?: boolean
  hydrateNever?: true
}
type LazyComponent<T> = (T & DefineComponent<HydrationStrategies, {}, {}, {}, {}, {}, {}, { hydrated: () => void }>)
interface _GlobalComponents {
      'IconBadge': typeof import("../components/IconBadge.vue")['default']
    'IconsToman': typeof import("../components/Icons/Toman.vue")['default']
    'Loading': typeof import("../components/Loading.vue")['default']
    'Modal': typeof import("../components/Modal.vue")['default']
    'Offcanvas': typeof import("../components/Offcanvas.vue")['default']
    'OpacityOffcanvas': typeof import("../components/OpacityOffcanvas.vue")['default']
    'Pagination': typeof import("../components/Pagination.vue")['default']
    'RangeSlider': typeof import("../components/RangeSlider.vue")['default']
    'RepairMode': typeof import("../components/RepairMode.vue")['default']
    'ReportPriceForm': typeof import("../components/ReportPrice/Form.vue")['default']
    'ReportWrongForm': typeof import("../components/ReportWrong/Form.vue")['default']
    'Scaffold': typeof import("../components/Scaffold.vue")['default']
    'ServerErrors': typeof import("../components/ServerErrors.vue")['default']
    'Skeleton': typeof import("../components/Skeleton.vue")['default']
    'Tabs': typeof import("../components/Tabs.vue")['default']
    'TimeAgo': typeof import("../components/TimeAgo.vue")['default']
    'Timer': typeof import("../components/Timer.vue")['default']
    'Toast': typeof import("../components/Toast.vue")['default']
    'ToggleSlide': typeof import("../components/ToggleSlide.vue")['default']
    'Tooltip': typeof import("../components/Tooltip.vue")['default']
    'AddressesCreateOrEdit': typeof import("../components/addresses/CreateOrEdit.vue")['default']
    'AddressesDetail': typeof import("../components/addresses/Detail.vue")['default']
    'AddressesForm': typeof import("../components/addresses/Form.vue")['default']
    'AddressesOptionsUl': typeof import("../components/addresses/OptionsUl.vue")['default']
    'AddressesSelectLocation': typeof import("../components/addresses/SelectLocation.vue")['default']
    'AddressesSelectionList': typeof import("../components/addresses/SelectionList.vue")['default']
    'AddressesShortDetail': typeof import("../components/addresses/ShortDetail.vue")['default']
    'AddressesTable': typeof import("../components/addresses/Table.vue")['default']
    'AddressesTableOptions': typeof import("../components/addresses/TableOptions.vue")['default']
    'AdsFetchProducts': typeof import("../components/ads/FetchProducts.vue")['default']
    'AdsShowAdsInSidebar': typeof import("../components/ads/ShowAdsInSidebar.vue")['default']
    'AdsShowProductAdsLabel': typeof import("../components/ads/ShowProductAdsLabel.vue")['default']
    'AreaSelectCity': typeof import("../components/area/SelectCity.vue")['default']
    'AreaSelectDefault': typeof import("../components/area/SelectDefault.vue")['default']
    'AreaSelectProvince': typeof import("../components/area/SelectProvince.vue")['default']
    'BlogGridList': typeof import("../components/blog/GridList.vue")['default']
    'BlogPosts': typeof import("../components/blog/Posts.vue")['default']
    'BlogSlider': typeof import("../components/blog/Slider.vue")['default']
    'BrandsSearchSelectBrand': typeof import("../components/brands/SearchSelectBrand.vue")['default']
    'BrandsSearchSelectionCategory': typeof import("../components/brands/SearchSelectionCategory.vue")['default']
    'BrandsSlider': typeof import("../components/brands/Slider.vue")['default']
    'CartAction': typeof import("../components/cart/Action.vue")['default']
    'CartAddBtn': typeof import("../components/cart/AddBtn.vue")['default']
    'CartAllTransferDialog': typeof import("../components/cart/AllTransferDialog.vue")['default']
    'CartAppBar': typeof import("../components/cart/AppBar.vue")['default']
    'CartCurrentAction': typeof import("../components/cart/CurrentAction.vue")['default']
    'CartCurrentCart': typeof import("../components/cart/CurrentCart.vue")['default']
    'CartDesktopIcon': typeof import("../components/cart/DesktopIcon.vue")['default']
    'CartFactor': typeof import("../components/cart/Factor.vue")['default']
    'CartIcon': typeof import("../components/cart/Icon.vue")['default']
    'CartNextCart': typeof import("../components/cart/NextCart.vue")['default']
    'CartProductImage': typeof import("../components/cart/ProductImage.vue")['default']
    'CartProductPrice': typeof import("../components/cart/ProductPrice.vue")['default']
    'CartStatisticsOthers': typeof import("../components/cart/StatisticsOthers.vue")['default']
    'CartProducts': typeof import("../components/cart/products.vue")['default']
    'CategoriesSearchSelectionCategory': typeof import("../components/categories/SearchSelectionCategory.vue")['default']
    'CategoriesSelectBreadCrumbs': typeof import("../components/categories/SelectBreadCrumbs.vue")['default']
    'ColorSelectComponent': typeof import("../components/color/SelectComponent.vue")['default']
    'ColorShow': typeof import("../components/color/Show.vue")['default']
    'CommentAddCommentBuyer': typeof import("../components/comment/AddCommentBuyer.vue")['default']
    'CommentGalleryFiles': typeof import("../components/comment/GalleryFiles.vue")['default']
    'CommentLikeDislikeSection': typeof import("../components/comment/LikeDislikeSection.vue")['default']
    'CommentProductPage': typeof import("../components/comment/ProductPage.vue")['default']
    'CommentScore': typeof import("../components/comment/Score.vue")['default']
    'CommentStarRating': typeof import("../components/comment/StarRating.vue")['default']
    'CommentVariationDetail': typeof import("../components/comment/VariationDetail.vue")['default']
    'CommentView': typeof import("../components/comment/View.vue")['default']
    'CommentCreateAddBodyStep': typeof import("../components/comment/create/AddBodyStep.vue")['default']
    'CommentCreateAddScoreStep': typeof import("../components/comment/create/AddScoreStep.vue")['default']
    'CommentCreateContainer': typeof import("../components/comment/create/Container.vue")['default']
    'CommentCreateDialog': typeof import("../components/comment/create/Dialog.vue")['default']
    'CommentCreateFooter': typeof import("../components/comment/create/Footer.vue")['default']
    'CommentCreateHeader': typeof import("../components/comment/create/Header.vue")['default']
    'CommentCreateLoadingOverlay': typeof import("../components/comment/create/LoadingOverlay.vue")['default']
    'CommentCreateSoundRecording': typeof import("../components/comment/create/SoundRecording.vue")['default']
    'CommentCreateUploadFile': typeof import("../components/comment/create/UploadFile.vue")['default']
    'CommentDesktopProductPage': typeof import("../components/comment/desktop/ProductPage.vue")['default']
    'CommentMobileOffcanvasList': typeof import("../components/comment/mobile/OffcanvasList.vue")['default']
    'CommentMobileOffcanvasView': typeof import("../components/comment/mobile/OffcanvasView.vue")['default']
    'CommentMobileProductPage': typeof import("../components/comment/mobile/ProductPage.vue")['default']
    'CommentUserComments': typeof import("../components/comment/user/Comments.vue")['default']
    'CommentUserInfo': typeof import("../components/comment/user/Info.vue")['default']
    'CommentUserWaitingFeedback': typeof import("../components/comment/user/WaitingFeedback.vue")['default']
    'ComparisonProducts': typeof import("../components/comparison/Products.vue")['default']
    'ComparisonSelectionProducts': typeof import("../components/comparison/SelectionProducts.vue")['default']
    'ComparisonPage': typeof import("../components/comparison/page.vue")['default']
    'CustomDeliveryDesktopSelectSendTime': typeof import("../components/custom-delivery/DesktopSelectSendTime.vue")['default']
    'CustomDeliveryMobileSelectDateAndTime': typeof import("../components/custom-delivery/MobileSelectDateAndTime.vue")['default']
    'CustomDeliverySelectDateAndTimeSlider': typeof import("../components/custom-delivery/SelectDateAndTimeSlider.vue")['default']
    'CustomDeliveryShowSelectedDateAndTime': typeof import("../components/custom-delivery/ShowSelectedDateAndTime.vue")['default']
    'CustomDeliverySubmissionInfo': typeof import("../components/custom-delivery/SubmissionInfo.vue")['default']
    'CustomDeliverySummary': typeof import("../components/custom-delivery/Summary.vue")['default']
    'DesignHtmlCode': typeof import("../components/design/HtmlCode.vue")['default']
    'DesignParagraph': typeof import("../components/design/Paragraph.vue")['default']
    'DesignPositionView': typeof import("../components/design/PositionView.vue")['default']
    'DiscountRegisterCode': typeof import("../components/discount/RegisterCode.vue")['default']
    'ExpertReviewProduct': typeof import("../components/expert-review/Product.vue")['default']
    'FaqCategories': typeof import("../components/faq/Categories.vue")['default']
    'FaqContactUs': typeof import("../components/faq/ContactUs.vue")['default']
    'FaqPopularQuestion': typeof import("../components/faq/PopularQuestion.vue")['default']
    'FaqQuestionsList': typeof import("../components/faq/QuestionsList.vue")['default']
    'FaqWidgetView': typeof import("../components/faq/widget/view.vue")['default']
    'FavouriteShortCode': typeof import("../components/favourite/ShortCode.vue")['default']
    'FavouriteUserList': typeof import("../components/favourite/UserList.vue")['default']
    'FiltersColors': typeof import("../components/filters/Colors.vue")['default']
    'FiltersDesktopView': typeof import("../components/filters/DesktopView.vue")['default']
    'FiltersHasAvailable': typeof import("../components/filters/HasAvailable.vue")['default']
    'FiltersList': typeof import("../components/filters/List.vue")['default']
    'FiltersMobileView': typeof import("../components/filters/MobileView.vue")['default']
    'FiltersPriceRange': typeof import("../components/filters/PriceRange.vue")['default']
    'FiltersReadySend': typeof import("../components/filters/ReadySend.vue")['default']
    'FinanceAddBankAccount': typeof import("../components/finance/AddBankAccount.vue")['default']
    'FinanceMethodSelection': typeof import("../components/finance/MethodSelection.vue")['default']
    'FormButton': typeof import("../components/form/Button.vue")['default']
    'FormCheckBox': typeof import("../components/form/CheckBox.vue")['default']
    'FormComponent': typeof import("../components/form/Component.vue")['default']
    'FormDateInput': typeof import("../components/form/DateInput.vue")['default']
    'FormRadio': typeof import("../components/form/Radio.vue")['default']
    'FormSelectTag': typeof import("../components/form/SelectTag.vue")['default']
    'FormTextInput': typeof import("../components/form/TextInput.vue")['default']
    'FormSelectBottomSheet': typeof import("../components/form/select/BottomSheet.vue")['default']
    'FormSelectListView': typeof import("../components/form/select/ListView.vue")['default']
    'FormSelectModalList': typeof import("../components/form/select/ModalList.vue")['default']
    'HomePaymentSelection': typeof import("../components/home-payment/selection.vue")['default']
    'ImageSearchUploadImage': typeof import("../components/image-search/UploadImage.vue")['default']
    'NotificationsRequestAvailability': typeof import("../components/notifications/RequestAvailability.vue")['default']
    'NotificationsRequestBox': typeof import("../components/notifications/RequestBox.vue")['default']
    'NotificationsUserList': typeof import("../components/notifications/UserList.vue")['default']
    'OnlinePaymentSelection': typeof import("../components/online-payment/selection.vue")['default']
    'OrdersVerify': typeof import("../components/orders/Verify.vue")['default']
    'OrdersCheckoutBottomNavigation': typeof import("../components/orders/checkout/BottomNavigation.vue")['default']
    'OrdersCheckoutFactor': typeof import("../components/orders/checkout/Factor.vue")['default']
    'OrdersCheckoutHeader': typeof import("../components/orders/checkout/Header.vue")['default']
    'OrdersCheckoutProductsSlider': typeof import("../components/orders/checkout/ProductsSlider.vue")['default']
    'OrdersCheckoutShortSubmissionsDetail': typeof import("../components/orders/checkout/ShortSubmissionsDetail.vue")['default']
    'OrdersCheckoutSubmissionShippingCost': typeof import("../components/orders/checkout/SubmissionShippingCost.vue")['default']
    'OrdersFactorCompany': typeof import("../components/orders/factor/Company.vue")['default']
    'OrdersFactorProducts': typeof import("../components/orders/factor/Products.vue")['default']
    'OrdersFactorUser': typeof import("../components/orders/factor/User.vue")['default']
    'OrdersFactorView': typeof import("../components/orders/factor/View.vue")['default']
    'OrdersUserAddressInfo': typeof import("../components/orders/user/AddressInfo.vue")['default']
    'OrdersUserCancelledOrders': typeof import("../components/orders/user/CancelledOrders.vue")['default']
    'OrdersUserCurrentOrders': typeof import("../components/orders/user/CurrentOrders.vue")['default']
    'OrdersUserDetailItems': typeof import("../components/orders/user/DetailItems.vue")['default']
    'OrdersUserFactorLink': typeof import("../components/orders/user/FactorLink.vue")['default']
    'OrdersUserOrderProducts': typeof import("../components/orders/user/OrderProducts.vue")['default']
    'OrdersUserOrderStatistics': typeof import("../components/orders/user/OrderStatistics.vue")['default']
    'OrdersUserOrdersList': typeof import("../components/orders/user/OrdersList.vue")['default']
    'OrdersUserPaymentHistory': typeof import("../components/orders/user/PaymentHistory.vue")['default']
    'OrdersUserReturnProducts': typeof import("../components/orders/user/ReturnProducts.vue")['default']
    'OrdersUserReturnedOrders': typeof import("../components/orders/user/ReturnedOrders.vue")['default']
    'OrdersUserSentOrders': typeof import("../components/orders/user/SentOrders.vue")['default']
    'OrdersUserSubmission': typeof import("../components/orders/user/Submission.vue")['default']
    'OrdersUserSubmissionProducts': typeof import("../components/orders/user/SubmissionProducts.vue")['default']
    'PostalDeliverySubmissionInfo': typeof import("../components/postal-delivery/SubmissionInfo.vue")['default']
    'PriceChangesShortCut': typeof import("../components/price-changes/ShortCut.vue")['default']
    'PriceVariationCartDetail': typeof import("../components/priceVariation/CartDetail.vue")['default']
    'PriceVariationDetail': typeof import("../components/priceVariation/Detail.vue")['default']
    'PriceVariationDiscountPercentage': typeof import("../components/priceVariation/DiscountPercentage.vue")['default']
    'PriceVariationItems': typeof import("../components/priceVariation/Items.vue")['default']
    'PriceVariationNotifications': typeof import("../components/priceVariation/Notifications.vue")['default']
    'PriceVariationPriceBox': typeof import("../components/priceVariation/PriceBox.vue")['default']
    'PriceVariationProductFinalPrice': typeof import("../components/priceVariation/ProductFinalPrice.vue")['default']
    'PriceVariationProductOldPrice': typeof import("../components/priceVariation/ProductOldPrice.vue")['default']
    'PriceVariationSelectVariationBtn': typeof import("../components/priceVariation/SelectVariationBtn.vue")['default']
    'PriceVariationSellerPerformance': typeof import("../components/priceVariation/SellerPerformance.vue")['default']
    'PriceVariationSellerPerformanceDetail': typeof import("../components/priceVariation/SellerPerformanceDetail.vue")['default']
    'PriceVariationSendDetail': typeof import("../components/priceVariation/SendDetail.vue")['default']
    'PriceVariationShortDetail': typeof import("../components/priceVariation/ShortDetail.vue")['default']
    'PriceVariationStatusInWarehouse': typeof import("../components/priceVariation/StatusInWarehouse.vue")['default']
    'PriceVariationStockNotice': typeof import("../components/priceVariation/StockNotice.vue")['default']
    'PriceVariationAllListDesktop': typeof import("../components/priceVariation/all-list/Desktop.vue")['default']
    'ProductPageAppBar': typeof import("../components/product-page/AppBar.vue")['default']
    'ProductPageBottomNavigation': typeof import("../components/product-page/BottomNavigation.vue")['default']
    'ProductPageInformation': typeof import("../components/product-page/Information.vue")['default']
    'ProductPageIntroduction': typeof import("../components/product-page/Introduction.vue")['default']
    'ProductPageOffcanvasTabs': typeof import("../components/product-page/OffcanvasTabs.vue")['default']
    'ProductPageOptions': typeof import("../components/product-page/Options.vue")['default']
    'ProductPagePurchaseFeatures': typeof import("../components/product-page/PurchaseFeatures.vue")['default']
    'ProductPageReturnConditions': typeof import("../components/product-page/ReturnConditions.vue")['default']
    'ProductPageTabs': typeof import("../components/product-page/Tabs.vue")['default']
    'ProductPageGalleryDesktop': typeof import("../components/product-page/gallery/Desktop.vue")['default']
    'ProductPageGalleryMobile': typeof import("../components/product-page/gallery/Mobile.vue")['default']
    'ProductPageGallerySmallSlider': typeof import("../components/product-page/gallery/SmallSlider.vue")['default']
    'ProductPageGalleryTabSlider': typeof import("../components/product-page/gallery/TabSlider.vue")['default']
    'PromotionsAmazingDay': typeof import("../components/promotions/AmazingDay.vue")['default']
    'PromotionsAmazingOffers': typeof import("../components/promotions/AmazingOffers.vue")['default']
    'PromotionsCategoriesSlider': typeof import("../components/promotions/CategoriesSlider.vue")['default']
    'PromotionsDisplayOfferLabel': typeof import("../components/promotions/DisplayOfferLabel.vue")['default']
    'PromotionsIncredibleOffersAppBar': typeof import("../components/promotions/IncredibleOffersAppBar.vue")['default']
    'PromotionsProductFooter': typeof import("../components/promotions/ProductFooter.vue")['default']
    'PromotionsSelectedOffersSlider': typeof import("../components/promotions/SelectedOffersSlider.vue")['default']
    'PromotionsShortCode': typeof import("../components/promotions/ShortCode.vue")['default']
    'QuestionsAnswers': typeof import("../components/questions/Answers.vue")['default']
    'QuestionsFormBox': typeof import("../components/questions/FormBox.vue")['default']
    'QuestionsLikeDislikeSection': typeof import("../components/questions/LikeDislikeSection.vue")['default']
    'QuestionsOffcanvasList': typeof import("../components/questions/OffcanvasList.vue")['default']
    'QuestionsProductPage': typeof import("../components/questions/ProductPage.vue")['default']
    'QuestionsView': typeof import("../components/questions/View.vue")['default']
    'QuestionsDesktopProductPage': typeof import("../components/questions/desktop/ProductPage.vue")['default']
    'QuestionsMobileOffcanvasView': typeof import("../components/questions/mobile/OffcanvasView.vue")['default']
    'QuestionsMobileProductPage': typeof import("../components/questions/mobile/ProductPage.vue")['default']
    'QuestionsUserList': typeof import("../components/questions/user/List.vue")['default']
    'SellersFilterItem': typeof import("../components/sellers/FilterItem.vue")['default']
    'ShareIcon': typeof import("../components/share/Icon.vue")['default']
    'ShareShortCode': typeof import("../components/share/ShortCode.vue")['default']
    'SiteAppBarSetting': typeof import("../components/site/AppBarSetting.vue")['default']
    'SlidersView': typeof import("../components/sliders/view.vue")['default']
    'SpecificationsDesktopView': typeof import("../components/specifications/DesktopView.vue")['default']
    'SpecificationsImportant': typeof import("../components/specifications/Important.vue")['default']
    'SpecificationsMobileView': typeof import("../components/specifications/MobileView.vue")['default']
    'SpecificationsProduct': typeof import("../components/specifications/Product.vue")['default']
    'SpecificationsShortCode': typeof import("../components/specifications/ShortCode.vue")['default']
    'StatisticsLastWeekSales': typeof import("../components/statistics/LastWeekSales.vue")['default']
    'StatisticsRecentDay': typeof import("../components/statistics/RecentDay.vue")['default']
    'TableActions': typeof import("../components/table/Actions.vue")['default']
    'TableActionsBox': typeof import("../components/table/ActionsBox.vue")['default']
    'TableColumnView': typeof import("../components/table/ColumnView.vue")['default']
    'TableColumnsDateColumn': typeof import("../components/table/Columns/DateColumn.vue")['default']
    'TableColumnsNumberColumn': typeof import("../components/table/Columns/NumberColumn.vue")['default']
    'TableColumnsStatusColumn': typeof import("../components/table/Columns/StatusColumn.vue")['default']
    'TableColumnsTimeColumn': typeof import("../components/table/Columns/TimeColumn.vue")['default']
    'TableComponent': typeof import("../components/table/Component.vue")['default']
    'TableDeleteLink': typeof import("../components/table/DeleteLink.vue")['default']
    'TableDetailOffcanvas': typeof import("../components/table/DetailOffcanvas.vue")['default']
    'TableDetailView': typeof import("../components/table/DetailView.vue")['default']
    'TableEditLink': typeof import("../components/table/EditLink.vue")['default']
    'TableRestoreLink': typeof import("../components/table/RestoreLink.vue")['default']
    'ThemeAuctionProducts': typeof import("../components/theme/AuctionProducts.vue")['default']
    'ThemeMainCategories': typeof import("../components/theme/MainCategories.vue")['default']
    'ThemeNotFound': typeof import("../components/theme/NotFound.vue")['default']
    'ThemeProductsBasedOnTaste': typeof import("../components/theme/ProductsBasedOnTaste.vue")['default']
    'ThemeSupportItems': typeof import("../components/theme/SupportItems.vue")['default']
    'ThemeDesktopHeader': typeof import("../components/theme/desktop/Header.vue")['default']
    'ThemeDesktopHeaderMenus': typeof import("../components/theme/desktop/HeaderMenus.vue")['default']
    'ThemeDesktopMegaMenu': typeof import("../components/theme/desktop/MegaMenu.vue")['default']
    'ThemeDesktopSearchProducts': typeof import("../components/theme/desktop/SearchProducts.vue")['default']
    'ThemeFastSearchCategories': typeof import("../components/theme/fast-search/Categories.vue")['default']
    'ThemeFastSearchInput': typeof import("../components/theme/fast-search/Input.vue")['default']
    'ThemeFastSearchPopularSearch': typeof import("../components/theme/fast-search/PopularSearch.vue")['default']
    'ThemeFastSearchRecent': typeof import("../components/theme/fast-search/Recent.vue")['default']
    'ThemeFastSearchResult': typeof import("../components/theme/fast-search/Result.vue")['default']
    'ThemeFastSearchSimilarPhrases': typeof import("../components/theme/fast-search/SimilarPhrases.vue")['default']
    'ThemeFooterNewsletterForm': typeof import("../components/theme/footer/NewsletterForm.vue")['default']
    'ThemeFooterSocialNetworks': typeof import("../components/theme/footer/SocialNetworks.vue")['default']
    'ThemeFooterSupport': typeof import("../components/theme/footer/Support.vue")['default']
    'ThemeFooterView': typeof import("../components/theme/footer/View.vue")['default']
    'ThemeMobileAppBar': typeof import("../components/theme/mobile/AppBar.vue")['default']
    'ThemeMobileBottomNavigationBar': typeof import("../components/theme/mobile/BottomNavigationBar.vue")['default']
    'ThemeMobileSearchProducts': typeof import("../components/theme/mobile/SearchProducts.vue")['default']
    'ThemeMobileSearchProductsAppbar': typeof import("../components/theme/mobile/SearchProductsAppbar.vue")['default']
    'ThemeProductSliderGridList': typeof import("../components/theme/product-slider/GridList.vue")['default']
    'ThemeProductSliderHorizontalList': typeof import("../components/theme/product-slider/HorizontalList.vue")['default']
    'ThemeProductSliderHorizontalView': typeof import("../components/theme/product-slider/HorizontalView.vue")['default']
    'ThemeProductSliderMultiRow': typeof import("../components/theme/product-slider/MultiRow.vue")['default']
    'ThemeProductSliderVerticalView': typeof import("../components/theme/product-slider/VerticalView.vue")['default']
    'ThemeProductSliderView': typeof import("../components/theme/product-slider/View.vue")['default']
    'ThemeSearchAppBarItems': typeof import("../components/theme/search/AppBarItems.vue")['default']
    'ThemeSearchBeforeProductView': typeof import("../components/theme/search/BeforeProductView.vue")['default']
    'ThemeSearchNotFound': typeof import("../components/theme/search/NotFound.vue")['default']
    'ThemeSearchProductColors': typeof import("../components/theme/search/ProductColors.vue")['default']
    'ThemeSearchProductLoading': typeof import("../components/theme/search/ProductLoading.vue")['default']
    'ThemeSearchProductPrice': typeof import("../components/theme/search/ProductPrice.vue")['default']
    'ThemeSearchProductView': typeof import("../components/theme/search/ProductView.vue")['default']
    'ThemeSearchView': typeof import("../components/theme/search/View.vue")['default']
    'ThemeWidgetsBanners': typeof import("../components/theme/widgets/Banners.vue")['default']
    'ThemeWidgetsLatestHot': typeof import("../components/theme/widgets/LatestHot.vue")['default']
    'ThemeWidgetsMoreText': typeof import("../components/theme/widgets/MoreText.vue")['default']
    'ThemeWidgetsProductSlider': typeof import("../components/theme/widgets/ProductSlider.vue")['default']
    'ThemeWidgetsSelectedCategories': typeof import("../components/theme/widgets/SelectedCategories.vue")['default']
    'UsersDesktopProfileLink': typeof import("../components/users/DesktopProfileLink.vue")['default']
    'UsersLayout': typeof import("../components/users/Layout.vue")['default']
    'UsersLogout': typeof import("../components/users/Logout.vue")['default']
    'UsersReceiveVerificationCode': typeof import("../components/users/ReceiveVerificationCode.vue")['default']
    'UsersRemoveRequestBtn': typeof import("../components/users/RemoveRequestBtn.vue")['default']
    'UsersAuthOneTimePassword': typeof import("../components/users/auth/OneTimePassword.vue")['default']
    'UsersLegalAccountDeleteDialog': typeof import("../components/users/legal-account/DeleteDialog.vue")['default']
    'UsersLegalAccountForm': typeof import("../components/users/legal-account/Form.vue")['default']
    'UsersLegalAccountInfo': typeof import("../components/users/legal-account/Info.vue")['default']
    'UsersPanelAppBar': typeof import("../components/users/panel/AppBar.vue")['default']
    'UsersPanelBox': typeof import("../components/users/panel/Box.vue")['default']
    'UsersPanelEmptyList': typeof import("../components/users/panel/EmptyList.vue")['default']
    'UsersPanelInfo': typeof import("../components/users/panel/Info.vue")['default']
    'UsersPanelMenus': typeof import("../components/users/panel/Menus.vue")['default']
    'UsersPersonalInfoEditBirthday': typeof import("../components/users/personalInfo/EditBirthday.vue")['default']
    'UsersPersonalInfoEditEmail': typeof import("../components/users/personalInfo/EditEmail.vue")['default']
    'UsersPersonalInfoEditMobileNumber': typeof import("../components/users/personalInfo/EditMobileNumber.vue")['default']
    'UsersPersonalInfoEditNameForm': typeof import("../components/users/personalInfo/EditNameForm.vue")['default']
    'UsersPersonalInfoEditPassword': typeof import("../components/users/personalInfo/EditPassword.vue")['default']
    'UsersPersonalInfoHowReturnMoney': typeof import("../components/users/personalInfo/HowReturnMoney.vue")['default']
    'WalletBalance': typeof import("../components/wallet/Balance.vue")['default']
    'WalletChargeForm': typeof import("../components/wallet/ChargeForm.vue")['default']
    'WalletMethodSelection': typeof import("../components/wallet/MethodSelection.vue")['default']
    'WalletPaymentForOrder': typeof import("../components/wallet/WalletPaymentForOrder.vue")['default']
    'WalletTableAmountColumn': typeof import("../components/wallet/table/AmountColumn.vue")['default']
    'WarrantyShow': typeof import("../components/warranty/Show.vue")['default']
    'NuxtWelcome': typeof import("../node_modules/nuxt/dist/app/components/welcome.vue")['default']
    'NuxtLayout': typeof import("../node_modules/nuxt/dist/app/components/nuxt-layout")['default']
    'NuxtErrorBoundary': typeof import("../node_modules/nuxt/dist/app/components/nuxt-error-boundary.vue")['default']
    'ClientOnly': typeof import("../node_modules/nuxt/dist/app/components/client-only")['default']
    'DevOnly': typeof import("../node_modules/nuxt/dist/app/components/dev-only")['default']
    'ServerPlaceholder': typeof import("../node_modules/nuxt/dist/app/components/server-placeholder")['default']
    'NuxtLink': typeof import("../node_modules/nuxt/dist/app/components/nuxt-link")['default']
    'NuxtLoadingIndicator': typeof import("../node_modules/nuxt/dist/app/components/nuxt-loading-indicator")['default']
    'NuxtTime': typeof import("../node_modules/nuxt/dist/app/components/nuxt-time.vue")['default']
    'NuxtRouteAnnouncer': typeof import("../node_modules/nuxt/dist/app/components/nuxt-route-announcer")['default']
    'NuxtImg': typeof import("../node_modules/@nuxt/image/dist/runtime/components/NuxtImg.vue")['default']
    'NuxtPicture': typeof import("../node_modules/@nuxt/image/dist/runtime/components/NuxtPicture.vue")['default']
    'LCircle': typeof import("@vue-leaflet/vue-leaflet")['LCircle']
    'LCircleMarker': typeof import("@vue-leaflet/vue-leaflet")['LCircleMarker']
    'LControl': typeof import("@vue-leaflet/vue-leaflet")['LControl']
    'LControlAttribution': typeof import("@vue-leaflet/vue-leaflet")['LControlAttribution']
    'LControlLayers': typeof import("@vue-leaflet/vue-leaflet")['LControlLayers']
    'LControlScale': typeof import("@vue-leaflet/vue-leaflet")['LControlScale']
    'LControlZoom': typeof import("@vue-leaflet/vue-leaflet")['LControlZoom']
    'LFeatureGroup': typeof import("@vue-leaflet/vue-leaflet")['LFeatureGroup']
    'LGeoJson': typeof import("@vue-leaflet/vue-leaflet")['LGeoJson']
    'LIcon': typeof import("@vue-leaflet/vue-leaflet")['LIcon']
    'LImageOverlay': typeof import("@vue-leaflet/vue-leaflet")['LImageOverlay']
    'LLayerGroup': typeof import("@vue-leaflet/vue-leaflet")['LLayerGroup']
    'LMap': typeof import("@vue-leaflet/vue-leaflet")['LMap']
    'LMarker': typeof import("@vue-leaflet/vue-leaflet")['LMarker']
    'LPolygon': typeof import("@vue-leaflet/vue-leaflet")['LPolygon']
    'LPolyline': typeof import("@vue-leaflet/vue-leaflet")['LPolyline']
    'LPopup': typeof import("@vue-leaflet/vue-leaflet")['LPopup']
    'LRectangle': typeof import("@vue-leaflet/vue-leaflet")['LRectangle']
    'LTileLayer': typeof import("@vue-leaflet/vue-leaflet")['LTileLayer']
    'LTooltip': typeof import("@vue-leaflet/vue-leaflet")['LTooltip']
    'LWmsTileLayer': typeof import("@vue-leaflet/vue-leaflet")['LWmsTileLayer']
    'VitePwaManifest': typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/VitePwaManifest")['default']
    'NuxtPwaManifest': typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/VitePwaManifest")['default']
    'NuxtPwaAssets': typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/NuxtPwaAssets")['default']
    'PwaAppleImage': typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaAppleImage.vue")['default']
    'PwaAppleSplashScreenImage': typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaAppleSplashScreenImage.vue")['default']
    'PwaFaviconImage': typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaFaviconImage.vue")['default']
    'PwaMaskableImage': typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaMaskableImage.vue")['default']
    'PwaTransparentImage': typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaTransparentImage.vue")['default']
    'NuxtPage': typeof import("../node_modules/nuxt/dist/pages/runtime/page")['default']
    'NoScript': typeof import("../node_modules/nuxt/dist/head/runtime/components")['NoScript']
    'Link': typeof import("../node_modules/nuxt/dist/head/runtime/components")['Link']
    'Base': typeof import("../node_modules/nuxt/dist/head/runtime/components")['Base']
    'Title': typeof import("../node_modules/nuxt/dist/head/runtime/components")['Title']
    'Meta': typeof import("../node_modules/nuxt/dist/head/runtime/components")['Meta']
    'Style': typeof import("../node_modules/nuxt/dist/head/runtime/components")['Style']
    'Head': typeof import("../node_modules/nuxt/dist/head/runtime/components")['Head']
    'Html': typeof import("../node_modules/nuxt/dist/head/runtime/components")['Html']
    'Body': typeof import("../node_modules/nuxt/dist/head/runtime/components")['Body']
    'NuxtIsland': typeof import("../node_modules/nuxt/dist/app/components/nuxt-island")['default']
    'NuxtRouteAnnouncer': IslandComponent<typeof import("../node_modules/nuxt/dist/app/components/server-placeholder")['default']>
      'LazyIconBadge': LazyComponent<typeof import("../components/IconBadge.vue")['default']>
    'LazyIconsToman': LazyComponent<typeof import("../components/Icons/Toman.vue")['default']>
    'LazyLoading': LazyComponent<typeof import("../components/Loading.vue")['default']>
    'LazyModal': LazyComponent<typeof import("../components/Modal.vue")['default']>
    'LazyOffcanvas': LazyComponent<typeof import("../components/Offcanvas.vue")['default']>
    'LazyOpacityOffcanvas': LazyComponent<typeof import("../components/OpacityOffcanvas.vue")['default']>
    'LazyPagination': LazyComponent<typeof import("../components/Pagination.vue")['default']>
    'LazyRangeSlider': LazyComponent<typeof import("../components/RangeSlider.vue")['default']>
    'LazyRepairMode': LazyComponent<typeof import("../components/RepairMode.vue")['default']>
    'LazyReportPriceForm': LazyComponent<typeof import("../components/ReportPrice/Form.vue")['default']>
    'LazyReportWrongForm': LazyComponent<typeof import("../components/ReportWrong/Form.vue")['default']>
    'LazyScaffold': LazyComponent<typeof import("../components/Scaffold.vue")['default']>
    'LazyServerErrors': LazyComponent<typeof import("../components/ServerErrors.vue")['default']>
    'LazySkeleton': LazyComponent<typeof import("../components/Skeleton.vue")['default']>
    'LazyTabs': LazyComponent<typeof import("../components/Tabs.vue")['default']>
    'LazyTimeAgo': LazyComponent<typeof import("../components/TimeAgo.vue")['default']>
    'LazyTimer': LazyComponent<typeof import("../components/Timer.vue")['default']>
    'LazyToast': LazyComponent<typeof import("../components/Toast.vue")['default']>
    'LazyToggleSlide': LazyComponent<typeof import("../components/ToggleSlide.vue")['default']>
    'LazyTooltip': LazyComponent<typeof import("../components/Tooltip.vue")['default']>
    'LazyAddressesCreateOrEdit': LazyComponent<typeof import("../components/addresses/CreateOrEdit.vue")['default']>
    'LazyAddressesDetail': LazyComponent<typeof import("../components/addresses/Detail.vue")['default']>
    'LazyAddressesForm': LazyComponent<typeof import("../components/addresses/Form.vue")['default']>
    'LazyAddressesOptionsUl': LazyComponent<typeof import("../components/addresses/OptionsUl.vue")['default']>
    'LazyAddressesSelectLocation': LazyComponent<typeof import("../components/addresses/SelectLocation.vue")['default']>
    'LazyAddressesSelectionList': LazyComponent<typeof import("../components/addresses/SelectionList.vue")['default']>
    'LazyAddressesShortDetail': LazyComponent<typeof import("../components/addresses/ShortDetail.vue")['default']>
    'LazyAddressesTable': LazyComponent<typeof import("../components/addresses/Table.vue")['default']>
    'LazyAddressesTableOptions': LazyComponent<typeof import("../components/addresses/TableOptions.vue")['default']>
    'LazyAdsFetchProducts': LazyComponent<typeof import("../components/ads/FetchProducts.vue")['default']>
    'LazyAdsShowAdsInSidebar': LazyComponent<typeof import("../components/ads/ShowAdsInSidebar.vue")['default']>
    'LazyAdsShowProductAdsLabel': LazyComponent<typeof import("../components/ads/ShowProductAdsLabel.vue")['default']>
    'LazyAreaSelectCity': LazyComponent<typeof import("../components/area/SelectCity.vue")['default']>
    'LazyAreaSelectDefault': LazyComponent<typeof import("../components/area/SelectDefault.vue")['default']>
    'LazyAreaSelectProvince': LazyComponent<typeof import("../components/area/SelectProvince.vue")['default']>
    'LazyBlogGridList': LazyComponent<typeof import("../components/blog/GridList.vue")['default']>
    'LazyBlogPosts': LazyComponent<typeof import("../components/blog/Posts.vue")['default']>
    'LazyBlogSlider': LazyComponent<typeof import("../components/blog/Slider.vue")['default']>
    'LazyBrandsSearchSelectBrand': LazyComponent<typeof import("../components/brands/SearchSelectBrand.vue")['default']>
    'LazyBrandsSearchSelectionCategory': LazyComponent<typeof import("../components/brands/SearchSelectionCategory.vue")['default']>
    'LazyBrandsSlider': LazyComponent<typeof import("../components/brands/Slider.vue")['default']>
    'LazyCartAction': LazyComponent<typeof import("../components/cart/Action.vue")['default']>
    'LazyCartAddBtn': LazyComponent<typeof import("../components/cart/AddBtn.vue")['default']>
    'LazyCartAllTransferDialog': LazyComponent<typeof import("../components/cart/AllTransferDialog.vue")['default']>
    'LazyCartAppBar': LazyComponent<typeof import("../components/cart/AppBar.vue")['default']>
    'LazyCartCurrentAction': LazyComponent<typeof import("../components/cart/CurrentAction.vue")['default']>
    'LazyCartCurrentCart': LazyComponent<typeof import("../components/cart/CurrentCart.vue")['default']>
    'LazyCartDesktopIcon': LazyComponent<typeof import("../components/cart/DesktopIcon.vue")['default']>
    'LazyCartFactor': LazyComponent<typeof import("../components/cart/Factor.vue")['default']>
    'LazyCartIcon': LazyComponent<typeof import("../components/cart/Icon.vue")['default']>
    'LazyCartNextCart': LazyComponent<typeof import("../components/cart/NextCart.vue")['default']>
    'LazyCartProductImage': LazyComponent<typeof import("../components/cart/ProductImage.vue")['default']>
    'LazyCartProductPrice': LazyComponent<typeof import("../components/cart/ProductPrice.vue")['default']>
    'LazyCartStatisticsOthers': LazyComponent<typeof import("../components/cart/StatisticsOthers.vue")['default']>
    'LazyCartProducts': LazyComponent<typeof import("../components/cart/products.vue")['default']>
    'LazyCategoriesSearchSelectionCategory': LazyComponent<typeof import("../components/categories/SearchSelectionCategory.vue")['default']>
    'LazyCategoriesSelectBreadCrumbs': LazyComponent<typeof import("../components/categories/SelectBreadCrumbs.vue")['default']>
    'LazyColorSelectComponent': LazyComponent<typeof import("../components/color/SelectComponent.vue")['default']>
    'LazyColorShow': LazyComponent<typeof import("../components/color/Show.vue")['default']>
    'LazyCommentAddCommentBuyer': LazyComponent<typeof import("../components/comment/AddCommentBuyer.vue")['default']>
    'LazyCommentGalleryFiles': LazyComponent<typeof import("../components/comment/GalleryFiles.vue")['default']>
    'LazyCommentLikeDislikeSection': LazyComponent<typeof import("../components/comment/LikeDislikeSection.vue")['default']>
    'LazyCommentProductPage': LazyComponent<typeof import("../components/comment/ProductPage.vue")['default']>
    'LazyCommentScore': LazyComponent<typeof import("../components/comment/Score.vue")['default']>
    'LazyCommentStarRating': LazyComponent<typeof import("../components/comment/StarRating.vue")['default']>
    'LazyCommentVariationDetail': LazyComponent<typeof import("../components/comment/VariationDetail.vue")['default']>
    'LazyCommentView': LazyComponent<typeof import("../components/comment/View.vue")['default']>
    'LazyCommentCreateAddBodyStep': LazyComponent<typeof import("../components/comment/create/AddBodyStep.vue")['default']>
    'LazyCommentCreateAddScoreStep': LazyComponent<typeof import("../components/comment/create/AddScoreStep.vue")['default']>
    'LazyCommentCreateContainer': LazyComponent<typeof import("../components/comment/create/Container.vue")['default']>
    'LazyCommentCreateDialog': LazyComponent<typeof import("../components/comment/create/Dialog.vue")['default']>
    'LazyCommentCreateFooter': LazyComponent<typeof import("../components/comment/create/Footer.vue")['default']>
    'LazyCommentCreateHeader': LazyComponent<typeof import("../components/comment/create/Header.vue")['default']>
    'LazyCommentCreateLoadingOverlay': LazyComponent<typeof import("../components/comment/create/LoadingOverlay.vue")['default']>
    'LazyCommentCreateSoundRecording': LazyComponent<typeof import("../components/comment/create/SoundRecording.vue")['default']>
    'LazyCommentCreateUploadFile': LazyComponent<typeof import("../components/comment/create/UploadFile.vue")['default']>
    'LazyCommentDesktopProductPage': LazyComponent<typeof import("../components/comment/desktop/ProductPage.vue")['default']>
    'LazyCommentMobileOffcanvasList': LazyComponent<typeof import("../components/comment/mobile/OffcanvasList.vue")['default']>
    'LazyCommentMobileOffcanvasView': LazyComponent<typeof import("../components/comment/mobile/OffcanvasView.vue")['default']>
    'LazyCommentMobileProductPage': LazyComponent<typeof import("../components/comment/mobile/ProductPage.vue")['default']>
    'LazyCommentUserComments': LazyComponent<typeof import("../components/comment/user/Comments.vue")['default']>
    'LazyCommentUserInfo': LazyComponent<typeof import("../components/comment/user/Info.vue")['default']>
    'LazyCommentUserWaitingFeedback': LazyComponent<typeof import("../components/comment/user/WaitingFeedback.vue")['default']>
    'LazyComparisonProducts': LazyComponent<typeof import("../components/comparison/Products.vue")['default']>
    'LazyComparisonSelectionProducts': LazyComponent<typeof import("../components/comparison/SelectionProducts.vue")['default']>
    'LazyComparisonPage': LazyComponent<typeof import("../components/comparison/page.vue")['default']>
    'LazyCustomDeliveryDesktopSelectSendTime': LazyComponent<typeof import("../components/custom-delivery/DesktopSelectSendTime.vue")['default']>
    'LazyCustomDeliveryMobileSelectDateAndTime': LazyComponent<typeof import("../components/custom-delivery/MobileSelectDateAndTime.vue")['default']>
    'LazyCustomDeliverySelectDateAndTimeSlider': LazyComponent<typeof import("../components/custom-delivery/SelectDateAndTimeSlider.vue")['default']>
    'LazyCustomDeliveryShowSelectedDateAndTime': LazyComponent<typeof import("../components/custom-delivery/ShowSelectedDateAndTime.vue")['default']>
    'LazyCustomDeliverySubmissionInfo': LazyComponent<typeof import("../components/custom-delivery/SubmissionInfo.vue")['default']>
    'LazyCustomDeliverySummary': LazyComponent<typeof import("../components/custom-delivery/Summary.vue")['default']>
    'LazyDesignHtmlCode': LazyComponent<typeof import("../components/design/HtmlCode.vue")['default']>
    'LazyDesignParagraph': LazyComponent<typeof import("../components/design/Paragraph.vue")['default']>
    'LazyDesignPositionView': LazyComponent<typeof import("../components/design/PositionView.vue")['default']>
    'LazyDiscountRegisterCode': LazyComponent<typeof import("../components/discount/RegisterCode.vue")['default']>
    'LazyExpertReviewProduct': LazyComponent<typeof import("../components/expert-review/Product.vue")['default']>
    'LazyFaqCategories': LazyComponent<typeof import("../components/faq/Categories.vue")['default']>
    'LazyFaqContactUs': LazyComponent<typeof import("../components/faq/ContactUs.vue")['default']>
    'LazyFaqPopularQuestion': LazyComponent<typeof import("../components/faq/PopularQuestion.vue")['default']>
    'LazyFaqQuestionsList': LazyComponent<typeof import("../components/faq/QuestionsList.vue")['default']>
    'LazyFaqWidgetView': LazyComponent<typeof import("../components/faq/widget/view.vue")['default']>
    'LazyFavouriteShortCode': LazyComponent<typeof import("../components/favourite/ShortCode.vue")['default']>
    'LazyFavouriteUserList': LazyComponent<typeof import("../components/favourite/UserList.vue")['default']>
    'LazyFiltersColors': LazyComponent<typeof import("../components/filters/Colors.vue")['default']>
    'LazyFiltersDesktopView': LazyComponent<typeof import("../components/filters/DesktopView.vue")['default']>
    'LazyFiltersHasAvailable': LazyComponent<typeof import("../components/filters/HasAvailable.vue")['default']>
    'LazyFiltersList': LazyComponent<typeof import("../components/filters/List.vue")['default']>
    'LazyFiltersMobileView': LazyComponent<typeof import("../components/filters/MobileView.vue")['default']>
    'LazyFiltersPriceRange': LazyComponent<typeof import("../components/filters/PriceRange.vue")['default']>
    'LazyFiltersReadySend': LazyComponent<typeof import("../components/filters/ReadySend.vue")['default']>
    'LazyFinanceAddBankAccount': LazyComponent<typeof import("../components/finance/AddBankAccount.vue")['default']>
    'LazyFinanceMethodSelection': LazyComponent<typeof import("../components/finance/MethodSelection.vue")['default']>
    'LazyFormButton': LazyComponent<typeof import("../components/form/Button.vue")['default']>
    'LazyFormCheckBox': LazyComponent<typeof import("../components/form/CheckBox.vue")['default']>
    'LazyFormComponent': LazyComponent<typeof import("../components/form/Component.vue")['default']>
    'LazyFormDateInput': LazyComponent<typeof import("../components/form/DateInput.vue")['default']>
    'LazyFormRadio': LazyComponent<typeof import("../components/form/Radio.vue")['default']>
    'LazyFormSelectTag': LazyComponent<typeof import("../components/form/SelectTag.vue")['default']>
    'LazyFormTextInput': LazyComponent<typeof import("../components/form/TextInput.vue")['default']>
    'LazyFormSelectBottomSheet': LazyComponent<typeof import("../components/form/select/BottomSheet.vue")['default']>
    'LazyFormSelectListView': LazyComponent<typeof import("../components/form/select/ListView.vue")['default']>
    'LazyFormSelectModalList': LazyComponent<typeof import("../components/form/select/ModalList.vue")['default']>
    'LazyHomePaymentSelection': LazyComponent<typeof import("../components/home-payment/selection.vue")['default']>
    'LazyImageSearchUploadImage': LazyComponent<typeof import("../components/image-search/UploadImage.vue")['default']>
    'LazyNotificationsRequestAvailability': LazyComponent<typeof import("../components/notifications/RequestAvailability.vue")['default']>
    'LazyNotificationsRequestBox': LazyComponent<typeof import("../components/notifications/RequestBox.vue")['default']>
    'LazyNotificationsUserList': LazyComponent<typeof import("../components/notifications/UserList.vue")['default']>
    'LazyOnlinePaymentSelection': LazyComponent<typeof import("../components/online-payment/selection.vue")['default']>
    'LazyOrdersVerify': LazyComponent<typeof import("../components/orders/Verify.vue")['default']>
    'LazyOrdersCheckoutBottomNavigation': LazyComponent<typeof import("../components/orders/checkout/BottomNavigation.vue")['default']>
    'LazyOrdersCheckoutFactor': LazyComponent<typeof import("../components/orders/checkout/Factor.vue")['default']>
    'LazyOrdersCheckoutHeader': LazyComponent<typeof import("../components/orders/checkout/Header.vue")['default']>
    'LazyOrdersCheckoutProductsSlider': LazyComponent<typeof import("../components/orders/checkout/ProductsSlider.vue")['default']>
    'LazyOrdersCheckoutShortSubmissionsDetail': LazyComponent<typeof import("../components/orders/checkout/ShortSubmissionsDetail.vue")['default']>
    'LazyOrdersCheckoutSubmissionShippingCost': LazyComponent<typeof import("../components/orders/checkout/SubmissionShippingCost.vue")['default']>
    'LazyOrdersFactorCompany': LazyComponent<typeof import("../components/orders/factor/Company.vue")['default']>
    'LazyOrdersFactorProducts': LazyComponent<typeof import("../components/orders/factor/Products.vue")['default']>
    'LazyOrdersFactorUser': LazyComponent<typeof import("../components/orders/factor/User.vue")['default']>
    'LazyOrdersFactorView': LazyComponent<typeof import("../components/orders/factor/View.vue")['default']>
    'LazyOrdersUserAddressInfo': LazyComponent<typeof import("../components/orders/user/AddressInfo.vue")['default']>
    'LazyOrdersUserCancelledOrders': LazyComponent<typeof import("../components/orders/user/CancelledOrders.vue")['default']>
    'LazyOrdersUserCurrentOrders': LazyComponent<typeof import("../components/orders/user/CurrentOrders.vue")['default']>
    'LazyOrdersUserDetailItems': LazyComponent<typeof import("../components/orders/user/DetailItems.vue")['default']>
    'LazyOrdersUserFactorLink': LazyComponent<typeof import("../components/orders/user/FactorLink.vue")['default']>
    'LazyOrdersUserOrderProducts': LazyComponent<typeof import("../components/orders/user/OrderProducts.vue")['default']>
    'LazyOrdersUserOrderStatistics': LazyComponent<typeof import("../components/orders/user/OrderStatistics.vue")['default']>
    'LazyOrdersUserOrdersList': LazyComponent<typeof import("../components/orders/user/OrdersList.vue")['default']>
    'LazyOrdersUserPaymentHistory': LazyComponent<typeof import("../components/orders/user/PaymentHistory.vue")['default']>
    'LazyOrdersUserReturnProducts': LazyComponent<typeof import("../components/orders/user/ReturnProducts.vue")['default']>
    'LazyOrdersUserReturnedOrders': LazyComponent<typeof import("../components/orders/user/ReturnedOrders.vue")['default']>
    'LazyOrdersUserSentOrders': LazyComponent<typeof import("../components/orders/user/SentOrders.vue")['default']>
    'LazyOrdersUserSubmission': LazyComponent<typeof import("../components/orders/user/Submission.vue")['default']>
    'LazyOrdersUserSubmissionProducts': LazyComponent<typeof import("../components/orders/user/SubmissionProducts.vue")['default']>
    'LazyPostalDeliverySubmissionInfo': LazyComponent<typeof import("../components/postal-delivery/SubmissionInfo.vue")['default']>
    'LazyPriceChangesShortCut': LazyComponent<typeof import("../components/price-changes/ShortCut.vue")['default']>
    'LazyPriceVariationCartDetail': LazyComponent<typeof import("../components/priceVariation/CartDetail.vue")['default']>
    'LazyPriceVariationDetail': LazyComponent<typeof import("../components/priceVariation/Detail.vue")['default']>
    'LazyPriceVariationDiscountPercentage': LazyComponent<typeof import("../components/priceVariation/DiscountPercentage.vue")['default']>
    'LazyPriceVariationItems': LazyComponent<typeof import("../components/priceVariation/Items.vue")['default']>
    'LazyPriceVariationNotifications': LazyComponent<typeof import("../components/priceVariation/Notifications.vue")['default']>
    'LazyPriceVariationPriceBox': LazyComponent<typeof import("../components/priceVariation/PriceBox.vue")['default']>
    'LazyPriceVariationProductFinalPrice': LazyComponent<typeof import("../components/priceVariation/ProductFinalPrice.vue")['default']>
    'LazyPriceVariationProductOldPrice': LazyComponent<typeof import("../components/priceVariation/ProductOldPrice.vue")['default']>
    'LazyPriceVariationSelectVariationBtn': LazyComponent<typeof import("../components/priceVariation/SelectVariationBtn.vue")['default']>
    'LazyPriceVariationSellerPerformance': LazyComponent<typeof import("../components/priceVariation/SellerPerformance.vue")['default']>
    'LazyPriceVariationSellerPerformanceDetail': LazyComponent<typeof import("../components/priceVariation/SellerPerformanceDetail.vue")['default']>
    'LazyPriceVariationSendDetail': LazyComponent<typeof import("../components/priceVariation/SendDetail.vue")['default']>
    'LazyPriceVariationShortDetail': LazyComponent<typeof import("../components/priceVariation/ShortDetail.vue")['default']>
    'LazyPriceVariationStatusInWarehouse': LazyComponent<typeof import("../components/priceVariation/StatusInWarehouse.vue")['default']>
    'LazyPriceVariationStockNotice': LazyComponent<typeof import("../components/priceVariation/StockNotice.vue")['default']>
    'LazyPriceVariationAllListDesktop': LazyComponent<typeof import("../components/priceVariation/all-list/Desktop.vue")['default']>
    'LazyProductPageAppBar': LazyComponent<typeof import("../components/product-page/AppBar.vue")['default']>
    'LazyProductPageBottomNavigation': LazyComponent<typeof import("../components/product-page/BottomNavigation.vue")['default']>
    'LazyProductPageInformation': LazyComponent<typeof import("../components/product-page/Information.vue")['default']>
    'LazyProductPageIntroduction': LazyComponent<typeof import("../components/product-page/Introduction.vue")['default']>
    'LazyProductPageOffcanvasTabs': LazyComponent<typeof import("../components/product-page/OffcanvasTabs.vue")['default']>
    'LazyProductPageOptions': LazyComponent<typeof import("../components/product-page/Options.vue")['default']>
    'LazyProductPagePurchaseFeatures': LazyComponent<typeof import("../components/product-page/PurchaseFeatures.vue")['default']>
    'LazyProductPageReturnConditions': LazyComponent<typeof import("../components/product-page/ReturnConditions.vue")['default']>
    'LazyProductPageTabs': LazyComponent<typeof import("../components/product-page/Tabs.vue")['default']>
    'LazyProductPageGalleryDesktop': LazyComponent<typeof import("../components/product-page/gallery/Desktop.vue")['default']>
    'LazyProductPageGalleryMobile': LazyComponent<typeof import("../components/product-page/gallery/Mobile.vue")['default']>
    'LazyProductPageGallerySmallSlider': LazyComponent<typeof import("../components/product-page/gallery/SmallSlider.vue")['default']>
    'LazyProductPageGalleryTabSlider': LazyComponent<typeof import("../components/product-page/gallery/TabSlider.vue")['default']>
    'LazyPromotionsAmazingDay': LazyComponent<typeof import("../components/promotions/AmazingDay.vue")['default']>
    'LazyPromotionsAmazingOffers': LazyComponent<typeof import("../components/promotions/AmazingOffers.vue")['default']>
    'LazyPromotionsCategoriesSlider': LazyComponent<typeof import("../components/promotions/CategoriesSlider.vue")['default']>
    'LazyPromotionsDisplayOfferLabel': LazyComponent<typeof import("../components/promotions/DisplayOfferLabel.vue")['default']>
    'LazyPromotionsIncredibleOffersAppBar': LazyComponent<typeof import("../components/promotions/IncredibleOffersAppBar.vue")['default']>
    'LazyPromotionsProductFooter': LazyComponent<typeof import("../components/promotions/ProductFooter.vue")['default']>
    'LazyPromotionsSelectedOffersSlider': LazyComponent<typeof import("../components/promotions/SelectedOffersSlider.vue")['default']>
    'LazyPromotionsShortCode': LazyComponent<typeof import("../components/promotions/ShortCode.vue")['default']>
    'LazyQuestionsAnswers': LazyComponent<typeof import("../components/questions/Answers.vue")['default']>
    'LazyQuestionsFormBox': LazyComponent<typeof import("../components/questions/FormBox.vue")['default']>
    'LazyQuestionsLikeDislikeSection': LazyComponent<typeof import("../components/questions/LikeDislikeSection.vue")['default']>
    'LazyQuestionsOffcanvasList': LazyComponent<typeof import("../components/questions/OffcanvasList.vue")['default']>
    'LazyQuestionsProductPage': LazyComponent<typeof import("../components/questions/ProductPage.vue")['default']>
    'LazyQuestionsView': LazyComponent<typeof import("../components/questions/View.vue")['default']>
    'LazyQuestionsDesktopProductPage': LazyComponent<typeof import("../components/questions/desktop/ProductPage.vue")['default']>
    'LazyQuestionsMobileOffcanvasView': LazyComponent<typeof import("../components/questions/mobile/OffcanvasView.vue")['default']>
    'LazyQuestionsMobileProductPage': LazyComponent<typeof import("../components/questions/mobile/ProductPage.vue")['default']>
    'LazyQuestionsUserList': LazyComponent<typeof import("../components/questions/user/List.vue")['default']>
    'LazySellersFilterItem': LazyComponent<typeof import("../components/sellers/FilterItem.vue")['default']>
    'LazyShareIcon': LazyComponent<typeof import("../components/share/Icon.vue")['default']>
    'LazyShareShortCode': LazyComponent<typeof import("../components/share/ShortCode.vue")['default']>
    'LazySiteAppBarSetting': LazyComponent<typeof import("../components/site/AppBarSetting.vue")['default']>
    'LazySlidersView': LazyComponent<typeof import("../components/sliders/view.vue")['default']>
    'LazySpecificationsDesktopView': LazyComponent<typeof import("../components/specifications/DesktopView.vue")['default']>
    'LazySpecificationsImportant': LazyComponent<typeof import("../components/specifications/Important.vue")['default']>
    'LazySpecificationsMobileView': LazyComponent<typeof import("../components/specifications/MobileView.vue")['default']>
    'LazySpecificationsProduct': LazyComponent<typeof import("../components/specifications/Product.vue")['default']>
    'LazySpecificationsShortCode': LazyComponent<typeof import("../components/specifications/ShortCode.vue")['default']>
    'LazyStatisticsLastWeekSales': LazyComponent<typeof import("../components/statistics/LastWeekSales.vue")['default']>
    'LazyStatisticsRecentDay': LazyComponent<typeof import("../components/statistics/RecentDay.vue")['default']>
    'LazyTableActions': LazyComponent<typeof import("../components/table/Actions.vue")['default']>
    'LazyTableActionsBox': LazyComponent<typeof import("../components/table/ActionsBox.vue")['default']>
    'LazyTableColumnView': LazyComponent<typeof import("../components/table/ColumnView.vue")['default']>
    'LazyTableColumnsDateColumn': LazyComponent<typeof import("../components/table/Columns/DateColumn.vue")['default']>
    'LazyTableColumnsNumberColumn': LazyComponent<typeof import("../components/table/Columns/NumberColumn.vue")['default']>
    'LazyTableColumnsStatusColumn': LazyComponent<typeof import("../components/table/Columns/StatusColumn.vue")['default']>
    'LazyTableColumnsTimeColumn': LazyComponent<typeof import("../components/table/Columns/TimeColumn.vue")['default']>
    'LazyTableComponent': LazyComponent<typeof import("../components/table/Component.vue")['default']>
    'LazyTableDeleteLink': LazyComponent<typeof import("../components/table/DeleteLink.vue")['default']>
    'LazyTableDetailOffcanvas': LazyComponent<typeof import("../components/table/DetailOffcanvas.vue")['default']>
    'LazyTableDetailView': LazyComponent<typeof import("../components/table/DetailView.vue")['default']>
    'LazyTableEditLink': LazyComponent<typeof import("../components/table/EditLink.vue")['default']>
    'LazyTableRestoreLink': LazyComponent<typeof import("../components/table/RestoreLink.vue")['default']>
    'LazyThemeAuctionProducts': LazyComponent<typeof import("../components/theme/AuctionProducts.vue")['default']>
    'LazyThemeMainCategories': LazyComponent<typeof import("../components/theme/MainCategories.vue")['default']>
    'LazyThemeNotFound': LazyComponent<typeof import("../components/theme/NotFound.vue")['default']>
    'LazyThemeProductsBasedOnTaste': LazyComponent<typeof import("../components/theme/ProductsBasedOnTaste.vue")['default']>
    'LazyThemeSupportItems': LazyComponent<typeof import("../components/theme/SupportItems.vue")['default']>
    'LazyThemeDesktopHeader': LazyComponent<typeof import("../components/theme/desktop/Header.vue")['default']>
    'LazyThemeDesktopHeaderMenus': LazyComponent<typeof import("../components/theme/desktop/HeaderMenus.vue")['default']>
    'LazyThemeDesktopMegaMenu': LazyComponent<typeof import("../components/theme/desktop/MegaMenu.vue")['default']>
    'LazyThemeDesktopSearchProducts': LazyComponent<typeof import("../components/theme/desktop/SearchProducts.vue")['default']>
    'LazyThemeFastSearchCategories': LazyComponent<typeof import("../components/theme/fast-search/Categories.vue")['default']>
    'LazyThemeFastSearchInput': LazyComponent<typeof import("../components/theme/fast-search/Input.vue")['default']>
    'LazyThemeFastSearchPopularSearch': LazyComponent<typeof import("../components/theme/fast-search/PopularSearch.vue")['default']>
    'LazyThemeFastSearchRecent': LazyComponent<typeof import("../components/theme/fast-search/Recent.vue")['default']>
    'LazyThemeFastSearchResult': LazyComponent<typeof import("../components/theme/fast-search/Result.vue")['default']>
    'LazyThemeFastSearchSimilarPhrases': LazyComponent<typeof import("../components/theme/fast-search/SimilarPhrases.vue")['default']>
    'LazyThemeFooterNewsletterForm': LazyComponent<typeof import("../components/theme/footer/NewsletterForm.vue")['default']>
    'LazyThemeFooterSocialNetworks': LazyComponent<typeof import("../components/theme/footer/SocialNetworks.vue")['default']>
    'LazyThemeFooterSupport': LazyComponent<typeof import("../components/theme/footer/Support.vue")['default']>
    'LazyThemeFooterView': LazyComponent<typeof import("../components/theme/footer/View.vue")['default']>
    'LazyThemeMobileAppBar': LazyComponent<typeof import("../components/theme/mobile/AppBar.vue")['default']>
    'LazyThemeMobileBottomNavigationBar': LazyComponent<typeof import("../components/theme/mobile/BottomNavigationBar.vue")['default']>
    'LazyThemeMobileSearchProducts': LazyComponent<typeof import("../components/theme/mobile/SearchProducts.vue")['default']>
    'LazyThemeMobileSearchProductsAppbar': LazyComponent<typeof import("../components/theme/mobile/SearchProductsAppbar.vue")['default']>
    'LazyThemeProductSliderGridList': LazyComponent<typeof import("../components/theme/product-slider/GridList.vue")['default']>
    'LazyThemeProductSliderHorizontalList': LazyComponent<typeof import("../components/theme/product-slider/HorizontalList.vue")['default']>
    'LazyThemeProductSliderHorizontalView': LazyComponent<typeof import("../components/theme/product-slider/HorizontalView.vue")['default']>
    'LazyThemeProductSliderMultiRow': LazyComponent<typeof import("../components/theme/product-slider/MultiRow.vue")['default']>
    'LazyThemeProductSliderVerticalView': LazyComponent<typeof import("../components/theme/product-slider/VerticalView.vue")['default']>
    'LazyThemeProductSliderView': LazyComponent<typeof import("../components/theme/product-slider/View.vue")['default']>
    'LazyThemeSearchAppBarItems': LazyComponent<typeof import("../components/theme/search/AppBarItems.vue")['default']>
    'LazyThemeSearchBeforeProductView': LazyComponent<typeof import("../components/theme/search/BeforeProductView.vue")['default']>
    'LazyThemeSearchNotFound': LazyComponent<typeof import("../components/theme/search/NotFound.vue")['default']>
    'LazyThemeSearchProductColors': LazyComponent<typeof import("../components/theme/search/ProductColors.vue")['default']>
    'LazyThemeSearchProductLoading': LazyComponent<typeof import("../components/theme/search/ProductLoading.vue")['default']>
    'LazyThemeSearchProductPrice': LazyComponent<typeof import("../components/theme/search/ProductPrice.vue")['default']>
    'LazyThemeSearchProductView': LazyComponent<typeof import("../components/theme/search/ProductView.vue")['default']>
    'LazyThemeSearchView': LazyComponent<typeof import("../components/theme/search/View.vue")['default']>
    'LazyThemeWidgetsBanners': LazyComponent<typeof import("../components/theme/widgets/Banners.vue")['default']>
    'LazyThemeWidgetsLatestHot': LazyComponent<typeof import("../components/theme/widgets/LatestHot.vue")['default']>
    'LazyThemeWidgetsMoreText': LazyComponent<typeof import("../components/theme/widgets/MoreText.vue")['default']>
    'LazyThemeWidgetsProductSlider': LazyComponent<typeof import("../components/theme/widgets/ProductSlider.vue")['default']>
    'LazyThemeWidgetsSelectedCategories': LazyComponent<typeof import("../components/theme/widgets/SelectedCategories.vue")['default']>
    'LazyUsersDesktopProfileLink': LazyComponent<typeof import("../components/users/DesktopProfileLink.vue")['default']>
    'LazyUsersLayout': LazyComponent<typeof import("../components/users/Layout.vue")['default']>
    'LazyUsersLogout': LazyComponent<typeof import("../components/users/Logout.vue")['default']>
    'LazyUsersReceiveVerificationCode': LazyComponent<typeof import("../components/users/ReceiveVerificationCode.vue")['default']>
    'LazyUsersRemoveRequestBtn': LazyComponent<typeof import("../components/users/RemoveRequestBtn.vue")['default']>
    'LazyUsersAuthOneTimePassword': LazyComponent<typeof import("../components/users/auth/OneTimePassword.vue")['default']>
    'LazyUsersLegalAccountDeleteDialog': LazyComponent<typeof import("../components/users/legal-account/DeleteDialog.vue")['default']>
    'LazyUsersLegalAccountForm': LazyComponent<typeof import("../components/users/legal-account/Form.vue")['default']>
    'LazyUsersLegalAccountInfo': LazyComponent<typeof import("../components/users/legal-account/Info.vue")['default']>
    'LazyUsersPanelAppBar': LazyComponent<typeof import("../components/users/panel/AppBar.vue")['default']>
    'LazyUsersPanelBox': LazyComponent<typeof import("../components/users/panel/Box.vue")['default']>
    'LazyUsersPanelEmptyList': LazyComponent<typeof import("../components/users/panel/EmptyList.vue")['default']>
    'LazyUsersPanelInfo': LazyComponent<typeof import("../components/users/panel/Info.vue")['default']>
    'LazyUsersPanelMenus': LazyComponent<typeof import("../components/users/panel/Menus.vue")['default']>
    'LazyUsersPersonalInfoEditBirthday': LazyComponent<typeof import("../components/users/personalInfo/EditBirthday.vue")['default']>
    'LazyUsersPersonalInfoEditEmail': LazyComponent<typeof import("../components/users/personalInfo/EditEmail.vue")['default']>
    'LazyUsersPersonalInfoEditMobileNumber': LazyComponent<typeof import("../components/users/personalInfo/EditMobileNumber.vue")['default']>
    'LazyUsersPersonalInfoEditNameForm': LazyComponent<typeof import("../components/users/personalInfo/EditNameForm.vue")['default']>
    'LazyUsersPersonalInfoEditPassword': LazyComponent<typeof import("../components/users/personalInfo/EditPassword.vue")['default']>
    'LazyUsersPersonalInfoHowReturnMoney': LazyComponent<typeof import("../components/users/personalInfo/HowReturnMoney.vue")['default']>
    'LazyWalletBalance': LazyComponent<typeof import("../components/wallet/Balance.vue")['default']>
    'LazyWalletChargeForm': LazyComponent<typeof import("../components/wallet/ChargeForm.vue")['default']>
    'LazyWalletMethodSelection': LazyComponent<typeof import("../components/wallet/MethodSelection.vue")['default']>
    'LazyWalletPaymentForOrder': LazyComponent<typeof import("../components/wallet/WalletPaymentForOrder.vue")['default']>
    'LazyWalletTableAmountColumn': LazyComponent<typeof import("../components/wallet/table/AmountColumn.vue")['default']>
    'LazyWarrantyShow': LazyComponent<typeof import("../components/warranty/Show.vue")['default']>
    'LazyNuxtWelcome': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/welcome.vue")['default']>
    'LazyNuxtLayout': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-layout")['default']>
    'LazyNuxtErrorBoundary': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-error-boundary.vue")['default']>
    'LazyClientOnly': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/client-only")['default']>
    'LazyDevOnly': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/dev-only")['default']>
    'LazyServerPlaceholder': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/server-placeholder")['default']>
    'LazyNuxtLink': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-link")['default']>
    'LazyNuxtLoadingIndicator': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-loading-indicator")['default']>
    'LazyNuxtTime': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-time.vue")['default']>
    'LazyNuxtRouteAnnouncer': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-route-announcer")['default']>
    'LazyNuxtImg': LazyComponent<typeof import("../node_modules/@nuxt/image/dist/runtime/components/NuxtImg.vue")['default']>
    'LazyNuxtPicture': LazyComponent<typeof import("../node_modules/@nuxt/image/dist/runtime/components/NuxtPicture.vue")['default']>
    'LazyLCircle': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LCircle']>
    'LazyLCircleMarker': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LCircleMarker']>
    'LazyLControl': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControl']>
    'LazyLControlAttribution': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControlAttribution']>
    'LazyLControlLayers': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControlLayers']>
    'LazyLControlScale': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControlScale']>
    'LazyLControlZoom': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControlZoom']>
    'LazyLFeatureGroup': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LFeatureGroup']>
    'LazyLGeoJson': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LGeoJson']>
    'LazyLIcon': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LIcon']>
    'LazyLImageOverlay': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LImageOverlay']>
    'LazyLLayerGroup': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LLayerGroup']>
    'LazyLMap': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LMap']>
    'LazyLMarker': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LMarker']>
    'LazyLPolygon': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LPolygon']>
    'LazyLPolyline': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LPolyline']>
    'LazyLPopup': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LPopup']>
    'LazyLRectangle': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LRectangle']>
    'LazyLTileLayer': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LTileLayer']>
    'LazyLTooltip': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LTooltip']>
    'LazyLWmsTileLayer': LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LWmsTileLayer']>
    'LazyVitePwaManifest': LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/VitePwaManifest")['default']>
    'LazyNuxtPwaManifest': LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/VitePwaManifest")['default']>
    'LazyNuxtPwaAssets': LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/NuxtPwaAssets")['default']>
    'LazyPwaAppleImage': LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaAppleImage.vue")['default']>
    'LazyPwaAppleSplashScreenImage': LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaAppleSplashScreenImage.vue")['default']>
    'LazyPwaFaviconImage': LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaFaviconImage.vue")['default']>
    'LazyPwaMaskableImage': LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaMaskableImage.vue")['default']>
    'LazyPwaTransparentImage': LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaTransparentImage.vue")['default']>
    'LazyNuxtPage': LazyComponent<typeof import("../node_modules/nuxt/dist/pages/runtime/page")['default']>
    'LazyNoScript': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['NoScript']>
    'LazyLink': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Link']>
    'LazyBase': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Base']>
    'LazyTitle': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Title']>
    'LazyMeta': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Meta']>
    'LazyStyle': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Style']>
    'LazyHead': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Head']>
    'LazyHtml': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Html']>
    'LazyBody': LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Body']>
    'LazyNuxtIsland': LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-island")['default']>
    'LazyNuxtRouteAnnouncer': LazyComponent<IslandComponent<typeof import("../node_modules/nuxt/dist/app/components/server-placeholder")['default']>>
}

declare module 'vue' {
  export interface GlobalComponents extends _GlobalComponents { }
}

export const IconBadge: typeof import("../components/IconBadge.vue")['default']
export const IconsToman: typeof import("../components/Icons/Toman.vue")['default']
export const Loading: typeof import("../components/Loading.vue")['default']
export const Modal: typeof import("../components/Modal.vue")['default']
export const Offcanvas: typeof import("../components/Offcanvas.vue")['default']
export const OpacityOffcanvas: typeof import("../components/OpacityOffcanvas.vue")['default']
export const Pagination: typeof import("../components/Pagination.vue")['default']
export const RangeSlider: typeof import("../components/RangeSlider.vue")['default']
export const RepairMode: typeof import("../components/RepairMode.vue")['default']
export const ReportPriceForm: typeof import("../components/ReportPrice/Form.vue")['default']
export const ReportWrongForm: typeof import("../components/ReportWrong/Form.vue")['default']
export const Scaffold: typeof import("../components/Scaffold.vue")['default']
export const ServerErrors: typeof import("../components/ServerErrors.vue")['default']
export const Skeleton: typeof import("../components/Skeleton.vue")['default']
export const Tabs: typeof import("../components/Tabs.vue")['default']
export const TimeAgo: typeof import("../components/TimeAgo.vue")['default']
export const Timer: typeof import("../components/Timer.vue")['default']
export const Toast: typeof import("../components/Toast.vue")['default']
export const ToggleSlide: typeof import("../components/ToggleSlide.vue")['default']
export const Tooltip: typeof import("../components/Tooltip.vue")['default']
export const AddressesCreateOrEdit: typeof import("../components/addresses/CreateOrEdit.vue")['default']
export const AddressesDetail: typeof import("../components/addresses/Detail.vue")['default']
export const AddressesForm: typeof import("../components/addresses/Form.vue")['default']
export const AddressesOptionsUl: typeof import("../components/addresses/OptionsUl.vue")['default']
export const AddressesSelectLocation: typeof import("../components/addresses/SelectLocation.vue")['default']
export const AddressesSelectionList: typeof import("../components/addresses/SelectionList.vue")['default']
export const AddressesShortDetail: typeof import("../components/addresses/ShortDetail.vue")['default']
export const AddressesTable: typeof import("../components/addresses/Table.vue")['default']
export const AddressesTableOptions: typeof import("../components/addresses/TableOptions.vue")['default']
export const AdsFetchProducts: typeof import("../components/ads/FetchProducts.vue")['default']
export const AdsShowAdsInSidebar: typeof import("../components/ads/ShowAdsInSidebar.vue")['default']
export const AdsShowProductAdsLabel: typeof import("../components/ads/ShowProductAdsLabel.vue")['default']
export const AreaSelectCity: typeof import("../components/area/SelectCity.vue")['default']
export const AreaSelectDefault: typeof import("../components/area/SelectDefault.vue")['default']
export const AreaSelectProvince: typeof import("../components/area/SelectProvince.vue")['default']
export const BlogGridList: typeof import("../components/blog/GridList.vue")['default']
export const BlogPosts: typeof import("../components/blog/Posts.vue")['default']
export const BlogSlider: typeof import("../components/blog/Slider.vue")['default']
export const BrandsSearchSelectBrand: typeof import("../components/brands/SearchSelectBrand.vue")['default']
export const BrandsSearchSelectionCategory: typeof import("../components/brands/SearchSelectionCategory.vue")['default']
export const BrandsSlider: typeof import("../components/brands/Slider.vue")['default']
export const CartAction: typeof import("../components/cart/Action.vue")['default']
export const CartAddBtn: typeof import("../components/cart/AddBtn.vue")['default']
export const CartAllTransferDialog: typeof import("../components/cart/AllTransferDialog.vue")['default']
export const CartAppBar: typeof import("../components/cart/AppBar.vue")['default']
export const CartCurrentAction: typeof import("../components/cart/CurrentAction.vue")['default']
export const CartCurrentCart: typeof import("../components/cart/CurrentCart.vue")['default']
export const CartDesktopIcon: typeof import("../components/cart/DesktopIcon.vue")['default']
export const CartFactor: typeof import("../components/cart/Factor.vue")['default']
export const CartIcon: typeof import("../components/cart/Icon.vue")['default']
export const CartNextCart: typeof import("../components/cart/NextCart.vue")['default']
export const CartProductImage: typeof import("../components/cart/ProductImage.vue")['default']
export const CartProductPrice: typeof import("../components/cart/ProductPrice.vue")['default']
export const CartStatisticsOthers: typeof import("../components/cart/StatisticsOthers.vue")['default']
export const CartProducts: typeof import("../components/cart/products.vue")['default']
export const CategoriesSearchSelectionCategory: typeof import("../components/categories/SearchSelectionCategory.vue")['default']
export const CategoriesSelectBreadCrumbs: typeof import("../components/categories/SelectBreadCrumbs.vue")['default']
export const ColorSelectComponent: typeof import("../components/color/SelectComponent.vue")['default']
export const ColorShow: typeof import("../components/color/Show.vue")['default']
export const CommentAddCommentBuyer: typeof import("../components/comment/AddCommentBuyer.vue")['default']
export const CommentGalleryFiles: typeof import("../components/comment/GalleryFiles.vue")['default']
export const CommentLikeDislikeSection: typeof import("../components/comment/LikeDislikeSection.vue")['default']
export const CommentProductPage: typeof import("../components/comment/ProductPage.vue")['default']
export const CommentScore: typeof import("../components/comment/Score.vue")['default']
export const CommentStarRating: typeof import("../components/comment/StarRating.vue")['default']
export const CommentVariationDetail: typeof import("../components/comment/VariationDetail.vue")['default']
export const CommentView: typeof import("../components/comment/View.vue")['default']
export const CommentCreateAddBodyStep: typeof import("../components/comment/create/AddBodyStep.vue")['default']
export const CommentCreateAddScoreStep: typeof import("../components/comment/create/AddScoreStep.vue")['default']
export const CommentCreateContainer: typeof import("../components/comment/create/Container.vue")['default']
export const CommentCreateDialog: typeof import("../components/comment/create/Dialog.vue")['default']
export const CommentCreateFooter: typeof import("../components/comment/create/Footer.vue")['default']
export const CommentCreateHeader: typeof import("../components/comment/create/Header.vue")['default']
export const CommentCreateLoadingOverlay: typeof import("../components/comment/create/LoadingOverlay.vue")['default']
export const CommentCreateSoundRecording: typeof import("../components/comment/create/SoundRecording.vue")['default']
export const CommentCreateUploadFile: typeof import("../components/comment/create/UploadFile.vue")['default']
export const CommentDesktopProductPage: typeof import("../components/comment/desktop/ProductPage.vue")['default']
export const CommentMobileOffcanvasList: typeof import("../components/comment/mobile/OffcanvasList.vue")['default']
export const CommentMobileOffcanvasView: typeof import("../components/comment/mobile/OffcanvasView.vue")['default']
export const CommentMobileProductPage: typeof import("../components/comment/mobile/ProductPage.vue")['default']
export const CommentUserComments: typeof import("../components/comment/user/Comments.vue")['default']
export const CommentUserInfo: typeof import("../components/comment/user/Info.vue")['default']
export const CommentUserWaitingFeedback: typeof import("../components/comment/user/WaitingFeedback.vue")['default']
export const ComparisonProducts: typeof import("../components/comparison/Products.vue")['default']
export const ComparisonSelectionProducts: typeof import("../components/comparison/SelectionProducts.vue")['default']
export const ComparisonPage: typeof import("../components/comparison/page.vue")['default']
export const CustomDeliveryDesktopSelectSendTime: typeof import("../components/custom-delivery/DesktopSelectSendTime.vue")['default']
export const CustomDeliveryMobileSelectDateAndTime: typeof import("../components/custom-delivery/MobileSelectDateAndTime.vue")['default']
export const CustomDeliverySelectDateAndTimeSlider: typeof import("../components/custom-delivery/SelectDateAndTimeSlider.vue")['default']
export const CustomDeliveryShowSelectedDateAndTime: typeof import("../components/custom-delivery/ShowSelectedDateAndTime.vue")['default']
export const CustomDeliverySubmissionInfo: typeof import("../components/custom-delivery/SubmissionInfo.vue")['default']
export const CustomDeliverySummary: typeof import("../components/custom-delivery/Summary.vue")['default']
export const DesignHtmlCode: typeof import("../components/design/HtmlCode.vue")['default']
export const DesignParagraph: typeof import("../components/design/Paragraph.vue")['default']
export const DesignPositionView: typeof import("../components/design/PositionView.vue")['default']
export const DiscountRegisterCode: typeof import("../components/discount/RegisterCode.vue")['default']
export const ExpertReviewProduct: typeof import("../components/expert-review/Product.vue")['default']
export const FaqCategories: typeof import("../components/faq/Categories.vue")['default']
export const FaqContactUs: typeof import("../components/faq/ContactUs.vue")['default']
export const FaqPopularQuestion: typeof import("../components/faq/PopularQuestion.vue")['default']
export const FaqQuestionsList: typeof import("../components/faq/QuestionsList.vue")['default']
export const FaqWidgetView: typeof import("../components/faq/widget/view.vue")['default']
export const FavouriteShortCode: typeof import("../components/favourite/ShortCode.vue")['default']
export const FavouriteUserList: typeof import("../components/favourite/UserList.vue")['default']
export const FiltersColors: typeof import("../components/filters/Colors.vue")['default']
export const FiltersDesktopView: typeof import("../components/filters/DesktopView.vue")['default']
export const FiltersHasAvailable: typeof import("../components/filters/HasAvailable.vue")['default']
export const FiltersList: typeof import("../components/filters/List.vue")['default']
export const FiltersMobileView: typeof import("../components/filters/MobileView.vue")['default']
export const FiltersPriceRange: typeof import("../components/filters/PriceRange.vue")['default']
export const FiltersReadySend: typeof import("../components/filters/ReadySend.vue")['default']
export const FinanceAddBankAccount: typeof import("../components/finance/AddBankAccount.vue")['default']
export const FinanceMethodSelection: typeof import("../components/finance/MethodSelection.vue")['default']
export const FormButton: typeof import("../components/form/Button.vue")['default']
export const FormCheckBox: typeof import("../components/form/CheckBox.vue")['default']
export const FormComponent: typeof import("../components/form/Component.vue")['default']
export const FormDateInput: typeof import("../components/form/DateInput.vue")['default']
export const FormRadio: typeof import("../components/form/Radio.vue")['default']
export const FormSelectTag: typeof import("../components/form/SelectTag.vue")['default']
export const FormTextInput: typeof import("../components/form/TextInput.vue")['default']
export const FormSelectBottomSheet: typeof import("../components/form/select/BottomSheet.vue")['default']
export const FormSelectListView: typeof import("../components/form/select/ListView.vue")['default']
export const FormSelectModalList: typeof import("../components/form/select/ModalList.vue")['default']
export const HomePaymentSelection: typeof import("../components/home-payment/selection.vue")['default']
export const ImageSearchUploadImage: typeof import("../components/image-search/UploadImage.vue")['default']
export const NotificationsRequestAvailability: typeof import("../components/notifications/RequestAvailability.vue")['default']
export const NotificationsRequestBox: typeof import("../components/notifications/RequestBox.vue")['default']
export const NotificationsUserList: typeof import("../components/notifications/UserList.vue")['default']
export const OnlinePaymentSelection: typeof import("../components/online-payment/selection.vue")['default']
export const OrdersVerify: typeof import("../components/orders/Verify.vue")['default']
export const OrdersCheckoutBottomNavigation: typeof import("../components/orders/checkout/BottomNavigation.vue")['default']
export const OrdersCheckoutFactor: typeof import("../components/orders/checkout/Factor.vue")['default']
export const OrdersCheckoutHeader: typeof import("../components/orders/checkout/Header.vue")['default']
export const OrdersCheckoutProductsSlider: typeof import("../components/orders/checkout/ProductsSlider.vue")['default']
export const OrdersCheckoutShortSubmissionsDetail: typeof import("../components/orders/checkout/ShortSubmissionsDetail.vue")['default']
export const OrdersCheckoutSubmissionShippingCost: typeof import("../components/orders/checkout/SubmissionShippingCost.vue")['default']
export const OrdersFactorCompany: typeof import("../components/orders/factor/Company.vue")['default']
export const OrdersFactorProducts: typeof import("../components/orders/factor/Products.vue")['default']
export const OrdersFactorUser: typeof import("../components/orders/factor/User.vue")['default']
export const OrdersFactorView: typeof import("../components/orders/factor/View.vue")['default']
export const OrdersUserAddressInfo: typeof import("../components/orders/user/AddressInfo.vue")['default']
export const OrdersUserCancelledOrders: typeof import("../components/orders/user/CancelledOrders.vue")['default']
export const OrdersUserCurrentOrders: typeof import("../components/orders/user/CurrentOrders.vue")['default']
export const OrdersUserDetailItems: typeof import("../components/orders/user/DetailItems.vue")['default']
export const OrdersUserFactorLink: typeof import("../components/orders/user/FactorLink.vue")['default']
export const OrdersUserOrderProducts: typeof import("../components/orders/user/OrderProducts.vue")['default']
export const OrdersUserOrderStatistics: typeof import("../components/orders/user/OrderStatistics.vue")['default']
export const OrdersUserOrdersList: typeof import("../components/orders/user/OrdersList.vue")['default']
export const OrdersUserPaymentHistory: typeof import("../components/orders/user/PaymentHistory.vue")['default']
export const OrdersUserReturnProducts: typeof import("../components/orders/user/ReturnProducts.vue")['default']
export const OrdersUserReturnedOrders: typeof import("../components/orders/user/ReturnedOrders.vue")['default']
export const OrdersUserSentOrders: typeof import("../components/orders/user/SentOrders.vue")['default']
export const OrdersUserSubmission: typeof import("../components/orders/user/Submission.vue")['default']
export const OrdersUserSubmissionProducts: typeof import("../components/orders/user/SubmissionProducts.vue")['default']
export const PostalDeliverySubmissionInfo: typeof import("../components/postal-delivery/SubmissionInfo.vue")['default']
export const PriceChangesShortCut: typeof import("../components/price-changes/ShortCut.vue")['default']
export const PriceVariationCartDetail: typeof import("../components/priceVariation/CartDetail.vue")['default']
export const PriceVariationDetail: typeof import("../components/priceVariation/Detail.vue")['default']
export const PriceVariationDiscountPercentage: typeof import("../components/priceVariation/DiscountPercentage.vue")['default']
export const PriceVariationItems: typeof import("../components/priceVariation/Items.vue")['default']
export const PriceVariationNotifications: typeof import("../components/priceVariation/Notifications.vue")['default']
export const PriceVariationPriceBox: typeof import("../components/priceVariation/PriceBox.vue")['default']
export const PriceVariationProductFinalPrice: typeof import("../components/priceVariation/ProductFinalPrice.vue")['default']
export const PriceVariationProductOldPrice: typeof import("../components/priceVariation/ProductOldPrice.vue")['default']
export const PriceVariationSelectVariationBtn: typeof import("../components/priceVariation/SelectVariationBtn.vue")['default']
export const PriceVariationSellerPerformance: typeof import("../components/priceVariation/SellerPerformance.vue")['default']
export const PriceVariationSellerPerformanceDetail: typeof import("../components/priceVariation/SellerPerformanceDetail.vue")['default']
export const PriceVariationSendDetail: typeof import("../components/priceVariation/SendDetail.vue")['default']
export const PriceVariationShortDetail: typeof import("../components/priceVariation/ShortDetail.vue")['default']
export const PriceVariationStatusInWarehouse: typeof import("../components/priceVariation/StatusInWarehouse.vue")['default']
export const PriceVariationStockNotice: typeof import("../components/priceVariation/StockNotice.vue")['default']
export const PriceVariationAllListDesktop: typeof import("../components/priceVariation/all-list/Desktop.vue")['default']
export const ProductPageAppBar: typeof import("../components/product-page/AppBar.vue")['default']
export const ProductPageBottomNavigation: typeof import("../components/product-page/BottomNavigation.vue")['default']
export const ProductPageInformation: typeof import("../components/product-page/Information.vue")['default']
export const ProductPageIntroduction: typeof import("../components/product-page/Introduction.vue")['default']
export const ProductPageOffcanvasTabs: typeof import("../components/product-page/OffcanvasTabs.vue")['default']
export const ProductPageOptions: typeof import("../components/product-page/Options.vue")['default']
export const ProductPagePurchaseFeatures: typeof import("../components/product-page/PurchaseFeatures.vue")['default']
export const ProductPageReturnConditions: typeof import("../components/product-page/ReturnConditions.vue")['default']
export const ProductPageTabs: typeof import("../components/product-page/Tabs.vue")['default']
export const ProductPageGalleryDesktop: typeof import("../components/product-page/gallery/Desktop.vue")['default']
export const ProductPageGalleryMobile: typeof import("../components/product-page/gallery/Mobile.vue")['default']
export const ProductPageGallerySmallSlider: typeof import("../components/product-page/gallery/SmallSlider.vue")['default']
export const ProductPageGalleryTabSlider: typeof import("../components/product-page/gallery/TabSlider.vue")['default']
export const PromotionsAmazingDay: typeof import("../components/promotions/AmazingDay.vue")['default']
export const PromotionsAmazingOffers: typeof import("../components/promotions/AmazingOffers.vue")['default']
export const PromotionsCategoriesSlider: typeof import("../components/promotions/CategoriesSlider.vue")['default']
export const PromotionsDisplayOfferLabel: typeof import("../components/promotions/DisplayOfferLabel.vue")['default']
export const PromotionsIncredibleOffersAppBar: typeof import("../components/promotions/IncredibleOffersAppBar.vue")['default']
export const PromotionsProductFooter: typeof import("../components/promotions/ProductFooter.vue")['default']
export const PromotionsSelectedOffersSlider: typeof import("../components/promotions/SelectedOffersSlider.vue")['default']
export const PromotionsShortCode: typeof import("../components/promotions/ShortCode.vue")['default']
export const QuestionsAnswers: typeof import("../components/questions/Answers.vue")['default']
export const QuestionsFormBox: typeof import("../components/questions/FormBox.vue")['default']
export const QuestionsLikeDislikeSection: typeof import("../components/questions/LikeDislikeSection.vue")['default']
export const QuestionsOffcanvasList: typeof import("../components/questions/OffcanvasList.vue")['default']
export const QuestionsProductPage: typeof import("../components/questions/ProductPage.vue")['default']
export const QuestionsView: typeof import("../components/questions/View.vue")['default']
export const QuestionsDesktopProductPage: typeof import("../components/questions/desktop/ProductPage.vue")['default']
export const QuestionsMobileOffcanvasView: typeof import("../components/questions/mobile/OffcanvasView.vue")['default']
export const QuestionsMobileProductPage: typeof import("../components/questions/mobile/ProductPage.vue")['default']
export const QuestionsUserList: typeof import("../components/questions/user/List.vue")['default']
export const SellersFilterItem: typeof import("../components/sellers/FilterItem.vue")['default']
export const ShareIcon: typeof import("../components/share/Icon.vue")['default']
export const ShareShortCode: typeof import("../components/share/ShortCode.vue")['default']
export const SiteAppBarSetting: typeof import("../components/site/AppBarSetting.vue")['default']
export const SlidersView: typeof import("../components/sliders/view.vue")['default']
export const SpecificationsDesktopView: typeof import("../components/specifications/DesktopView.vue")['default']
export const SpecificationsImportant: typeof import("../components/specifications/Important.vue")['default']
export const SpecificationsMobileView: typeof import("../components/specifications/MobileView.vue")['default']
export const SpecificationsProduct: typeof import("../components/specifications/Product.vue")['default']
export const SpecificationsShortCode: typeof import("../components/specifications/ShortCode.vue")['default']
export const StatisticsLastWeekSales: typeof import("../components/statistics/LastWeekSales.vue")['default']
export const StatisticsRecentDay: typeof import("../components/statistics/RecentDay.vue")['default']
export const TableActions: typeof import("../components/table/Actions.vue")['default']
export const TableActionsBox: typeof import("../components/table/ActionsBox.vue")['default']
export const TableColumnView: typeof import("../components/table/ColumnView.vue")['default']
export const TableColumnsDateColumn: typeof import("../components/table/Columns/DateColumn.vue")['default']
export const TableColumnsNumberColumn: typeof import("../components/table/Columns/NumberColumn.vue")['default']
export const TableColumnsStatusColumn: typeof import("../components/table/Columns/StatusColumn.vue")['default']
export const TableColumnsTimeColumn: typeof import("../components/table/Columns/TimeColumn.vue")['default']
export const TableComponent: typeof import("../components/table/Component.vue")['default']
export const TableDeleteLink: typeof import("../components/table/DeleteLink.vue")['default']
export const TableDetailOffcanvas: typeof import("../components/table/DetailOffcanvas.vue")['default']
export const TableDetailView: typeof import("../components/table/DetailView.vue")['default']
export const TableEditLink: typeof import("../components/table/EditLink.vue")['default']
export const TableRestoreLink: typeof import("../components/table/RestoreLink.vue")['default']
export const ThemeAuctionProducts: typeof import("../components/theme/AuctionProducts.vue")['default']
export const ThemeMainCategories: typeof import("../components/theme/MainCategories.vue")['default']
export const ThemeNotFound: typeof import("../components/theme/NotFound.vue")['default']
export const ThemeProductsBasedOnTaste: typeof import("../components/theme/ProductsBasedOnTaste.vue")['default']
export const ThemeSupportItems: typeof import("../components/theme/SupportItems.vue")['default']
export const ThemeDesktopHeader: typeof import("../components/theme/desktop/Header.vue")['default']
export const ThemeDesktopHeaderMenus: typeof import("../components/theme/desktop/HeaderMenus.vue")['default']
export const ThemeDesktopMegaMenu: typeof import("../components/theme/desktop/MegaMenu.vue")['default']
export const ThemeDesktopSearchProducts: typeof import("../components/theme/desktop/SearchProducts.vue")['default']
export const ThemeFastSearchCategories: typeof import("../components/theme/fast-search/Categories.vue")['default']
export const ThemeFastSearchInput: typeof import("../components/theme/fast-search/Input.vue")['default']
export const ThemeFastSearchPopularSearch: typeof import("../components/theme/fast-search/PopularSearch.vue")['default']
export const ThemeFastSearchRecent: typeof import("../components/theme/fast-search/Recent.vue")['default']
export const ThemeFastSearchResult: typeof import("../components/theme/fast-search/Result.vue")['default']
export const ThemeFastSearchSimilarPhrases: typeof import("../components/theme/fast-search/SimilarPhrases.vue")['default']
export const ThemeFooterNewsletterForm: typeof import("../components/theme/footer/NewsletterForm.vue")['default']
export const ThemeFooterSocialNetworks: typeof import("../components/theme/footer/SocialNetworks.vue")['default']
export const ThemeFooterSupport: typeof import("../components/theme/footer/Support.vue")['default']
export const ThemeFooterView: typeof import("../components/theme/footer/View.vue")['default']
export const ThemeMobileAppBar: typeof import("../components/theme/mobile/AppBar.vue")['default']
export const ThemeMobileBottomNavigationBar: typeof import("../components/theme/mobile/BottomNavigationBar.vue")['default']
export const ThemeMobileSearchProducts: typeof import("../components/theme/mobile/SearchProducts.vue")['default']
export const ThemeMobileSearchProductsAppbar: typeof import("../components/theme/mobile/SearchProductsAppbar.vue")['default']
export const ThemeProductSliderGridList: typeof import("../components/theme/product-slider/GridList.vue")['default']
export const ThemeProductSliderHorizontalList: typeof import("../components/theme/product-slider/HorizontalList.vue")['default']
export const ThemeProductSliderHorizontalView: typeof import("../components/theme/product-slider/HorizontalView.vue")['default']
export const ThemeProductSliderMultiRow: typeof import("../components/theme/product-slider/MultiRow.vue")['default']
export const ThemeProductSliderVerticalView: typeof import("../components/theme/product-slider/VerticalView.vue")['default']
export const ThemeProductSliderView: typeof import("../components/theme/product-slider/View.vue")['default']
export const ThemeSearchAppBarItems: typeof import("../components/theme/search/AppBarItems.vue")['default']
export const ThemeSearchBeforeProductView: typeof import("../components/theme/search/BeforeProductView.vue")['default']
export const ThemeSearchNotFound: typeof import("../components/theme/search/NotFound.vue")['default']
export const ThemeSearchProductColors: typeof import("../components/theme/search/ProductColors.vue")['default']
export const ThemeSearchProductLoading: typeof import("../components/theme/search/ProductLoading.vue")['default']
export const ThemeSearchProductPrice: typeof import("../components/theme/search/ProductPrice.vue")['default']
export const ThemeSearchProductView: typeof import("../components/theme/search/ProductView.vue")['default']
export const ThemeSearchView: typeof import("../components/theme/search/View.vue")['default']
export const ThemeWidgetsBanners: typeof import("../components/theme/widgets/Banners.vue")['default']
export const ThemeWidgetsLatestHot: typeof import("../components/theme/widgets/LatestHot.vue")['default']
export const ThemeWidgetsMoreText: typeof import("../components/theme/widgets/MoreText.vue")['default']
export const ThemeWidgetsProductSlider: typeof import("../components/theme/widgets/ProductSlider.vue")['default']
export const ThemeWidgetsSelectedCategories: typeof import("../components/theme/widgets/SelectedCategories.vue")['default']
export const UsersDesktopProfileLink: typeof import("../components/users/DesktopProfileLink.vue")['default']
export const UsersLayout: typeof import("../components/users/Layout.vue")['default']
export const UsersLogout: typeof import("../components/users/Logout.vue")['default']
export const UsersReceiveVerificationCode: typeof import("../components/users/ReceiveVerificationCode.vue")['default']
export const UsersRemoveRequestBtn: typeof import("../components/users/RemoveRequestBtn.vue")['default']
export const UsersAuthOneTimePassword: typeof import("../components/users/auth/OneTimePassword.vue")['default']
export const UsersLegalAccountDeleteDialog: typeof import("../components/users/legal-account/DeleteDialog.vue")['default']
export const UsersLegalAccountForm: typeof import("../components/users/legal-account/Form.vue")['default']
export const UsersLegalAccountInfo: typeof import("../components/users/legal-account/Info.vue")['default']
export const UsersPanelAppBar: typeof import("../components/users/panel/AppBar.vue")['default']
export const UsersPanelBox: typeof import("../components/users/panel/Box.vue")['default']
export const UsersPanelEmptyList: typeof import("../components/users/panel/EmptyList.vue")['default']
export const UsersPanelInfo: typeof import("../components/users/panel/Info.vue")['default']
export const UsersPanelMenus: typeof import("../components/users/panel/Menus.vue")['default']
export const UsersPersonalInfoEditBirthday: typeof import("../components/users/personalInfo/EditBirthday.vue")['default']
export const UsersPersonalInfoEditEmail: typeof import("../components/users/personalInfo/EditEmail.vue")['default']
export const UsersPersonalInfoEditMobileNumber: typeof import("../components/users/personalInfo/EditMobileNumber.vue")['default']
export const UsersPersonalInfoEditNameForm: typeof import("../components/users/personalInfo/EditNameForm.vue")['default']
export const UsersPersonalInfoEditPassword: typeof import("../components/users/personalInfo/EditPassword.vue")['default']
export const UsersPersonalInfoHowReturnMoney: typeof import("../components/users/personalInfo/HowReturnMoney.vue")['default']
export const WalletBalance: typeof import("../components/wallet/Balance.vue")['default']
export const WalletChargeForm: typeof import("../components/wallet/ChargeForm.vue")['default']
export const WalletMethodSelection: typeof import("../components/wallet/MethodSelection.vue")['default']
export const WalletPaymentForOrder: typeof import("../components/wallet/WalletPaymentForOrder.vue")['default']
export const WalletTableAmountColumn: typeof import("../components/wallet/table/AmountColumn.vue")['default']
export const WarrantyShow: typeof import("../components/warranty/Show.vue")['default']
export const NuxtWelcome: typeof import("../node_modules/nuxt/dist/app/components/welcome.vue")['default']
export const NuxtLayout: typeof import("../node_modules/nuxt/dist/app/components/nuxt-layout")['default']
export const NuxtErrorBoundary: typeof import("../node_modules/nuxt/dist/app/components/nuxt-error-boundary.vue")['default']
export const ClientOnly: typeof import("../node_modules/nuxt/dist/app/components/client-only")['default']
export const DevOnly: typeof import("../node_modules/nuxt/dist/app/components/dev-only")['default']
export const ServerPlaceholder: typeof import("../node_modules/nuxt/dist/app/components/server-placeholder")['default']
export const NuxtLink: typeof import("../node_modules/nuxt/dist/app/components/nuxt-link")['default']
export const NuxtLoadingIndicator: typeof import("../node_modules/nuxt/dist/app/components/nuxt-loading-indicator")['default']
export const NuxtTime: typeof import("../node_modules/nuxt/dist/app/components/nuxt-time.vue")['default']
export const NuxtRouteAnnouncer: typeof import("../node_modules/nuxt/dist/app/components/nuxt-route-announcer")['default']
export const NuxtImg: typeof import("../node_modules/@nuxt/image/dist/runtime/components/NuxtImg.vue")['default']
export const NuxtPicture: typeof import("../node_modules/@nuxt/image/dist/runtime/components/NuxtPicture.vue")['default']
export const LCircle: typeof import("@vue-leaflet/vue-leaflet")['LCircle']
export const LCircleMarker: typeof import("@vue-leaflet/vue-leaflet")['LCircleMarker']
export const LControl: typeof import("@vue-leaflet/vue-leaflet")['LControl']
export const LControlAttribution: typeof import("@vue-leaflet/vue-leaflet")['LControlAttribution']
export const LControlLayers: typeof import("@vue-leaflet/vue-leaflet")['LControlLayers']
export const LControlScale: typeof import("@vue-leaflet/vue-leaflet")['LControlScale']
export const LControlZoom: typeof import("@vue-leaflet/vue-leaflet")['LControlZoom']
export const LFeatureGroup: typeof import("@vue-leaflet/vue-leaflet")['LFeatureGroup']
export const LGeoJson: typeof import("@vue-leaflet/vue-leaflet")['LGeoJson']
export const LIcon: typeof import("@vue-leaflet/vue-leaflet")['LIcon']
export const LImageOverlay: typeof import("@vue-leaflet/vue-leaflet")['LImageOverlay']
export const LLayerGroup: typeof import("@vue-leaflet/vue-leaflet")['LLayerGroup']
export const LMap: typeof import("@vue-leaflet/vue-leaflet")['LMap']
export const LMarker: typeof import("@vue-leaflet/vue-leaflet")['LMarker']
export const LPolygon: typeof import("@vue-leaflet/vue-leaflet")['LPolygon']
export const LPolyline: typeof import("@vue-leaflet/vue-leaflet")['LPolyline']
export const LPopup: typeof import("@vue-leaflet/vue-leaflet")['LPopup']
export const LRectangle: typeof import("@vue-leaflet/vue-leaflet")['LRectangle']
export const LTileLayer: typeof import("@vue-leaflet/vue-leaflet")['LTileLayer']
export const LTooltip: typeof import("@vue-leaflet/vue-leaflet")['LTooltip']
export const LWmsTileLayer: typeof import("@vue-leaflet/vue-leaflet")['LWmsTileLayer']
export const VitePwaManifest: typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/VitePwaManifest")['default']
export const NuxtPwaManifest: typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/VitePwaManifest")['default']
export const NuxtPwaAssets: typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/NuxtPwaAssets")['default']
export const PwaAppleImage: typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaAppleImage.vue")['default']
export const PwaAppleSplashScreenImage: typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaAppleSplashScreenImage.vue")['default']
export const PwaFaviconImage: typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaFaviconImage.vue")['default']
export const PwaMaskableImage: typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaMaskableImage.vue")['default']
export const PwaTransparentImage: typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaTransparentImage.vue")['default']
export const NuxtPage: typeof import("../node_modules/nuxt/dist/pages/runtime/page")['default']
export const NoScript: typeof import("../node_modules/nuxt/dist/head/runtime/components")['NoScript']
export const Link: typeof import("../node_modules/nuxt/dist/head/runtime/components")['Link']
export const Base: typeof import("../node_modules/nuxt/dist/head/runtime/components")['Base']
export const Title: typeof import("../node_modules/nuxt/dist/head/runtime/components")['Title']
export const Meta: typeof import("../node_modules/nuxt/dist/head/runtime/components")['Meta']
export const Style: typeof import("../node_modules/nuxt/dist/head/runtime/components")['Style']
export const Head: typeof import("../node_modules/nuxt/dist/head/runtime/components")['Head']
export const Html: typeof import("../node_modules/nuxt/dist/head/runtime/components")['Html']
export const Body: typeof import("../node_modules/nuxt/dist/head/runtime/components")['Body']
export const NuxtIsland: typeof import("../node_modules/nuxt/dist/app/components/nuxt-island")['default']
export const NuxtRouteAnnouncer: IslandComponent<typeof import("../node_modules/nuxt/dist/app/components/server-placeholder")['default']>
export const LazyIconBadge: LazyComponent<typeof import("../components/IconBadge.vue")['default']>
export const LazyIconsToman: LazyComponent<typeof import("../components/Icons/Toman.vue")['default']>
export const LazyLoading: LazyComponent<typeof import("../components/Loading.vue")['default']>
export const LazyModal: LazyComponent<typeof import("../components/Modal.vue")['default']>
export const LazyOffcanvas: LazyComponent<typeof import("../components/Offcanvas.vue")['default']>
export const LazyOpacityOffcanvas: LazyComponent<typeof import("../components/OpacityOffcanvas.vue")['default']>
export const LazyPagination: LazyComponent<typeof import("../components/Pagination.vue")['default']>
export const LazyRangeSlider: LazyComponent<typeof import("../components/RangeSlider.vue")['default']>
export const LazyRepairMode: LazyComponent<typeof import("../components/RepairMode.vue")['default']>
export const LazyReportPriceForm: LazyComponent<typeof import("../components/ReportPrice/Form.vue")['default']>
export const LazyReportWrongForm: LazyComponent<typeof import("../components/ReportWrong/Form.vue")['default']>
export const LazyScaffold: LazyComponent<typeof import("../components/Scaffold.vue")['default']>
export const LazyServerErrors: LazyComponent<typeof import("../components/ServerErrors.vue")['default']>
export const LazySkeleton: LazyComponent<typeof import("../components/Skeleton.vue")['default']>
export const LazyTabs: LazyComponent<typeof import("../components/Tabs.vue")['default']>
export const LazyTimeAgo: LazyComponent<typeof import("../components/TimeAgo.vue")['default']>
export const LazyTimer: LazyComponent<typeof import("../components/Timer.vue")['default']>
export const LazyToast: LazyComponent<typeof import("../components/Toast.vue")['default']>
export const LazyToggleSlide: LazyComponent<typeof import("../components/ToggleSlide.vue")['default']>
export const LazyTooltip: LazyComponent<typeof import("../components/Tooltip.vue")['default']>
export const LazyAddressesCreateOrEdit: LazyComponent<typeof import("../components/addresses/CreateOrEdit.vue")['default']>
export const LazyAddressesDetail: LazyComponent<typeof import("../components/addresses/Detail.vue")['default']>
export const LazyAddressesForm: LazyComponent<typeof import("../components/addresses/Form.vue")['default']>
export const LazyAddressesOptionsUl: LazyComponent<typeof import("../components/addresses/OptionsUl.vue")['default']>
export const LazyAddressesSelectLocation: LazyComponent<typeof import("../components/addresses/SelectLocation.vue")['default']>
export const LazyAddressesSelectionList: LazyComponent<typeof import("../components/addresses/SelectionList.vue")['default']>
export const LazyAddressesShortDetail: LazyComponent<typeof import("../components/addresses/ShortDetail.vue")['default']>
export const LazyAddressesTable: LazyComponent<typeof import("../components/addresses/Table.vue")['default']>
export const LazyAddressesTableOptions: LazyComponent<typeof import("../components/addresses/TableOptions.vue")['default']>
export const LazyAdsFetchProducts: LazyComponent<typeof import("../components/ads/FetchProducts.vue")['default']>
export const LazyAdsShowAdsInSidebar: LazyComponent<typeof import("../components/ads/ShowAdsInSidebar.vue")['default']>
export const LazyAdsShowProductAdsLabel: LazyComponent<typeof import("../components/ads/ShowProductAdsLabel.vue")['default']>
export const LazyAreaSelectCity: LazyComponent<typeof import("../components/area/SelectCity.vue")['default']>
export const LazyAreaSelectDefault: LazyComponent<typeof import("../components/area/SelectDefault.vue")['default']>
export const LazyAreaSelectProvince: LazyComponent<typeof import("../components/area/SelectProvince.vue")['default']>
export const LazyBlogGridList: LazyComponent<typeof import("../components/blog/GridList.vue")['default']>
export const LazyBlogPosts: LazyComponent<typeof import("../components/blog/Posts.vue")['default']>
export const LazyBlogSlider: LazyComponent<typeof import("../components/blog/Slider.vue")['default']>
export const LazyBrandsSearchSelectBrand: LazyComponent<typeof import("../components/brands/SearchSelectBrand.vue")['default']>
export const LazyBrandsSearchSelectionCategory: LazyComponent<typeof import("../components/brands/SearchSelectionCategory.vue")['default']>
export const LazyBrandsSlider: LazyComponent<typeof import("../components/brands/Slider.vue")['default']>
export const LazyCartAction: LazyComponent<typeof import("../components/cart/Action.vue")['default']>
export const LazyCartAddBtn: LazyComponent<typeof import("../components/cart/AddBtn.vue")['default']>
export const LazyCartAllTransferDialog: LazyComponent<typeof import("../components/cart/AllTransferDialog.vue")['default']>
export const LazyCartAppBar: LazyComponent<typeof import("../components/cart/AppBar.vue")['default']>
export const LazyCartCurrentAction: LazyComponent<typeof import("../components/cart/CurrentAction.vue")['default']>
export const LazyCartCurrentCart: LazyComponent<typeof import("../components/cart/CurrentCart.vue")['default']>
export const LazyCartDesktopIcon: LazyComponent<typeof import("../components/cart/DesktopIcon.vue")['default']>
export const LazyCartFactor: LazyComponent<typeof import("../components/cart/Factor.vue")['default']>
export const LazyCartIcon: LazyComponent<typeof import("../components/cart/Icon.vue")['default']>
export const LazyCartNextCart: LazyComponent<typeof import("../components/cart/NextCart.vue")['default']>
export const LazyCartProductImage: LazyComponent<typeof import("../components/cart/ProductImage.vue")['default']>
export const LazyCartProductPrice: LazyComponent<typeof import("../components/cart/ProductPrice.vue")['default']>
export const LazyCartStatisticsOthers: LazyComponent<typeof import("../components/cart/StatisticsOthers.vue")['default']>
export const LazyCartProducts: LazyComponent<typeof import("../components/cart/products.vue")['default']>
export const LazyCategoriesSearchSelectionCategory: LazyComponent<typeof import("../components/categories/SearchSelectionCategory.vue")['default']>
export const LazyCategoriesSelectBreadCrumbs: LazyComponent<typeof import("../components/categories/SelectBreadCrumbs.vue")['default']>
export const LazyColorSelectComponent: LazyComponent<typeof import("../components/color/SelectComponent.vue")['default']>
export const LazyColorShow: LazyComponent<typeof import("../components/color/Show.vue")['default']>
export const LazyCommentAddCommentBuyer: LazyComponent<typeof import("../components/comment/AddCommentBuyer.vue")['default']>
export const LazyCommentGalleryFiles: LazyComponent<typeof import("../components/comment/GalleryFiles.vue")['default']>
export const LazyCommentLikeDislikeSection: LazyComponent<typeof import("../components/comment/LikeDislikeSection.vue")['default']>
export const LazyCommentProductPage: LazyComponent<typeof import("../components/comment/ProductPage.vue")['default']>
export const LazyCommentScore: LazyComponent<typeof import("../components/comment/Score.vue")['default']>
export const LazyCommentStarRating: LazyComponent<typeof import("../components/comment/StarRating.vue")['default']>
export const LazyCommentVariationDetail: LazyComponent<typeof import("../components/comment/VariationDetail.vue")['default']>
export const LazyCommentView: LazyComponent<typeof import("../components/comment/View.vue")['default']>
export const LazyCommentCreateAddBodyStep: LazyComponent<typeof import("../components/comment/create/AddBodyStep.vue")['default']>
export const LazyCommentCreateAddScoreStep: LazyComponent<typeof import("../components/comment/create/AddScoreStep.vue")['default']>
export const LazyCommentCreateContainer: LazyComponent<typeof import("../components/comment/create/Container.vue")['default']>
export const LazyCommentCreateDialog: LazyComponent<typeof import("../components/comment/create/Dialog.vue")['default']>
export const LazyCommentCreateFooter: LazyComponent<typeof import("../components/comment/create/Footer.vue")['default']>
export const LazyCommentCreateHeader: LazyComponent<typeof import("../components/comment/create/Header.vue")['default']>
export const LazyCommentCreateLoadingOverlay: LazyComponent<typeof import("../components/comment/create/LoadingOverlay.vue")['default']>
export const LazyCommentCreateSoundRecording: LazyComponent<typeof import("../components/comment/create/SoundRecording.vue")['default']>
export const LazyCommentCreateUploadFile: LazyComponent<typeof import("../components/comment/create/UploadFile.vue")['default']>
export const LazyCommentDesktopProductPage: LazyComponent<typeof import("../components/comment/desktop/ProductPage.vue")['default']>
export const LazyCommentMobileOffcanvasList: LazyComponent<typeof import("../components/comment/mobile/OffcanvasList.vue")['default']>
export const LazyCommentMobileOffcanvasView: LazyComponent<typeof import("../components/comment/mobile/OffcanvasView.vue")['default']>
export const LazyCommentMobileProductPage: LazyComponent<typeof import("../components/comment/mobile/ProductPage.vue")['default']>
export const LazyCommentUserComments: LazyComponent<typeof import("../components/comment/user/Comments.vue")['default']>
export const LazyCommentUserInfo: LazyComponent<typeof import("../components/comment/user/Info.vue")['default']>
export const LazyCommentUserWaitingFeedback: LazyComponent<typeof import("../components/comment/user/WaitingFeedback.vue")['default']>
export const LazyComparisonProducts: LazyComponent<typeof import("../components/comparison/Products.vue")['default']>
export const LazyComparisonSelectionProducts: LazyComponent<typeof import("../components/comparison/SelectionProducts.vue")['default']>
export const LazyComparisonPage: LazyComponent<typeof import("../components/comparison/page.vue")['default']>
export const LazyCustomDeliveryDesktopSelectSendTime: LazyComponent<typeof import("../components/custom-delivery/DesktopSelectSendTime.vue")['default']>
export const LazyCustomDeliveryMobileSelectDateAndTime: LazyComponent<typeof import("../components/custom-delivery/MobileSelectDateAndTime.vue")['default']>
export const LazyCustomDeliverySelectDateAndTimeSlider: LazyComponent<typeof import("../components/custom-delivery/SelectDateAndTimeSlider.vue")['default']>
export const LazyCustomDeliveryShowSelectedDateAndTime: LazyComponent<typeof import("../components/custom-delivery/ShowSelectedDateAndTime.vue")['default']>
export const LazyCustomDeliverySubmissionInfo: LazyComponent<typeof import("../components/custom-delivery/SubmissionInfo.vue")['default']>
export const LazyCustomDeliverySummary: LazyComponent<typeof import("../components/custom-delivery/Summary.vue")['default']>
export const LazyDesignHtmlCode: LazyComponent<typeof import("../components/design/HtmlCode.vue")['default']>
export const LazyDesignParagraph: LazyComponent<typeof import("../components/design/Paragraph.vue")['default']>
export const LazyDesignPositionView: LazyComponent<typeof import("../components/design/PositionView.vue")['default']>
export const LazyDiscountRegisterCode: LazyComponent<typeof import("../components/discount/RegisterCode.vue")['default']>
export const LazyExpertReviewProduct: LazyComponent<typeof import("../components/expert-review/Product.vue")['default']>
export const LazyFaqCategories: LazyComponent<typeof import("../components/faq/Categories.vue")['default']>
export const LazyFaqContactUs: LazyComponent<typeof import("../components/faq/ContactUs.vue")['default']>
export const LazyFaqPopularQuestion: LazyComponent<typeof import("../components/faq/PopularQuestion.vue")['default']>
export const LazyFaqQuestionsList: LazyComponent<typeof import("../components/faq/QuestionsList.vue")['default']>
export const LazyFaqWidgetView: LazyComponent<typeof import("../components/faq/widget/view.vue")['default']>
export const LazyFavouriteShortCode: LazyComponent<typeof import("../components/favourite/ShortCode.vue")['default']>
export const LazyFavouriteUserList: LazyComponent<typeof import("../components/favourite/UserList.vue")['default']>
export const LazyFiltersColors: LazyComponent<typeof import("../components/filters/Colors.vue")['default']>
export const LazyFiltersDesktopView: LazyComponent<typeof import("../components/filters/DesktopView.vue")['default']>
export const LazyFiltersHasAvailable: LazyComponent<typeof import("../components/filters/HasAvailable.vue")['default']>
export const LazyFiltersList: LazyComponent<typeof import("../components/filters/List.vue")['default']>
export const LazyFiltersMobileView: LazyComponent<typeof import("../components/filters/MobileView.vue")['default']>
export const LazyFiltersPriceRange: LazyComponent<typeof import("../components/filters/PriceRange.vue")['default']>
export const LazyFiltersReadySend: LazyComponent<typeof import("../components/filters/ReadySend.vue")['default']>
export const LazyFinanceAddBankAccount: LazyComponent<typeof import("../components/finance/AddBankAccount.vue")['default']>
export const LazyFinanceMethodSelection: LazyComponent<typeof import("../components/finance/MethodSelection.vue")['default']>
export const LazyFormButton: LazyComponent<typeof import("../components/form/Button.vue")['default']>
export const LazyFormCheckBox: LazyComponent<typeof import("../components/form/CheckBox.vue")['default']>
export const LazyFormComponent: LazyComponent<typeof import("../components/form/Component.vue")['default']>
export const LazyFormDateInput: LazyComponent<typeof import("../components/form/DateInput.vue")['default']>
export const LazyFormRadio: LazyComponent<typeof import("../components/form/Radio.vue")['default']>
export const LazyFormSelectTag: LazyComponent<typeof import("../components/form/SelectTag.vue")['default']>
export const LazyFormTextInput: LazyComponent<typeof import("../components/form/TextInput.vue")['default']>
export const LazyFormSelectBottomSheet: LazyComponent<typeof import("../components/form/select/BottomSheet.vue")['default']>
export const LazyFormSelectListView: LazyComponent<typeof import("../components/form/select/ListView.vue")['default']>
export const LazyFormSelectModalList: LazyComponent<typeof import("../components/form/select/ModalList.vue")['default']>
export const LazyHomePaymentSelection: LazyComponent<typeof import("../components/home-payment/selection.vue")['default']>
export const LazyImageSearchUploadImage: LazyComponent<typeof import("../components/image-search/UploadImage.vue")['default']>
export const LazyNotificationsRequestAvailability: LazyComponent<typeof import("../components/notifications/RequestAvailability.vue")['default']>
export const LazyNotificationsRequestBox: LazyComponent<typeof import("../components/notifications/RequestBox.vue")['default']>
export const LazyNotificationsUserList: LazyComponent<typeof import("../components/notifications/UserList.vue")['default']>
export const LazyOnlinePaymentSelection: LazyComponent<typeof import("../components/online-payment/selection.vue")['default']>
export const LazyOrdersVerify: LazyComponent<typeof import("../components/orders/Verify.vue")['default']>
export const LazyOrdersCheckoutBottomNavigation: LazyComponent<typeof import("../components/orders/checkout/BottomNavigation.vue")['default']>
export const LazyOrdersCheckoutFactor: LazyComponent<typeof import("../components/orders/checkout/Factor.vue")['default']>
export const LazyOrdersCheckoutHeader: LazyComponent<typeof import("../components/orders/checkout/Header.vue")['default']>
export const LazyOrdersCheckoutProductsSlider: LazyComponent<typeof import("../components/orders/checkout/ProductsSlider.vue")['default']>
export const LazyOrdersCheckoutShortSubmissionsDetail: LazyComponent<typeof import("../components/orders/checkout/ShortSubmissionsDetail.vue")['default']>
export const LazyOrdersCheckoutSubmissionShippingCost: LazyComponent<typeof import("../components/orders/checkout/SubmissionShippingCost.vue")['default']>
export const LazyOrdersFactorCompany: LazyComponent<typeof import("../components/orders/factor/Company.vue")['default']>
export const LazyOrdersFactorProducts: LazyComponent<typeof import("../components/orders/factor/Products.vue")['default']>
export const LazyOrdersFactorUser: LazyComponent<typeof import("../components/orders/factor/User.vue")['default']>
export const LazyOrdersFactorView: LazyComponent<typeof import("../components/orders/factor/View.vue")['default']>
export const LazyOrdersUserAddressInfo: LazyComponent<typeof import("../components/orders/user/AddressInfo.vue")['default']>
export const LazyOrdersUserCancelledOrders: LazyComponent<typeof import("../components/orders/user/CancelledOrders.vue")['default']>
export const LazyOrdersUserCurrentOrders: LazyComponent<typeof import("../components/orders/user/CurrentOrders.vue")['default']>
export const LazyOrdersUserDetailItems: LazyComponent<typeof import("../components/orders/user/DetailItems.vue")['default']>
export const LazyOrdersUserFactorLink: LazyComponent<typeof import("../components/orders/user/FactorLink.vue")['default']>
export const LazyOrdersUserOrderProducts: LazyComponent<typeof import("../components/orders/user/OrderProducts.vue")['default']>
export const LazyOrdersUserOrderStatistics: LazyComponent<typeof import("../components/orders/user/OrderStatistics.vue")['default']>
export const LazyOrdersUserOrdersList: LazyComponent<typeof import("../components/orders/user/OrdersList.vue")['default']>
export const LazyOrdersUserPaymentHistory: LazyComponent<typeof import("../components/orders/user/PaymentHistory.vue")['default']>
export const LazyOrdersUserReturnProducts: LazyComponent<typeof import("../components/orders/user/ReturnProducts.vue")['default']>
export const LazyOrdersUserReturnedOrders: LazyComponent<typeof import("../components/orders/user/ReturnedOrders.vue")['default']>
export const LazyOrdersUserSentOrders: LazyComponent<typeof import("../components/orders/user/SentOrders.vue")['default']>
export const LazyOrdersUserSubmission: LazyComponent<typeof import("../components/orders/user/Submission.vue")['default']>
export const LazyOrdersUserSubmissionProducts: LazyComponent<typeof import("../components/orders/user/SubmissionProducts.vue")['default']>
export const LazyPostalDeliverySubmissionInfo: LazyComponent<typeof import("../components/postal-delivery/SubmissionInfo.vue")['default']>
export const LazyPriceChangesShortCut: LazyComponent<typeof import("../components/price-changes/ShortCut.vue")['default']>
export const LazyPriceVariationCartDetail: LazyComponent<typeof import("../components/priceVariation/CartDetail.vue")['default']>
export const LazyPriceVariationDetail: LazyComponent<typeof import("../components/priceVariation/Detail.vue")['default']>
export const LazyPriceVariationDiscountPercentage: LazyComponent<typeof import("../components/priceVariation/DiscountPercentage.vue")['default']>
export const LazyPriceVariationItems: LazyComponent<typeof import("../components/priceVariation/Items.vue")['default']>
export const LazyPriceVariationNotifications: LazyComponent<typeof import("../components/priceVariation/Notifications.vue")['default']>
export const LazyPriceVariationPriceBox: LazyComponent<typeof import("../components/priceVariation/PriceBox.vue")['default']>
export const LazyPriceVariationProductFinalPrice: LazyComponent<typeof import("../components/priceVariation/ProductFinalPrice.vue")['default']>
export const LazyPriceVariationProductOldPrice: LazyComponent<typeof import("../components/priceVariation/ProductOldPrice.vue")['default']>
export const LazyPriceVariationSelectVariationBtn: LazyComponent<typeof import("../components/priceVariation/SelectVariationBtn.vue")['default']>
export const LazyPriceVariationSellerPerformance: LazyComponent<typeof import("../components/priceVariation/SellerPerformance.vue")['default']>
export const LazyPriceVariationSellerPerformanceDetail: LazyComponent<typeof import("../components/priceVariation/SellerPerformanceDetail.vue")['default']>
export const LazyPriceVariationSendDetail: LazyComponent<typeof import("../components/priceVariation/SendDetail.vue")['default']>
export const LazyPriceVariationShortDetail: LazyComponent<typeof import("../components/priceVariation/ShortDetail.vue")['default']>
export const LazyPriceVariationStatusInWarehouse: LazyComponent<typeof import("../components/priceVariation/StatusInWarehouse.vue")['default']>
export const LazyPriceVariationStockNotice: LazyComponent<typeof import("../components/priceVariation/StockNotice.vue")['default']>
export const LazyPriceVariationAllListDesktop: LazyComponent<typeof import("../components/priceVariation/all-list/Desktop.vue")['default']>
export const LazyProductPageAppBar: LazyComponent<typeof import("../components/product-page/AppBar.vue")['default']>
export const LazyProductPageBottomNavigation: LazyComponent<typeof import("../components/product-page/BottomNavigation.vue")['default']>
export const LazyProductPageInformation: LazyComponent<typeof import("../components/product-page/Information.vue")['default']>
export const LazyProductPageIntroduction: LazyComponent<typeof import("../components/product-page/Introduction.vue")['default']>
export const LazyProductPageOffcanvasTabs: LazyComponent<typeof import("../components/product-page/OffcanvasTabs.vue")['default']>
export const LazyProductPageOptions: LazyComponent<typeof import("../components/product-page/Options.vue")['default']>
export const LazyProductPagePurchaseFeatures: LazyComponent<typeof import("../components/product-page/PurchaseFeatures.vue")['default']>
export const LazyProductPageReturnConditions: LazyComponent<typeof import("../components/product-page/ReturnConditions.vue")['default']>
export const LazyProductPageTabs: LazyComponent<typeof import("../components/product-page/Tabs.vue")['default']>
export const LazyProductPageGalleryDesktop: LazyComponent<typeof import("../components/product-page/gallery/Desktop.vue")['default']>
export const LazyProductPageGalleryMobile: LazyComponent<typeof import("../components/product-page/gallery/Mobile.vue")['default']>
export const LazyProductPageGallerySmallSlider: LazyComponent<typeof import("../components/product-page/gallery/SmallSlider.vue")['default']>
export const LazyProductPageGalleryTabSlider: LazyComponent<typeof import("../components/product-page/gallery/TabSlider.vue")['default']>
export const LazyPromotionsAmazingDay: LazyComponent<typeof import("../components/promotions/AmazingDay.vue")['default']>
export const LazyPromotionsAmazingOffers: LazyComponent<typeof import("../components/promotions/AmazingOffers.vue")['default']>
export const LazyPromotionsCategoriesSlider: LazyComponent<typeof import("../components/promotions/CategoriesSlider.vue")['default']>
export const LazyPromotionsDisplayOfferLabel: LazyComponent<typeof import("../components/promotions/DisplayOfferLabel.vue")['default']>
export const LazyPromotionsIncredibleOffersAppBar: LazyComponent<typeof import("../components/promotions/IncredibleOffersAppBar.vue")['default']>
export const LazyPromotionsProductFooter: LazyComponent<typeof import("../components/promotions/ProductFooter.vue")['default']>
export const LazyPromotionsSelectedOffersSlider: LazyComponent<typeof import("../components/promotions/SelectedOffersSlider.vue")['default']>
export const LazyPromotionsShortCode: LazyComponent<typeof import("../components/promotions/ShortCode.vue")['default']>
export const LazyQuestionsAnswers: LazyComponent<typeof import("../components/questions/Answers.vue")['default']>
export const LazyQuestionsFormBox: LazyComponent<typeof import("../components/questions/FormBox.vue")['default']>
export const LazyQuestionsLikeDislikeSection: LazyComponent<typeof import("../components/questions/LikeDislikeSection.vue")['default']>
export const LazyQuestionsOffcanvasList: LazyComponent<typeof import("../components/questions/OffcanvasList.vue")['default']>
export const LazyQuestionsProductPage: LazyComponent<typeof import("../components/questions/ProductPage.vue")['default']>
export const LazyQuestionsView: LazyComponent<typeof import("../components/questions/View.vue")['default']>
export const LazyQuestionsDesktopProductPage: LazyComponent<typeof import("../components/questions/desktop/ProductPage.vue")['default']>
export const LazyQuestionsMobileOffcanvasView: LazyComponent<typeof import("../components/questions/mobile/OffcanvasView.vue")['default']>
export const LazyQuestionsMobileProductPage: LazyComponent<typeof import("../components/questions/mobile/ProductPage.vue")['default']>
export const LazyQuestionsUserList: LazyComponent<typeof import("../components/questions/user/List.vue")['default']>
export const LazySellersFilterItem: LazyComponent<typeof import("../components/sellers/FilterItem.vue")['default']>
export const LazyShareIcon: LazyComponent<typeof import("../components/share/Icon.vue")['default']>
export const LazyShareShortCode: LazyComponent<typeof import("../components/share/ShortCode.vue")['default']>
export const LazySiteAppBarSetting: LazyComponent<typeof import("../components/site/AppBarSetting.vue")['default']>
export const LazySlidersView: LazyComponent<typeof import("../components/sliders/view.vue")['default']>
export const LazySpecificationsDesktopView: LazyComponent<typeof import("../components/specifications/DesktopView.vue")['default']>
export const LazySpecificationsImportant: LazyComponent<typeof import("../components/specifications/Important.vue")['default']>
export const LazySpecificationsMobileView: LazyComponent<typeof import("../components/specifications/MobileView.vue")['default']>
export const LazySpecificationsProduct: LazyComponent<typeof import("../components/specifications/Product.vue")['default']>
export const LazySpecificationsShortCode: LazyComponent<typeof import("../components/specifications/ShortCode.vue")['default']>
export const LazyStatisticsLastWeekSales: LazyComponent<typeof import("../components/statistics/LastWeekSales.vue")['default']>
export const LazyStatisticsRecentDay: LazyComponent<typeof import("../components/statistics/RecentDay.vue")['default']>
export const LazyTableActions: LazyComponent<typeof import("../components/table/Actions.vue")['default']>
export const LazyTableActionsBox: LazyComponent<typeof import("../components/table/ActionsBox.vue")['default']>
export const LazyTableColumnView: LazyComponent<typeof import("../components/table/ColumnView.vue")['default']>
export const LazyTableColumnsDateColumn: LazyComponent<typeof import("../components/table/Columns/DateColumn.vue")['default']>
export const LazyTableColumnsNumberColumn: LazyComponent<typeof import("../components/table/Columns/NumberColumn.vue")['default']>
export const LazyTableColumnsStatusColumn: LazyComponent<typeof import("../components/table/Columns/StatusColumn.vue")['default']>
export const LazyTableColumnsTimeColumn: LazyComponent<typeof import("../components/table/Columns/TimeColumn.vue")['default']>
export const LazyTableComponent: LazyComponent<typeof import("../components/table/Component.vue")['default']>
export const LazyTableDeleteLink: LazyComponent<typeof import("../components/table/DeleteLink.vue")['default']>
export const LazyTableDetailOffcanvas: LazyComponent<typeof import("../components/table/DetailOffcanvas.vue")['default']>
export const LazyTableDetailView: LazyComponent<typeof import("../components/table/DetailView.vue")['default']>
export const LazyTableEditLink: LazyComponent<typeof import("../components/table/EditLink.vue")['default']>
export const LazyTableRestoreLink: LazyComponent<typeof import("../components/table/RestoreLink.vue")['default']>
export const LazyThemeAuctionProducts: LazyComponent<typeof import("../components/theme/AuctionProducts.vue")['default']>
export const LazyThemeMainCategories: LazyComponent<typeof import("../components/theme/MainCategories.vue")['default']>
export const LazyThemeNotFound: LazyComponent<typeof import("../components/theme/NotFound.vue")['default']>
export const LazyThemeProductsBasedOnTaste: LazyComponent<typeof import("../components/theme/ProductsBasedOnTaste.vue")['default']>
export const LazyThemeSupportItems: LazyComponent<typeof import("../components/theme/SupportItems.vue")['default']>
export const LazyThemeDesktopHeader: LazyComponent<typeof import("../components/theme/desktop/Header.vue")['default']>
export const LazyThemeDesktopHeaderMenus: LazyComponent<typeof import("../components/theme/desktop/HeaderMenus.vue")['default']>
export const LazyThemeDesktopMegaMenu: LazyComponent<typeof import("../components/theme/desktop/MegaMenu.vue")['default']>
export const LazyThemeDesktopSearchProducts: LazyComponent<typeof import("../components/theme/desktop/SearchProducts.vue")['default']>
export const LazyThemeFastSearchCategories: LazyComponent<typeof import("../components/theme/fast-search/Categories.vue")['default']>
export const LazyThemeFastSearchInput: LazyComponent<typeof import("../components/theme/fast-search/Input.vue")['default']>
export const LazyThemeFastSearchPopularSearch: LazyComponent<typeof import("../components/theme/fast-search/PopularSearch.vue")['default']>
export const LazyThemeFastSearchRecent: LazyComponent<typeof import("../components/theme/fast-search/Recent.vue")['default']>
export const LazyThemeFastSearchResult: LazyComponent<typeof import("../components/theme/fast-search/Result.vue")['default']>
export const LazyThemeFastSearchSimilarPhrases: LazyComponent<typeof import("../components/theme/fast-search/SimilarPhrases.vue")['default']>
export const LazyThemeFooterNewsletterForm: LazyComponent<typeof import("../components/theme/footer/NewsletterForm.vue")['default']>
export const LazyThemeFooterSocialNetworks: LazyComponent<typeof import("../components/theme/footer/SocialNetworks.vue")['default']>
export const LazyThemeFooterSupport: LazyComponent<typeof import("../components/theme/footer/Support.vue")['default']>
export const LazyThemeFooterView: LazyComponent<typeof import("../components/theme/footer/View.vue")['default']>
export const LazyThemeMobileAppBar: LazyComponent<typeof import("../components/theme/mobile/AppBar.vue")['default']>
export const LazyThemeMobileBottomNavigationBar: LazyComponent<typeof import("../components/theme/mobile/BottomNavigationBar.vue")['default']>
export const LazyThemeMobileSearchProducts: LazyComponent<typeof import("../components/theme/mobile/SearchProducts.vue")['default']>
export const LazyThemeMobileSearchProductsAppbar: LazyComponent<typeof import("../components/theme/mobile/SearchProductsAppbar.vue")['default']>
export const LazyThemeProductSliderGridList: LazyComponent<typeof import("../components/theme/product-slider/GridList.vue")['default']>
export const LazyThemeProductSliderHorizontalList: LazyComponent<typeof import("../components/theme/product-slider/HorizontalList.vue")['default']>
export const LazyThemeProductSliderHorizontalView: LazyComponent<typeof import("../components/theme/product-slider/HorizontalView.vue")['default']>
export const LazyThemeProductSliderMultiRow: LazyComponent<typeof import("../components/theme/product-slider/MultiRow.vue")['default']>
export const LazyThemeProductSliderVerticalView: LazyComponent<typeof import("../components/theme/product-slider/VerticalView.vue")['default']>
export const LazyThemeProductSliderView: LazyComponent<typeof import("../components/theme/product-slider/View.vue")['default']>
export const LazyThemeSearchAppBarItems: LazyComponent<typeof import("../components/theme/search/AppBarItems.vue")['default']>
export const LazyThemeSearchBeforeProductView: LazyComponent<typeof import("../components/theme/search/BeforeProductView.vue")['default']>
export const LazyThemeSearchNotFound: LazyComponent<typeof import("../components/theme/search/NotFound.vue")['default']>
export const LazyThemeSearchProductColors: LazyComponent<typeof import("../components/theme/search/ProductColors.vue")['default']>
export const LazyThemeSearchProductLoading: LazyComponent<typeof import("../components/theme/search/ProductLoading.vue")['default']>
export const LazyThemeSearchProductPrice: LazyComponent<typeof import("../components/theme/search/ProductPrice.vue")['default']>
export const LazyThemeSearchProductView: LazyComponent<typeof import("../components/theme/search/ProductView.vue")['default']>
export const LazyThemeSearchView: LazyComponent<typeof import("../components/theme/search/View.vue")['default']>
export const LazyThemeWidgetsBanners: LazyComponent<typeof import("../components/theme/widgets/Banners.vue")['default']>
export const LazyThemeWidgetsLatestHot: LazyComponent<typeof import("../components/theme/widgets/LatestHot.vue")['default']>
export const LazyThemeWidgetsMoreText: LazyComponent<typeof import("../components/theme/widgets/MoreText.vue")['default']>
export const LazyThemeWidgetsProductSlider: LazyComponent<typeof import("../components/theme/widgets/ProductSlider.vue")['default']>
export const LazyThemeWidgetsSelectedCategories: LazyComponent<typeof import("../components/theme/widgets/SelectedCategories.vue")['default']>
export const LazyUsersDesktopProfileLink: LazyComponent<typeof import("../components/users/DesktopProfileLink.vue")['default']>
export const LazyUsersLayout: LazyComponent<typeof import("../components/users/Layout.vue")['default']>
export const LazyUsersLogout: LazyComponent<typeof import("../components/users/Logout.vue")['default']>
export const LazyUsersReceiveVerificationCode: LazyComponent<typeof import("../components/users/ReceiveVerificationCode.vue")['default']>
export const LazyUsersRemoveRequestBtn: LazyComponent<typeof import("../components/users/RemoveRequestBtn.vue")['default']>
export const LazyUsersAuthOneTimePassword: LazyComponent<typeof import("../components/users/auth/OneTimePassword.vue")['default']>
export const LazyUsersLegalAccountDeleteDialog: LazyComponent<typeof import("../components/users/legal-account/DeleteDialog.vue")['default']>
export const LazyUsersLegalAccountForm: LazyComponent<typeof import("../components/users/legal-account/Form.vue")['default']>
export const LazyUsersLegalAccountInfo: LazyComponent<typeof import("../components/users/legal-account/Info.vue")['default']>
export const LazyUsersPanelAppBar: LazyComponent<typeof import("../components/users/panel/AppBar.vue")['default']>
export const LazyUsersPanelBox: LazyComponent<typeof import("../components/users/panel/Box.vue")['default']>
export const LazyUsersPanelEmptyList: LazyComponent<typeof import("../components/users/panel/EmptyList.vue")['default']>
export const LazyUsersPanelInfo: LazyComponent<typeof import("../components/users/panel/Info.vue")['default']>
export const LazyUsersPanelMenus: LazyComponent<typeof import("../components/users/panel/Menus.vue")['default']>
export const LazyUsersPersonalInfoEditBirthday: LazyComponent<typeof import("../components/users/personalInfo/EditBirthday.vue")['default']>
export const LazyUsersPersonalInfoEditEmail: LazyComponent<typeof import("../components/users/personalInfo/EditEmail.vue")['default']>
export const LazyUsersPersonalInfoEditMobileNumber: LazyComponent<typeof import("../components/users/personalInfo/EditMobileNumber.vue")['default']>
export const LazyUsersPersonalInfoEditNameForm: LazyComponent<typeof import("../components/users/personalInfo/EditNameForm.vue")['default']>
export const LazyUsersPersonalInfoEditPassword: LazyComponent<typeof import("../components/users/personalInfo/EditPassword.vue")['default']>
export const LazyUsersPersonalInfoHowReturnMoney: LazyComponent<typeof import("../components/users/personalInfo/HowReturnMoney.vue")['default']>
export const LazyWalletBalance: LazyComponent<typeof import("../components/wallet/Balance.vue")['default']>
export const LazyWalletChargeForm: LazyComponent<typeof import("../components/wallet/ChargeForm.vue")['default']>
export const LazyWalletMethodSelection: LazyComponent<typeof import("../components/wallet/MethodSelection.vue")['default']>
export const LazyWalletPaymentForOrder: LazyComponent<typeof import("../components/wallet/WalletPaymentForOrder.vue")['default']>
export const LazyWalletTableAmountColumn: LazyComponent<typeof import("../components/wallet/table/AmountColumn.vue")['default']>
export const LazyWarrantyShow: LazyComponent<typeof import("../components/warranty/Show.vue")['default']>
export const LazyNuxtWelcome: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/welcome.vue")['default']>
export const LazyNuxtLayout: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-layout")['default']>
export const LazyNuxtErrorBoundary: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-error-boundary.vue")['default']>
export const LazyClientOnly: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/client-only")['default']>
export const LazyDevOnly: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/dev-only")['default']>
export const LazyServerPlaceholder: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/server-placeholder")['default']>
export const LazyNuxtLink: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-link")['default']>
export const LazyNuxtLoadingIndicator: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-loading-indicator")['default']>
export const LazyNuxtTime: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-time.vue")['default']>
export const LazyNuxtRouteAnnouncer: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-route-announcer")['default']>
export const LazyNuxtImg: LazyComponent<typeof import("../node_modules/@nuxt/image/dist/runtime/components/NuxtImg.vue")['default']>
export const LazyNuxtPicture: LazyComponent<typeof import("../node_modules/@nuxt/image/dist/runtime/components/NuxtPicture.vue")['default']>
export const LazyLCircle: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LCircle']>
export const LazyLCircleMarker: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LCircleMarker']>
export const LazyLControl: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControl']>
export const LazyLControlAttribution: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControlAttribution']>
export const LazyLControlLayers: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControlLayers']>
export const LazyLControlScale: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControlScale']>
export const LazyLControlZoom: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LControlZoom']>
export const LazyLFeatureGroup: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LFeatureGroup']>
export const LazyLGeoJson: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LGeoJson']>
export const LazyLIcon: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LIcon']>
export const LazyLImageOverlay: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LImageOverlay']>
export const LazyLLayerGroup: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LLayerGroup']>
export const LazyLMap: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LMap']>
export const LazyLMarker: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LMarker']>
export const LazyLPolygon: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LPolygon']>
export const LazyLPolyline: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LPolyline']>
export const LazyLPopup: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LPopup']>
export const LazyLRectangle: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LRectangle']>
export const LazyLTileLayer: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LTileLayer']>
export const LazyLTooltip: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LTooltip']>
export const LazyLWmsTileLayer: LazyComponent<typeof import("@vue-leaflet/vue-leaflet")['LWmsTileLayer']>
export const LazyVitePwaManifest: LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/VitePwaManifest")['default']>
export const LazyNuxtPwaManifest: LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/VitePwaManifest")['default']>
export const LazyNuxtPwaAssets: LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/NuxtPwaAssets")['default']>
export const LazyPwaAppleImage: LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaAppleImage.vue")['default']>
export const LazyPwaAppleSplashScreenImage: LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaAppleSplashScreenImage.vue")['default']>
export const LazyPwaFaviconImage: LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaFaviconImage.vue")['default']>
export const LazyPwaMaskableImage: LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaMaskableImage.vue")['default']>
export const LazyPwaTransparentImage: LazyComponent<typeof import("../node_modules/@vite-pwa/nuxt/dist/runtime/components/PwaTransparentImage.vue")['default']>
export const LazyNuxtPage: LazyComponent<typeof import("../node_modules/nuxt/dist/pages/runtime/page")['default']>
export const LazyNoScript: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['NoScript']>
export const LazyLink: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Link']>
export const LazyBase: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Base']>
export const LazyTitle: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Title']>
export const LazyMeta: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Meta']>
export const LazyStyle: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Style']>
export const LazyHead: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Head']>
export const LazyHtml: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Html']>
export const LazyBody: LazyComponent<typeof import("../node_modules/nuxt/dist/head/runtime/components")['Body']>
export const LazyNuxtIsland: LazyComponent<typeof import("../node_modules/nuxt/dist/app/components/nuxt-island")['default']>
export const LazyNuxtRouteAnnouncer: LazyComponent<IslandComponent<typeof import("../node_modules/nuxt/dist/app/components/server-placeholder")['default']>>

export const componentNames: string[]
