import { defineComponent, ref, resolveComponent, unref, useSSRContext, withCtx, createVNode, toDisplayString, createBlock, openBlock, Fragment, renderList } from "vue";
import { ssrRenderClass, ssrRenderComponent, ssrInterpolate, ssrRenderSlot, ssrRenderList, ssrRenderAttrs } from "vue/server-renderer";
import { g as __nuxt_component_0, i as _export_sfc } from "../server.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "OpacityOffcanvas",
  __ssrInlineRender: true,
  props: {
    title: {},
    contentClass: {},
    afterClose: { type: Function },
    backFunction: { type: Function }
  },
  setup(__props, { expose: __expose }) {
    const props = __props;
    ref(null);
    const isOpen = ref(false);
    const show = function() {
      isOpen.value = true;
    };
    const hide = function() {
      isOpen.value = false;
      if (props.afterClose) {
        props.afterClose();
      }
    };
    __expose({
      show,
      hide
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<!--[-->`);
      if (unref(isOpen)) {
        _push(`<div class="offcanves"><div class="${ssrRenderClass([_ctx.contentClass, "content absolute h-full bg-white flex flex-col"])}"><div class="header">`);
        if (_ctx.title) {
          _push(`<div class="flex justify-between items-center w-full"><div class="flex items-center">`);
          if (_ctx.backFunction) {
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "arrow-right"],
              class: "pr-5 cursor-pointer",
              onClick: ($event) => _ctx.backFunction()
            }, null, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(`<h3 class="font-bold py-5 pr-5">${ssrInterpolate(_ctx.title)}</h3></div>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            icon: ["fas", "close"],
            class: "text-gray-500 text-xl pl-5",
            onClick: hide
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        ssrRenderSlot(_ctx.$slots, "header", {}, null, _push, _parent);
        _push(`</div><div class="flex flex-col overflow-auto flex-grow h-full">`);
        ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
        _push(`</div><div>`);
        ssrRenderSlot(_ctx.$slots, "footer", {}, null, _push, _parent);
        _push(`</div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(isOpen)) {
        _push(`<div class="w-full h-full fixed inset-0 bg-black bg-opacity-30 z-10"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/OpacityOffcanvas.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "AppBarSetting",
  __ssrInlineRender: true,
  setup(__props) {
    const settingBox = ref(null);
    const menus = [
      {
        icon: ["fas", "question-circle"],
        route: "/faq",
        title: "پرسش‌های متداول"
      },
      {
        icon: ["fas", "phone"],
        route: "/faq",
        title: "تماس با ما"
      },
      {
        title: "حریم خصوصی",
        icon: ["fas", "lock"],
        route: "/page/حریم-خصوصی"
      }
    ];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_OpacityOffcanvas = _sfc_main$2;
      const _component_nuxt_link = __nuxt_component_0;
      _push(`<!--[--><div>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "fa-cog"],
        class: "text-lg cursor-pointer",
        onClick: ($event) => unref(settingBox).show()
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_component_OpacityOffcanvas, {
        ref_key: "settingBox",
        ref: settingBox,
        "content-class": "w-full h-full",
        title: "تنظیمات"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<ul class="px-4"${_scopeId}><!--[-->`);
            ssrRenderList(menus, (menu, key) => {
              _push2(`<li class="py-4 border-b"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_nuxt_link, {
                class: "w-full flex items-center justify-between",
                to: menu.route
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="flex items-center"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_fa_icon, {
                      icon: menu.icon
                    }, null, _parent3, _scopeId2));
                    _push3(`<span class="text-gray-700 px-3"${_scopeId2}>${ssrInterpolate(menu.title)}</span></div>`);
                    _push3(ssrRenderComponent(_component_fa_icon, {
                      icon: ["fas", "angle-left"],
                      class: "text-gray-700"
                    }, null, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode("div", { class: "flex items-center" }, [
                        createVNode(_component_fa_icon, {
                          icon: menu.icon
                        }, null, 8, ["icon"]),
                        createVNode("span", { class: "text-gray-700 px-3" }, toDisplayString(menu.title), 1)
                      ]),
                      createVNode(_component_fa_icon, {
                        icon: ["fas", "angle-left"],
                        class: "text-gray-700"
                      })
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
              _push2(`</li>`);
            });
            _push2(`<!--]--></ul>`);
          } else {
            return [
              createVNode("ul", { class: "px-4" }, [
                (openBlock(), createBlock(Fragment, null, renderList(menus, (menu, key) => {
                  return createVNode("li", {
                    key,
                    class: "py-4 border-b"
                  }, [
                    createVNode(_component_nuxt_link, {
                      class: "w-full flex items-center justify-between",
                      to: menu.route
                    }, {
                      default: withCtx(() => [
                        createVNode("div", { class: "flex items-center" }, [
                          createVNode(_component_fa_icon, {
                            icon: menu.icon
                          }, null, 8, ["icon"]),
                          createVNode("span", { class: "text-gray-700 px-3" }, toDisplayString(menu.title), 1)
                        ]),
                        createVNode(_component_fa_icon, {
                          icon: ["fas", "angle-left"],
                          class: "text-gray-700"
                        })
                      ]),
                      _: 2
                    }, 1032, ["to"])
                  ]);
                }), 64))
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/site/AppBarSetting.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  const _component_SiteAppBarSetting = _sfc_main$1;
  _push(`<div${ssrRenderAttrs(_attrs)}>`);
  _push(ssrRenderComponent(_component_SiteAppBarSetting, null, null, _parent));
  _push(`</div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/users/panel/AppBar.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const AppBar = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  AppBar as default
};
//# sourceMappingURL=AppBar-ynhgs-5-.js.map
