import { ref, watch, defineComponent, resolveComponent, unref, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderClass, ssrRenderStyle, ssrInterpolate } from "vue/server-renderer";
import { s as searchStore } from "./search-products-xw_89Bg_.js";
import { c as useNuxtApp, b as useRuntimeConfig } from "../server.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "#internal/nuxt/paths";
import "pinia";
import "ofetch";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
function useColorFilter(props) {
  const store = searchStore();
  const showList = ref(false);
  const colors = ref([]);
  const selectedColors = ref({});
  const { $axios } = useNuxtApp();
  const { api } = useRuntimeConfig().public;
  const addOrRemoveFilter = (colorId) => {
    selectedColors.value[colorId] = !selectedColors.value[colorId];
    store.addOrRemoveFilter("colors", colorId);
  };
  watch(() => store.queries, () => {
    if (Object.keys(store.queries).length === 0) {
      selectedColors.value = {};
    }
  });
  return {
    showList,
    colors,
    selectedColors,
    store,
    addOrRemoveFilter
  };
}
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Colors",
  __ssrInlineRender: true,
  props: {
    category_id: {},
    hideTitle: { type: Boolean }
  },
  setup(__props) {
    const {
      showList,
      colors,
      selectedColors,
      store
    } = useColorFilter();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (unref(colors).length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "filter-box" }, _attrs))}>`);
        if (!_ctx.hideTitle) {
          _push(`<div class="title"><div class="flex items-center"> رنگ ها `);
          if (unref(store).queries["colors"]) {
            _push(`<div class="w-1 h-1 rounded-full bg-blue-400 mx-1"></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            class: "text-gray-500",
            icon: [
              "fas",
              unref(showList) ? "fa-angle-up" : "fa-angle-down"
            ]
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(showList) || _ctx.hideTitle) {
          _push(`<div class="content"><ul class="p-0 flex flex-wrap"><!--[-->`);
          ssrRenderList(unref(colors), (color) => {
            _push(`<li class="${ssrRenderClass([{ "active": unref(selectedColors)[color.id] }, "flex items-center flex-col py-3 m-3 cursor-pointer"])}"><div class="color-bg" style="${ssrRenderStyle({ backgroundColor: color.code })}"></div><span class="text-sm py-2">${ssrInterpolate(color.name)}</span></li>`);
          });
          _push(`<!--]--></ul></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/filters/Colors.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=Colors-C-BQp4nP.js.map
