import { defineComponent, resolveComponent, mergeProps, useSSRContext, ref, unref, watch, isRef, withCtx, createTextVNode, toDisplayString, createVNode, resolveDynamicComponent, createSlots, createBlock, createCommentVNode, openBlock, mergeModels, useModel } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList, ssrRenderClass, ssrIncludeBooleanAttr, ssrRenderVNode } from "vue/server-renderer";
import { i as _export_sfc, h as _sfc_main$9, b as useRuntimeConfig, s as setInterval, u as useState, c as useNuxtApp, d as _sfc_main$b, g as __nuxt_component_0, _ as _sfc_main$c, a as _sfc_main$d, j as useRouter } from "../server.mjs";
import { _ as _sfc_main$e } from "./Component-C6QGchKb.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "#internal/nuxt/paths";
import { defineStore } from "pinia";
import { _ as _sfc_main$a } from "./TextInput-BtVMT3NE.js";
const _sfc_main$8 = /* @__PURE__ */ defineComponent({
  __name: "Header",
  __ssrInlineRender: true,
  props: {
    step: {},
    product: {}
  },
  emits: ["back", "close"],
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex justify-between items-center max-lg:px-3 py-3 border-b-2" }, _attrs))}><div class="flex items-center md:text-[17px]"><div class="cursor-pointer pl-2">`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: _ctx.step === 2 ? ["fas", "arrow-right"] : ["fas", "close"],
        onClick: ($event) => _ctx.step === 2 ? _ctx.$emit("back") : _ctx.$emit("close")
      }, null, _parent));
      _push(`</div>`);
      if (_ctx.product.purchase_status === "purchased") {
        _push(`<span> ثبت امتیاز و دیدگاه </span>`);
      } else {
        _push(`<span>ثبت دیدگاه</span>`);
      }
      _push(`</div>`);
      if (_ctx.product.purchase_status === "purchased") {
        _push(`<div class="text-gray-500 text-sm"> مرحله ${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.step))} از ۲ </div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/Header.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const _sfc_main$7 = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  const _component_Loading = _sfc_main$9;
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "absolute inset-0 bg-gray-100/50 flex items-center justify-center" }, _attrs))}>`);
  _push(ssrRenderComponent(_component_Loading, { class: "z-10" }, null, _parent));
  _push(`</div>`);
}
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/LoadingOverlay.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main$7, [["ssrRender", _sfc_ssrRender]]);
const commentFormStore = (productId) => {
  return defineStore(`comment-form-${productId}`, () => {
    const score = ref();
    const successMessage = ref(null);
    const loading = ref(false);
    const formData = ref({
      "files": [],
      "body": ""
    });
    const updateFormData = (data) => {
      formData.value = data;
    };
    const updateScore = (value) => {
      score.value = value;
    };
    return {
      loading,
      successMessage,
      formData,
      updateFormData,
      score,
      updateScore
    };
  })();
};
const _sfc_main$6 = /* @__PURE__ */ defineComponent({
  __name: "AddScoreStep",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const form = commentFormStore(props.product.id);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "p-3 lg:p-5 flex flex-col items-center" }, _attrs))}><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + _ctx.product.image)}${ssrRenderAttr("alt", _ctx.product.title)} class="w-[120px] max-auto"><p class="leading-8 py-3 text-sm text-center">${ssrInterpolate(_ctx.product.title)}</p><p class="font-bold text-xl"> به این کالا چه امتیازی می‌دهید؟ </p><div class="flex items-center pt-5 pb-2"><!--[-->`);
      ssrRenderList(5, (i) => {
        _push(ssrRenderComponent(_component_fa_icon, {
          key: i,
          icon: ["fas", "star"],
          class: ["px-2 text-[17px] cursor-pointer text-gray-400", { "text-yellow-400": unref(form).score && unref(form).score >= i }],
          onClick: ($event) => unref(form).updateScore(i)
        }, null, _parent));
      });
      _push(`<!--]--></div></div>`);
    };
  }
});
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/AddScoreStep.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
function useAudioRecorder() {
  const isRecording = ref(false);
  const duration = ref(0);
  const audioUrl = ref(null);
  const audioBlob = ref(null);
  const audioChunks = [];
  let mediaRecorder = null;
  let timerInterval = null;
  const formatTime = (seconds) => {
    const m = Math.floor(seconds / 60).toString().padStart(2, "0");
    const s = (seconds % 60).toString().padStart(2, "0");
    return `${m}:${s}`;
  };
  const startRecording = async (onError) => {
    try {
      const stream = await (void 0).mediaDevices.getUserMedia({ audio: true });
      mediaRecorder = new MediaRecorder(stream);
      audioChunks.length = 0;
      mediaRecorder.ondataavailable = (e) => {
        audioChunks.push(e.data);
      };
      mediaRecorder.onstop = () => {
        const blob = new Blob(audioChunks, { type: "audio/webm" });
        audioBlob.value = blob;
        audioUrl.value = URL.createObjectURL(blob);
      };
      mediaRecorder.start();
      isRecording.value = true;
      duration.value = 0;
      timerInterval = setInterval(() => {
        duration.value += 1;
      }, 1e3);
    } catch (err) {
      onError == null ? void 0 : onError("میکروفن شما فعال نیست");
    }
  };
  const stopRecording = () => {
    mediaRecorder == null ? void 0 : mediaRecorder.stop();
    isRecording.value = false;
    if (timerInterval) clearInterval(timerInterval);
  };
  const toggleRecording = (onError) => {
    if (isRecording.value) {
      stopRecording();
    } else {
      startRecording(onError);
    }
  };
  return {
    isRecording,
    duration,
    audioUrl,
    audioBlob,
    formatTime,
    toggleRecording,
    stopRecording
  };
}
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "SoundRecording",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    useState("toast");
    const commentState = commentFormStore(props.product.id);
    const {
      isRecording,
      duration,
      audioUrl,
      audioBlob,
      formatTime
    } = useAudioRecorder();
    watch(audioBlob, (blob) => {
      if (blob) {
        commentState.updateFormData({
          ...commentState.formData,
          voice: blob
        });
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_AudioPlayer = resolveComponent("AudioPlayer");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "my-5" }, _attrs))}>`);
      if (!unref(commentState).successMessage) {
        _push(`<button class="btn btn-danger flex items-center w-auto">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", unref(isRecording) ? "stop" : "play"]
        }, null, _parent));
        _push(`<span class="pr-2">${ssrInterpolate(unref(isRecording) ? "توقف ضبط" : "شروع ضبط")}</span></button>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(isRecording)) {
        _push(`<div class="mt-2"> ⏱ در حال ضبط: ${ssrInterpolate(unref(formatTime)(unref(duration)))}</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(audioUrl)) {
        _push(`<div class="mt-4">`);
        _push(ssrRenderComponent(_component_AudioPlayer, {
          option: {
            src: unref(audioUrl),
            title: "ویس ضبط شده",
            autoplay: false
          }
        }, null, _parent));
        if (!unref(commentState).successMessage) {
          _push(`<button class="mt-2 text-red-500 text-sm flex items-center">`);
          _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "trash"] }, null, _parent));
          _push(`<span class="pr-2">حذف ویس</span></button>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (!unref(commentState).successMessage) {
        _push(`<div class="alert alert-warning text-sm mt-4"> کامنت شما باید در یک محیط آرام و کاملا واضح رکورد شود در غیر این صورت تایید نخواهد شد </div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/SoundRecording.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
function useUploadCommentFile(product) {
  const form = commentFormStore(product.id);
  const maxFiles = 5;
  const file = ref(null);
  const uploadingFiles = ref([]);
  const { api } = useRuntimeConfig().public;
  const { $axios } = useNuxtApp();
  const getImageUrl = (file2) => {
    return URL.createObjectURL(file2);
  };
  const selectedFile = () => {
    var _a, _b;
    if ((_b = (_a = file.value) == null ? void 0 : _a.files) == null ? void 0 : _b[0]) {
      const index = uploadingFiles.value.length;
      uploadingFiles.value.push({
        file: file.value.files[0],
        status: "loading"
      });
      $axios.post(api + "/user/comment/upload", {
        files: [file.value.files[0]],
        product_id: product.id
      }, {
        headers: { "Content-Type": "multipart/form-data" }
      }).then((response) => {
        if (response.data.status == "ok") {
          uploadingFiles.value[index].status = "success";
          form.formData.files[index] = response.data.paths[0];
        }
      }).catch(() => {
        uploadingFiles.value.splice(index, 1);
      });
    }
  };
  const removeFile = (index) => {
    if (uploadingFiles.value[index].status == "success") {
      uploadingFiles.value.splice(index, 1);
      form.formData.files.splice(index, 1);
    } else {
      uploadingFiles.value.splice(index, 1);
    }
  };
  return {
    form,
    file,
    selectedFile,
    removeFile,
    getImageUrl,
    uploadingFiles,
    maxFiles
  };
}
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "UploadFile",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const {
      uploadingFiles,
      removeFile,
      getImageUrl,
      maxFiles,
      form
    } = useUploadCommentFile(props.product);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_Loading = _sfc_main$9;
      if (_ctx.product.purchase_status == "purchased") {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: [{ "flex": unref(uploadingFiles).length > 0 }, "py-3"]
        }, _attrs))}>`);
        if (unref(uploadingFiles).length < unref(maxFiles) && !unref(form).successMessage) {
          _push(`<div class="${ssrRenderClass([{ "w-20 m-2": unref(uploadingFiles).length > 0 }, "flex flex-col items-center bg-gray-100 h-20 justify-center cursor-pointer rounded-md"])}">`);
          _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "image"] }, null, _parent));
          if (unref(form).formData.files.length == 0 && unref(uploadingFiles).length == 0) {
            _push(`<span class="pt-2 text-sm"> آپلود عکس </span>`);
          } else {
            _push(`<span>افزودن</span>`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--[-->`);
        ssrRenderList(unref(uploadingFiles), (row, key) => {
          _push(`<div class="w-20 h-20 rounded-md bg-gray-100 m-2 justify-center flex relative"><img${ssrRenderAttr("src", unref(getImageUrl)(row.file))} class="w-full object-contain">`);
          if (row.status == "loading") {
            _push(`<div class="absolute top-[50%]">`);
            _push(ssrRenderComponent(_component_Loading, { type: "small" }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          if (!unref(form).successMessage) {
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "trash"],
              class: "absolute left-3 bottom-3 cursor-pointer",
              onClick: ($event) => unref(removeFile)(key)
            }, null, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        });
        _push(`<!--]--><input type="file" class="hidden" accept="image/*"></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/UploadFile.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "AddBodyStep",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const shopSetting = useState("shopSetting");
    const props = __props;
    const sendVoice = ref(false);
    const form = commentFormStore(props.product.id);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FormTextInput = _sfc_main$a;
      const _component_FormCheckBox = _sfc_main$b;
      const _component_CommentCreateSoundRecording = _sfc_main$5;
      const _component_CommentCreateUploadFile = _sfc_main$4;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "p-3 lg:p-5" }, _attrs))}><div class="flex"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + _ctx.product.image)} class="w-[80px]"${ssrRenderAttr("alt", _ctx.product.title)}><p class="text-sm text-black">${ssrInterpolate(_ctx.product.title)}</p></div>`);
      if (_ctx.product.purchase_status == "purchased") {
        _push(`<div class="flex justify-between items-center pt-7"><span class="text-[14px] font-bold">امتیاز ثبت شده شما</span><div class="flex items-center"><!--[-->`);
        ssrRenderList(5, (i) => {
          _push(ssrRenderComponent(_component_fa_icon, {
            key: i,
            icon: ["fas", "star"],
            class: ["px-2 text-[17px] cursor-pointer text-gray-400", { "text-yellow-400": unref(form).score && unref(form).score >= i }],
            onClick: ($event) => unref(form).updateScore(i)
          }, null, _parent));
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (!unref(sendVoice)) {
        _push(`<!--[-->`);
        if (!unref(form).successMessage) {
          _push(ssrRenderComponent(_component_FormTextInput, {
            placeholder: "نظر خود را در مورد این کالا با کاربران دیگر به اشتراک بگذارید..",
            type: "textarea",
            modelValue: unref(form).formData.body,
            "onUpdate:modelValue": ($event) => unref(form).formData.body = $event,
            name: "text"
          }, null, _parent));
        } else {
          _push(`<div class="bg-gray-100 border-b border-gray-300 rounded-md mt-5 p-2">${ssrInterpolate(unref(form).formData.body)}</div>`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (unref(shopSetting)["comment-voice"] == "true" && !unref(form).successMessage) {
        _push(`<div class="pt-5">`);
        _push(ssrRenderComponent(_component_FormCheckBox, {
          label: "ارسال دیدگاه از طریق ویس",
          modelValue: unref(sendVoice),
          "onUpdate:modelValue": ($event) => isRef(sendVoice) ? sendVoice.value = $event : null
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(shopSetting)["comment-voice"] == "true" && unref(sendVoice)) {
        _push(ssrRenderComponent(_component_CommentCreateSoundRecording, { product: _ctx.product }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_CommentCreateUploadFile, { product: _ctx.product }, null, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/AddBodyStep.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Footer",
  __ssrInlineRender: true,
  props: {
    step: {},
    product: {},
    formData: {}
  },
  emits: ["next", "submit"],
  setup(__props) {
    const shopSetting = useState("shopSetting");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "border-t-2 px-5 py-3" }, _attrs))}>`);
      if (_ctx.step === 1 && _ctx.product.purchase_status === "purchased") {
        _push(`<button class="c-btn w-full h-11"> ادامه </button>`);
      } else {
        _push(`<div>`);
        if (_ctx.formData.body.length < 3 && _ctx.formData["voice"] == null) {
          _push(`<button class="btn btn-secondary w-full h-11 hover:bg-gray-400"${ssrIncludeBooleanAttr(_ctx.formData.body.length < 3 && _ctx.formData["voice"] == null) ? " disabled" : ""}>`);
          if (_ctx.product.purchase_status === "purchased") {
            _push(`<span>ثبت امتیاز و دیدگاه</span>`);
          } else {
            _push(`<span>ثبت دیدگاه</span>`);
          }
          _push(`</button>`);
        } else {
          _push(`<button class="c-btn w-full">`);
          if (_ctx.product.purchase_status === "purchased") {
            _push(`<span> ثبت امتیاز و دیدگاه </span>`);
          } else {
            _push(`<span>ثبت دیدگاه</span>`);
          }
          _push(`</button>`);
        }
        _push(`<p class="py-2 text-sm text-gray-700 text-center"> ثبت دیدگاه به معنی موافقت با `);
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: "/",
          class: "text-blue-400"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(unref(shopSetting).name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(unref(shopSetting).name), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(` است. </p></div>`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/Footer.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Container",
  __ssrInlineRender: true,
  props: {
    product: {},
    theme: {}
  },
  emits: ["success"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const formStore = commentFormStore(props.product.id);
    const formRef = ref(null);
    const internalRef = ref(null);
    const step = ref(1);
    const emit = __emit;
    const onSuccess = (response) => {
      var _a;
      if (((_a = response.data) == null ? void 0 : _a.status) === "ok") {
        emit("success");
      }
    };
    const completionData = (data) => {
      data = { ...data, ...formStore.formData };
      return data;
    };
    __expose({ show: () => {
      var _a;
      return (_a = internalRef.value) == null ? void 0 : _a.show();
    } });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommentCreateHeader = _sfc_main$8;
      const _component_CommentCreateLoadingOverlay = __nuxt_component_1;
      const _component_FormComponent = _sfc_main$e;
      const _component_CommentCreateAddScoreStep = _sfc_main$6;
      const _component_CommentCreateAddBodyStep = _sfc_main$3;
      const _component_CommentCreateFooter = _sfc_main$2;
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.theme === "desktop" ? _sfc_main$c : _sfc_main$d), mergeProps({
        ref_key: "internalRef",
        ref: internalRef,
        "content-class": "w-full h-full bottom-0",
        direction: "bottom"
      }, _attrs), createSlots({
        header: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_CommentCreateHeader, {
              step: unref(step),
              product: _ctx.product,
              onBack: ($event) => step.value = 1,
              onClose: ($event) => unref(internalRef).hide()
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_CommentCreateHeader, {
                step: unref(step),
                product: _ctx.product,
                onBack: ($event) => step.value = 1,
                onClose: ($event) => unref(internalRef).hide()
              }, null, 8, ["step", "product", "onBack", "onClose"])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a, _b;
          if (_push2) {
            if ((_a = unref(formRef)) == null ? void 0 : _a.loading) {
              _push2(ssrRenderComponent(_component_CommentCreateLoadingOverlay, null, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            if (unref(formStore).successMessage) {
              _push2(`<div class="text-green-500 p-2 my-2 text-center"${_scopeId}>${ssrInterpolate(unref(formStore).successMessage)}</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(_component_FormComponent, {
              result: onSuccess,
              ref_key: "formRef",
              ref: formRef,
              "request-url": "user/comment/add",
              "completion-data": completionData,
              "send-file": ""
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<input type="hidden" name="product_id"${ssrRenderAttr("value", _ctx.product.id)} class="c-input"${_scopeId2}>`);
                  if (unref(step) === 1 && _ctx.product.purchase_status === "purchased") {
                    _push3(ssrRenderComponent(_component_CommentCreateAddScoreStep, { product: _ctx.product }, null, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (unref(step) === 2 || _ctx.product.purchase_status !== "purchased") {
                    _push3(ssrRenderComponent(_component_CommentCreateAddBodyStep, { product: _ctx.product }, null, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (_ctx.product.purchase_status === "purchased") {
                    _push3(`<input name="score"${ssrRenderAttr("value", unref(formStore).score)} class="c-input" type="hidden"${_scopeId2}>`);
                  } else {
                    _push3(`<!---->`);
                  }
                } else {
                  return [
                    createVNode("input", {
                      type: "hidden",
                      name: "product_id",
                      value: _ctx.product.id,
                      class: "c-input"
                    }, null, 8, ["value"]),
                    unref(step) === 1 && _ctx.product.purchase_status === "purchased" ? (openBlock(), createBlock(_component_CommentCreateAddScoreStep, {
                      key: 0,
                      product: _ctx.product
                    }, null, 8, ["product"])) : createCommentVNode("", true),
                    unref(step) === 2 || _ctx.product.purchase_status !== "purchased" ? (openBlock(), createBlock(_component_CommentCreateAddBodyStep, {
                      key: 1,
                      product: _ctx.product
                    }, null, 8, ["product"])) : createCommentVNode("", true),
                    _ctx.product.purchase_status === "purchased" ? (openBlock(), createBlock("input", {
                      key: 2,
                      name: "score",
                      value: unref(formStore).score,
                      class: "c-input",
                      type: "hidden"
                    }, null, 8, ["value"])) : createCommentVNode("", true)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              ((_b = unref(formRef)) == null ? void 0 : _b.loading) ? (openBlock(), createBlock(_component_CommentCreateLoadingOverlay, { key: 0 })) : createCommentVNode("", true),
              unref(formStore).successMessage ? (openBlock(), createBlock("div", {
                key: 1,
                class: "text-green-500 p-2 my-2 text-center"
              }, toDisplayString(unref(formStore).successMessage), 1)) : createCommentVNode("", true),
              createVNode(_component_FormComponent, {
                result: onSuccess,
                ref_key: "formRef",
                ref: formRef,
                "request-url": "user/comment/add",
                "completion-data": completionData,
                "send-file": ""
              }, {
                default: withCtx(() => [
                  createVNode("input", {
                    type: "hidden",
                    name: "product_id",
                    value: _ctx.product.id,
                    class: "c-input"
                  }, null, 8, ["value"]),
                  unref(step) === 1 && _ctx.product.purchase_status === "purchased" ? (openBlock(), createBlock(_component_CommentCreateAddScoreStep, {
                    key: 0,
                    product: _ctx.product
                  }, null, 8, ["product"])) : createCommentVNode("", true),
                  unref(step) === 2 || _ctx.product.purchase_status !== "purchased" ? (openBlock(), createBlock(_component_CommentCreateAddBodyStep, {
                    key: 1,
                    product: _ctx.product
                  }, null, 8, ["product"])) : createCommentVNode("", true),
                  _ctx.product.purchase_status === "purchased" ? (openBlock(), createBlock("input", {
                    key: 2,
                    name: "score",
                    value: unref(formStore).score,
                    class: "c-input",
                    type: "hidden"
                  }, null, 8, ["value"])) : createCommentVNode("", true)
                ]),
                _: 1
              }, 512)
            ];
          }
        }),
        _: 2
      }, [
        !unref(formStore).successMessage ? {
          name: "footer",
          fn: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_CommentCreateFooter, {
                step: unref(step),
                product: _ctx.product,
                "form-data": unref(formStore).formData,
                onNext: ($event) => step.value = 2,
                onSubmit: ($event) => {
                  var _a;
                  return (_a = unref(formRef)) == null ? void 0 : _a.sendForm();
                }
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_CommentCreateFooter, {
                  step: unref(step),
                  product: _ctx.product,
                  "form-data": unref(formStore).formData,
                  onNext: ($event) => step.value = 2,
                  onSubmit: ($event) => {
                    var _a;
                    return (_a = unref(formRef)) == null ? void 0 : _a.sendForm();
                  }
                }, null, 8, ["step", "product", "form-data", "onNext", "onSubmit"])
              ];
            }
          }),
          key: "0"
        } : void 0
      ])), _parent);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/Container.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Dialog",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    product: {}
  }, {
    "modelValue": {},
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose }) {
    const props = __props;
    const theme = useState("theme");
    const score = useModel(__props, "modelValue");
    const boxRef = ref(null);
    const user = useState("user");
    const formStore = commentFormStore(props.product.id);
    const show = () => {
      var _a;
      if (user.value) {
        formStore.successMessage = null;
        formStore.updateFormData({ body: "", files: [] });
        if (score.value && parseInt(score.value.toString()) > 0) {
          formStore.updateScore(parseInt(score.value.toString()));
        }
        (_a = boxRef.value) == null ? void 0 : _a.show();
      } else {
        useRouter().push("/login");
      }
    };
    const handleSuccess = () => {
      formStore.successMessage = "ثبت دیدگاه با موفقیت انجام شد و بعد از تایید نمایش داده خواهد شد";
    };
    watch(() => formStore.score, () => {
      score.value = formStore.score;
    }, { deep: true });
    __expose({ show });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommentCreateContainer = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "add-comment-form" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_CommentCreateContainer, {
        ref_key: "boxRef",
        ref: boxRef,
        product: _ctx.product,
        theme: unref(theme),
        score: score.value,
        "onUpdate:score": ($event) => score.value = $event,
        onSuccess: handleSuccess
      }, null, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/create/Dialog.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=Dialog-CBk-AHyk.js.map
