import { u as useState, g as __nuxt_component_0, b as useRuntimeConfig, e as useRoute, h as _sfc_main$4 } from "../server.mjs";
import { defineComponent, resolveComponent, mergeProps, withCtx, createVNode, toDisplayString, unref, useSSRContext, ref, computed } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { u as useOrderStore } from "./index-Co4X6G3O.js";
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "Header",
  __ssrInlineRender: true,
  props: {
    title: {},
    backRoute: {}
  },
  setup(__props) {
    const shopSetting = useState("shopSetting");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "border rounded-md p-3 flex justify-between items-center" }, _attrs))}><div class="w-full">`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: _ctx.backRoute,
        class: "text-black font-bold"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "arrow-right"] }, null, _parent2, _scopeId));
            _push2(`<span class="px-2"${_scopeId}>${ssrInterpolate(_ctx.title)}</span>`);
          } else {
            return [
              createVNode(_component_fa_icon, { icon: ["fas", "arrow-right"] }),
              createVNode("span", { class: "px-2" }, toDisplayString(_ctx.title), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="w-full flex justify-center">`);
      _push(ssrRenderComponent(_component_nuxt_link, { to: "/" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/" + unref(shopSetting).icon)} class="w-[70px]"${_scopeId}>`);
          } else {
            return [
              createVNode("img", {
                src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/" + unref(shopSetting).icon,
                class: "w-[70px]"
              }, null, 8, ["src"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="w-full"></div></div>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/checkout/Header.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "SubmissionShippingCost",
  __ssrInlineRender: true,
  props: {
    deliveryMethod: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (parseInt(_ctx.deliveryMethod.price) > 0) {
        _push(`<span class="pr-3 font-bold text-black">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(parseInt(_ctx.deliveryMethod.price))))} تومان </span>`);
      } else if (parseInt(_ctx.deliveryMethod.price) == 0) {
        _push(`<span class="pr-3 font-bold text-black"> رایگان </span>`);
      } else {
        _push(`<span class="pr-3 font-bold text-black"> پس کرایه </span>`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/checkout/SubmissionShippingCost.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ShortSubmissionsDetail",
  __ssrInlineRender: true,
  setup(__props) {
    const order = useOrderStore();
    const show = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_OrdersCheckoutSubmissionShippingCost = _sfc_main$2;
      _push(`<!--[--><div class="mr-2 bg-cyan-100 text-cyan-400 rounded-md px-2 py-0.5 text-center cursor-pointer">${ssrInterpolate(_ctx.$replaceEnNumber(Object.keys(unref(order).data.submissions).length))} مرسوله `);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "angle-down"],
        class: "pr-1"
      }, null, _parent));
      _push(`</div>`);
      if (unref(show)) {
        _push(`<div class="absolute top-[25px] bg-white w-[260px] shadow-lg border rounded-md px-5"><!--[-->`);
        ssrRenderList(unref(order).data.submissions, (submission, key) => {
          _push(`<div class="flex items-center justify-between py-4"><div class="flex items-center"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/" + submission["info"].icon)} class="w-4" alt=""><span class="text-gray-800 pr-2">${ssrInterpolate(submission["info"].title)} `);
          if (submission["info"].sender > 0) {
            _push(`<!--[--> - ارسال فروشنده <!--]-->`);
          } else {
            _push(`<!---->`);
          }
          _push(`</span></div>`);
          _push(ssrRenderComponent(_component_OrdersCheckoutSubmissionShippingCost, {
            "delivery-method": submission["info"]
          }, null, _parent));
          _push(`</div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/checkout/ShortSubmissionsDetail.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Factor",
  __ssrInlineRender: true,
  setup(__props) {
    const orderState = useOrderStore();
    const theme = useState("theme");
    const productCount = computed(() => {
      var _a;
      let count = 0;
      const submissions = (_a = orderState.data) == null ? void 0 : _a.submissions;
      if (submissions) {
        Object.values(submissions).forEach((submission) => {
          submission.products.forEach((product) => count += product.count);
        });
      }
      return count;
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_OrdersCheckoutShortSubmissionsDetail = _sfc_main$1;
      const _component_nuxt_link = __nuxt_component_0;
      const _component_Loading = _sfc_main$4;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "text-sm" }, _attrs))}><div class="flex justify-between border-b py-4"><span class="text-gray-500"> قیمت ها (${ssrInterpolate(_ctx.$replaceEnNumber(unref(productCount)))}) </span><span class="text-black font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(orderState).totalPrice)))} تومان </span></div><div class="flex justify-between border-b py-4"><div class="text-gray-500 flex relative text-xs items-center"><span class="text-sm">هزینه ارسال</span>`);
      if (((_a = unref(orderState).data) == null ? void 0 : _a.submissions) && unref(theme) === "desktop") {
        _push(ssrRenderComponent(_component_OrdersCheckoutShortSubmissionsDetail, { class: "font-bold" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div><span class="text-black font-bold">${ssrInterpolate(unref(orderState).totalShippingCost)}</span></div>`);
      if (unref(orderState).taxes() > 0) {
        _push(`<div class="flex justify-between border-b py-4"><div class="text-gray-500 text-xs"><span class="text-sm">مالیات</span></div><span class="text-black font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(orderState).taxes())))} تومان </span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--[-->`);
      ssrRenderList(unref(orderState).itemsDeducted, (item, key) => {
        _push(`<div class="flex justify-between py-4 text-red-500"><span class="text-gray-500">${ssrInterpolate(item.title)}</span><span>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(item.value)))} تومان </span></div>`);
      });
      _push(`<!--]--><div class="flex justify-between py-4"><span class="text-gray-500">قابل پرداخت</span><span class="text-black font-bold">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(orderState).payableAmount)))} تومان </span></div>`);
      if (unref(theme) === "desktop") {
        _push(`<!--[-->`);
        if (unref(orderState).errorInContinue && Object.keys(unref(orderState).errorInContinue).length > 0) {
          _push(`<button class="w-full c-btn2 my-3 px-3">${ssrInterpolate(unref(orderState).errorInContinue[Object.keys(unref(orderState).errorInContinue)[0]])}</button>`);
        } else {
          _push(`<!--[-->`);
          if (("useRoute" in _ctx ? _ctx.useRoute : unref(useRoute))().path === "/checkout/shipping") {
            _push(ssrRenderComponent(_component_nuxt_link, { to: "/checkout/payment" }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<button class="w-full c-btn px-3"${_scopeId}>ثبت سفارش</button>`);
                } else {
                  return [
                    createVNode("button", { class: "w-full c-btn px-3" }, "ثبت سفارش")
                  ];
                }
              }),
              _: 1
            }, _parent));
          } else {
            _push(`<button class="w-full c-btn px-3">`);
            if (!unref(orderState).loading) {
              _push(`<span>پرداخت</span>`);
            } else {
              _push(ssrRenderComponent(_component_Loading, null, null, _parent));
            }
            _push(`</button>`);
          }
          _push(`<!--]-->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/checkout/Factor.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main$3 as _,
  _sfc_main as a
};
//# sourceMappingURL=Factor-gB4gfjyT.js.map
