import { defineComponent, unref, createVNode, resolveDynamicComponent, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderVNode } from "vue/server-renderer";
import { c as useNuxtApp } from "../server.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Items",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const items = useNuxtApp().vueApp.config.globalProperties["$variation:items"];
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}><!--[-->`);
      ssrRenderList(unref(items), (item, key) => {
        _push(`<!--[-->`);
        if (_ctx.product.status == 1) {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(item.component), {
            variations: _ctx.product.variations
          }, null), _parent);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/Items.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=Items-CRlozw8Q.js.map
