import { _ as __nuxt_component_3 } from "./Skeleton-B5XQTW8R.js";
import { d as _sfc_main$3, a as _sfc_main$4, h as _sfc_main$5, u as useState, c as useNuxtApp } from "../server.mjs";
import { defineComponent, ref, watch, resolveComponent, mergeProps, createVNode, resolveDynamicComponent, unref, useSSRContext, shallowRef, withCtx, createBlock, openBlock, Fragment, renderList, createTextVNode, createCommentVNode, toDisplayString } from "vue";
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrRenderVNode, ssrRenderClass, ssrInterpolate } from "vue/server-renderer";
import { s as searchStore } from "./search-products-xw_89Bg_.js";
function useFilterProduct() {
  const store = searchStore();
  const addOrRemoveFilter = (param, status) => {
    const [filterId, itemId] = param.split("-");
    if (filterId && itemId) {
      const queries = { ...store.queries, ...{} };
      const key = `attributes_${filterId}`;
      queries[key] = store.queries[key] || {};
      if (status) {
        queries[key][itemId] = status;
      } else {
        delete queries[key][itemId];
        if (Object.keys(queries[key]).length === 0) {
          delete queries[key];
        }
      }
      store.updateQueries(queries);
    }
  };
  return {
    addOrRemoveFilter,
    store
  };
}
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "DesktopView",
  __ssrInlineRender: true,
  props: {
    filters: {},
    loading: { type: Boolean },
    category_id: {},
    options: {}
  },
  setup(__props) {
    const props = __props;
    const {
      store,
      addOrRemoveFilter
    } = useFilterProduct();
    const boxStats = ref({});
    const selectedFilters = ref({});
    watch(() => store.queries, () => {
      if (Object.keys(store.queries).length === 0) {
        boxStats.value = {};
      }
    });
    watch(() => props.filters, () => {
      props.filters.forEach((filter) => {
        if (store.queries["attributes_" + filter.id]) {
          filter.childs.forEach((item) => {
            if (store.queries["attributes_" + filter.id][item.id]) {
              selectedFilters.value[item.id] = true;
            }
          });
        }
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Skeleton = __nuxt_component_3;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FormCheckBox = _sfc_main$3;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "my-3" }, _attrs))}>`);
      if (_ctx.loading) {
        _push(`<div><!--[-->`);
        ssrRenderList(7, (i) => {
          _push(`<div class="px-3">`);
          _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-5 rounded-md my-2" }, null, _parent));
          _push(`</div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!--[--><!--[-->`);
        ssrRenderList(_ctx.options, (option) => {
          _push(`<!--[-->`);
          if (!option.whereAdd || option.whereAdd(_ctx.category_id)) {
            ssrRenderVNode(_push, createVNode(resolveDynamicComponent(option.component), { category_id: _ctx.category_id }, null), _parent);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><!--[-->`);
        ssrRenderList(_ctx.filters, (filter, key) => {
          _push(`<div class="${ssrRenderClass([{ "border-b-0": key == _ctx.filters.length - 1 }, "filter-box"])}"><div class="title"><div class="flex items-center">${ssrInterpolate(filter.name)} `);
          if (unref(store).queries["attributes_" + filter.id]) {
            _push(`<div class="w-1 h-1 rounded-full bg-blue-400 mx-1"></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            class: "text-gray-500",
            icon: [
              "fas",
              unref(boxStats)[filter.id] ? "fa-angle-up" : "fa-angle-down"
            ]
          }, null, _parent));
          _push(`</div>`);
          if (unref(boxStats)[filter.id]) {
            _push(`<div class="content"><ul><!--[-->`);
            ssrRenderList(filter.childs, (child) => {
              _push(`<li class="flex items-center py-3">`);
              _push(ssrRenderComponent(_component_FormCheckBox, {
                label: child.name,
                name: filter.id + "-" + child.id,
                afterClick: unref(addOrRemoveFilter),
                modelValue: unref(selectedFilters)[child.id],
                "onUpdate:modelValue": ($event) => unref(selectedFilters)[child.id] = $event
              }, null, _parent));
              _push(`</li>`);
            });
            _push(`<!--]--></ul></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        });
        _push(`<!--]--><!--]-->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/filters/DesktopView.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
function useFilters(store) {
  const title = ref("فیلترها");
  const showAllFilters = ref(true);
  const filterBoxRef = shallowRef(null);
  const optionRefBox = shallowRef(null);
  const selectedFilter = ref(null);
  const selectedFilters = ref({});
  const selectedOption = ref();
  const showOrHideChildBox = (filter) => {
    selectedFilter.value = filter;
    title.value = selectedFilter.value.name;
  };
  const addOrRemoveFilter = (param, status) => {
    const [filterId, itemId] = param.split("-");
    if (filterId && itemId) {
      const key = `attributes_${filterId}`;
      store.queries[key] = store.queries[key] || {};
      if (status) {
        store.queries[key][itemId] = status;
      } else {
        delete store.queries[key][itemId];
        if (Object.keys(store.queries[key]).length === 0) {
          delete store.queries[key];
        }
      }
    }
  };
  const showMainFiltersList = () => {
    selectedFilter.value = null;
    title.value = "فیلترها";
  };
  const showFilterBox = (filter) => {
    selectedFilter.value = filter ?? null;
    filterBoxRef.value.show();
    showAllFilters.value = filter == void 0;
    if (filter) {
      title.value = filter.name;
    }
  };
  const showOption = (option) => {
    if (option.child == false) {
      if (store.queries[option.param]) {
        delete store.queries[option.param];
      } else {
        store.queries = { ...store.queries, ...{ [option.param]: true } };
      }
    } else {
      title.value = option.title;
      selectedOption.value = option;
      optionRefBox.value.show();
    }
  };
  const removeFilterWithParam = (param) => {
    delete store.queries[param];
    optionRefBox.value.hide();
  };
  const removeAllFilters = () => {
    store.queries = {};
    filterBoxRef.value.hide();
  };
  return {
    title,
    showAllFilters,
    filterBoxRef,
    selectedFilter,
    selectedFilters,
    optionRefBox,
    selectedOption,
    removeAllFilters,
    removeFilterWithParam,
    showOrHideChildBox,
    addOrRemoveFilter,
    showMainFiltersList,
    showFilterBox,
    showOption
  };
}
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "MobileView",
  __ssrInlineRender: true,
  props: {
    filters: {},
    loading: { type: Boolean },
    category_id: {},
    options: {}
  },
  setup(__props) {
    const store = searchStore();
    const {
      title,
      showAllFilters,
      filterBoxRef,
      selectedFilter,
      selectedFilters,
      optionRefBox,
      selectedOption,
      showOrHideChildBox,
      addOrRemoveFilter,
      showMainFiltersList,
      removeFilterWithParam,
      removeAllFilters
    } = useFilters(store);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_Offcanvas = _sfc_main$4;
      const _component_FormCheckBox = _sfc_main$3;
      const _component_Loading = _sfc_main$5;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="flex items-start"><div class="item">`);
      _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "filter"] }, null, _parent));
      _push(`<span>فیلتر ها</span></div><!--[-->`);
      ssrRenderList(_ctx.options, (option) => {
        _push(`<!--[-->`);
        if (option.whereAdd == void 0 || option.whereAdd(_ctx.category_id)) {
          _push(`<div class="${ssrRenderClass([{ "active": unref(store).queries[option.param] }, "item"])}"><span class="!pr-0">${ssrInterpolate(option.title)}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--><!--[-->`);
      ssrRenderList(_ctx.filters, (filter, key) => {
        _push(`<div class="${ssrRenderClass([{ "active": unref(store).queries["attributes_" + filter.id] }, "item"])}"><span>${ssrInterpolate(filter.name)}</span></div>`);
      });
      _push(`<!--]--></div>`);
      _push(ssrRenderComponent(_component_Offcanvas, {
        ref_key: "filterBoxRef",
        ref: filterBoxRef,
        title: unref(title),
        direction: "bottom",
        "content-class": "w-full " + (unref(selectedFilter) ? "!h-auto bottom-0" : ""),
        "back-function": unref(selectedFilter) != null && unref(showAllFilters) ? unref(showMainFiltersList) : void 0
      }, {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="grid grid-cols-2 gap-2 p-4"${_scopeId}><button class="c-btn"${_scopeId}><span${_scopeId}>مشاهده ${ssrInterpolate(_ctx.$replaceEnNumber(unref(store).result.products.total))} محصول</span></button><button class="c-btn2"${_scopeId}> حذف فیلترها </button></div>`);
          } else {
            return [
              createVNode("div", { class: "grid grid-cols-2 gap-2 p-4" }, [
                createVNode("button", {
                  class: "c-btn",
                  onClick: ($event) => unref(filterBoxRef).hide()
                }, [
                  createVNode("span", null, "مشاهده " + toDisplayString(_ctx.$replaceEnNumber(unref(store).result.products.total)) + " محصول", 1)
                ], 8, ["onClick"]),
                createVNode("button", {
                  class: "c-btn2",
                  onClick: ($event) => unref(removeAllFilters)()
                }, " حذف فیلترها ", 8, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (!unref(selectedFilter)) {
              _push2(`<!--[--><!--[-->`);
              ssrRenderList(_ctx.options, (option, key) => {
                ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(option.component), {
                  key,
                  category_id: _ctx.category_id
                }, null), _parent2, _scopeId);
              });
              _push2(`<!--]--><!--[-->`);
              ssrRenderList(_ctx.filters, (filter, key) => {
                _push2(`<div class="${ssrRenderClass([{ "border-b-0": key == _ctx.filters.length - 1 }, "filter-box"])}"${_scopeId}><div class="title"${_scopeId}><div class="flex items-center"${_scopeId}>${ssrInterpolate(filter.name)} `);
                if (unref(store).queries["attributes_" + filter.id]) {
                  _push2(`<div class="w-1 h-1 rounded-full bg-blue-400 mx-1"${_scopeId}></div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`</div>`);
                _push2(ssrRenderComponent(_component_fa_icon, {
                  class: "text-gray-500",
                  icon: ["fas", "fa-angle-left"]
                }, null, _parent2, _scopeId));
                _push2(`</div></div>`);
              });
              _push2(`<!--]--><!--]-->`);
            } else {
              _push2(`<div class="px-4"${_scopeId}><ul class="p-0"${_scopeId}><!--[-->`);
              ssrRenderList(unref(selectedFilter).childs, (item) => {
                _push2(`<li class="flex items-center py-3"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_FormCheckBox, {
                  label: item.name,
                  name: unref(selectedFilter).id + "-" + item.id,
                  afterClick: unref(addOrRemoveFilter),
                  modelValue: unref(selectedFilters)[item.id],
                  "onUpdate:modelValue": ($event) => unref(selectedFilters)[item.id] = $event
                }, null, _parent2, _scopeId));
                _push2(`</li>`);
              });
              _push2(`<!--]--></ul></div>`);
            }
          } else {
            return [
              !unref(selectedFilter) ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                (openBlock(true), createBlock(Fragment, null, renderList(_ctx.options, (option, key) => {
                  return openBlock(), createBlock(resolveDynamicComponent(option.component), {
                    key,
                    category_id: _ctx.category_id
                  }, null, 8, ["category_id"]);
                }), 128)),
                (openBlock(true), createBlock(Fragment, null, renderList(_ctx.filters, (filter, key) => {
                  return openBlock(), createBlock("div", {
                    class: ["filter-box", { "border-b-0": key == _ctx.filters.length - 1 }],
                    key: filter.id
                  }, [
                    createVNode("div", {
                      onClick: ($event) => unref(showOrHideChildBox)(filter),
                      class: "title"
                    }, [
                      createVNode("div", { class: "flex items-center" }, [
                        createTextVNode(toDisplayString(filter.name) + " ", 1),
                        unref(store).queries["attributes_" + filter.id] ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "w-1 h-1 rounded-full bg-blue-400 mx-1"
                        })) : createCommentVNode("", true)
                      ]),
                      createVNode(_component_fa_icon, {
                        class: "text-gray-500",
                        icon: ["fas", "fa-angle-left"]
                      })
                    ], 8, ["onClick"])
                  ], 2);
                }), 128))
              ], 64)) : (openBlock(), createBlock("div", {
                key: 1,
                class: "px-4"
              }, [
                createVNode("ul", { class: "p-0" }, [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(selectedFilter).childs, (item) => {
                    return openBlock(), createBlock("li", {
                      key: item.id,
                      class: "flex items-center py-3"
                    }, [
                      createVNode(_component_FormCheckBox, {
                        label: item.name,
                        name: unref(selectedFilter).id + "-" + item.id,
                        afterClick: unref(addOrRemoveFilter),
                        modelValue: unref(selectedFilters)[item.id],
                        "onUpdate:modelValue": ($event) => unref(selectedFilters)[item.id] = $event
                      }, null, 8, ["label", "name", "afterClick", "modelValue", "onUpdate:modelValue"])
                    ]);
                  }), 128))
                ])
              ]))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Offcanvas, {
        ref_key: "optionRefBox",
        ref: optionRefBox,
        title: unref(title),
        direction: "bottom",
        "content-class": "w-full !h-auto bottom-0"
      }, {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="grid grid-cols-2 gap-2 p-4"${_scopeId}><button class="c-btn"${_scopeId}>`);
            if (unref(store).result && unref(store).result.products) {
              _push2(`<span${_scopeId}> مشاهده ${ssrInterpolate(_ctx.$replaceEnNumber(unref(store).result.products.total))} محصول </span>`);
            } else {
              _push2(ssrRenderComponent(_component_Loading, null, null, _parent2, _scopeId));
            }
            _push2(`</button><button class="c-btn2"${_scopeId}> حذف فیلتر </button></div>`);
          } else {
            return [
              createVNode("div", { class: "grid grid-cols-2 gap-2 p-4" }, [
                createVNode("button", {
                  class: "c-btn",
                  onClick: ($event) => unref(optionRefBox).hide()
                }, [
                  unref(store).result && unref(store).result.products ? (openBlock(), createBlock("span", { key: 0 }, " مشاهده " + toDisplayString(_ctx.$replaceEnNumber(unref(store).result.products.total)) + " محصول ", 1)) : (openBlock(), createBlock(_component_Loading, { key: 1 }))
                ], 8, ["onClick"]),
                createVNode("button", {
                  class: "c-btn2",
                  onClick: ($event) => unref(removeFilterWithParam)(unref(selectedOption).param)
                }, " حذف فیلتر ", 8, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(unref(selectedOption).component), {
              "hide-title": "",
              "mobile-theme": ""
            }, null), _parent2, _scopeId);
          } else {
            return [
              (openBlock(), createBlock(resolveDynamicComponent(unref(selectedOption).component), {
                "hide-title": "",
                "mobile-theme": ""
              }))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/filters/MobileView.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "List",
  __ssrInlineRender: true,
  props: {
    category_id: {}
  },
  setup(__props) {
    const theme = useState("theme");
    const filters = ref([]);
    const loading = ref(true);
    let options = useNuxtApp().vueApp.config.globalProperties["$filters:options"];
    if (options) {
      options = useNuxtApp().vueApp.config.globalProperties.$sort(options, "index");
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FiltersDesktopView = _sfc_main$2;
      const _component_FiltersMobileView = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_FiltersDesktopView, {
          filters: unref(filters),
          loading: unref(loading),
          category_id: _ctx.category_id,
          options: unref(options)
        }, null, _parent));
      } else {
        _push(ssrRenderComponent(_component_FiltersMobileView, {
          filters: unref(filters),
          loading: unref(loading),
          category_id: _ctx.category_id,
          options: unref(options)
        }, null, _parent));
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/filters/List.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=List-2tRGzJIt.js.map
