import { defineComponent, ref, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs } from "vue/server-renderer";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "MoreText",
  __ssrInlineRender: true,
  props: {
    text: {},
    length: {}
  },
  setup(__props) {
    const showAll = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      if (_ctx.text) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "leading-8 more-text" }, _attrs))}><div>${(unref(showAll) || _ctx.text.length <= (_ctx.length ?? 300) ? _ctx.text : _ctx.text.substring(0, _ctx.length ?? 300) + "...") ?? ""}</div>`);
        if (_ctx.text.length > (_ctx.length ?? 300)) {
          _push(`<p class="tag">`);
          if (!unref(showAll)) {
            _push(`<span> بیشتر </span>`);
          } else {
            _push(`<span> کمتر </span>`);
          }
          _push(`</p>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/widgets/MoreText.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=MoreText-CtkeWBXn.js.map
