import { _ as __nuxt_component_3 } from "./Skeleton-B5XQTW8R.js";
import { c as useNuxtApp, m as useFetch, b as useRuntimeConfig, g as __nuxt_component_0 } from "../server.mjs";
import { defineComponent, withAsyncContext, computed, resolveComponent, mergeProps, unref, withCtx, createVNode, toDisplayString, useSSRContext, ref, createTextVNode } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderAttr, ssrInterpolate } from "vue/server-renderer";
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "Categories",
  __ssrInlineRender: true,
  props: {
    searchText: {},
    getCategories: { type: Function }
  },
  async setup(__props) {
    let __temp, __restore;
    const props = __props;
    const nuxtApp = useNuxtApp();
    const { data: categories, status } = ([__temp, __restore] = withAsyncContext(() => useFetch(
      useRuntimeConfig().public.api + "/faq/category/all",
      {
        key: "faq-categories-cache",
        getCachedData(key) {
          return nuxtApp.payload.data[key] || nuxtApp.static.data[key];
        }
      },
      "$nC3zQBrqnX"
    )), __temp = await __temp, __restore(), __temp);
    if (categories.value && props.getCategories) {
      props.getCategories(categories.value);
    }
    const filteredCategories = computed(() => {
      if (props.searchText && categories.value) {
        return categories.value.filter(
          (category) => category.name.includes(props.searchText)
        );
      }
      return categories.value;
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_Skeleton = __nuxt_component_3;
      const _component_nuxt_link = __nuxt_component_0;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full flex flex-col items-center" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "puzzle-piece"],
        class: "text-2xl text-blue-400"
      }, null, _parent));
      _push(`<h5 class="font-bold py-4"> دسته‌بندی پرسش‌ها </h5>`);
      if (unref(status) !== "success") {
        _push(`<div class="categories"><!--[-->`);
        ssrRenderList(20, (i) => {
          _push(`<div class="category">`);
          _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-32" }, null, _parent));
          _push(`</div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(categories) && unref(categories).length > 0) {
        _push(`<div class="categories"><!--[-->`);
        ssrRenderList(unref(filteredCategories), (category) => {
          _push(ssrRenderComponent(_component_nuxt_link, {
            class: "category",
            to: "/faq/category/" + category.id
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/upload/" + category.icon)}${ssrRenderAttr("alt", category.name)}${_scopeId}><span${_scopeId}>${ssrInterpolate(category.name)}</span>`);
              } else {
                return [
                  createVNode("img", {
                    src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/upload/" + category.icon,
                    alt: category.name
                  }, null, 8, ["src", "alt"]),
                  createVNode("span", null, toDisplayString(category.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/faq/Categories.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "QuestionsList",
  __ssrInlineRender: true,
  props: {
    questions: {}
  },
  setup(__props) {
    const showContent = ref({});
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_router_link = resolveComponent("router-link");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full questions-list" }, _attrs))}><!--[-->`);
      ssrRenderList(_ctx.questions, (question) => {
        _push(`<div class="question"><div class="title"><span class="font-bold">${ssrInterpolate(question.title)}</span>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", unref(showContent)[question.id] == true ? "fa-angle-up" : "fa-angle-down"]
        }, null, _parent));
        _push(`</div>`);
        if (unref(showContent)[question.id]) {
          _push(`<div class="py-3 leading-8 text-[15px]"><div>${question.short_answer ?? ""}</div><div class="w-full flex justify-start">`);
          _push(ssrRenderComponent(_component_router_link, {
            to: "/faq/question/" + question.id,
            class: "text-blue-500 text-sm"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(` مشاهده توضیحات تکمیلی `);
              } else {
                return [
                  createTextVNode(" مشاهده توضیحات تکمیلی ")
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      });
      _push(`<!--]--></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/faq/QuestionsList.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "PopularQuestion",
  __ssrInlineRender: true,
  setup(__props) {
    const { data: questions, status } = useFetch(
      useRuntimeConfig().public.api + "/faq/questions?popular=true",
      "$IcYQAq7WN7"
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FaqQuestionsList = _sfc_main$1;
      if (unref(status) == "success" && unref(questions) && unref(questions).length > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full flex-col flex items-center py-7" }, _attrs))}>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["far", "circle-question"],
          class: "text-xl text-blue-500 my-4"
        }, null, _parent));
        _push(`<h5 class="font-bold">پرسش‌های متداول</h5>`);
        _push(ssrRenderComponent(_component_FaqQuestionsList, { questions: unref(questions) }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/faq/PopularQuestion.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main$2 as _,
  _sfc_main as a,
  _sfc_main$1 as b
};
//# sourceMappingURL=PopularQuestion-pEC7Yvxp.js.map
