import { defineComponent, computed, unref, createVNode, resolveDynamicComponent, useSSRContext } from "vue";
import { ssrRenderList, ssrRenderVNode } from "vue/server-renderer";
import { u as useState } from "../server.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "PositionView",
  __ssrInlineRender: true,
  props: {
    position: {}
  },
  setup(__props) {
    const themeSetting = useState("theme-setting");
    const props = __props;
    const rows = computed(() => {
      const setting = themeSetting.value[props.position];
      if (setting && setting.rows) {
        return setting.rows;
      }
      return [];
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      ssrRenderList(unref(rows), (row, key) => {
        _push(`<div>`);
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(row.component), {
          setting: row.setting
        }, null), _parent);
        _push(`</div>`);
      });
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/design/PositionView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=PositionView-ByKT-amv.js.map
