import { y as _sfc_main$1 } from "../server.mjs";
import { defineComponent, computed, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderStyle, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ProductFooter",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const timeRemaining = computed(() => {
      let currentTimestamp = Date.now();
      currentTimestamp = Math.floor(currentTimestamp / 1e3);
      return props.product.variation.end_amazing_offer - currentTimestamp;
    });
    const soldPercentage = computed(() => {
      const productCount = props.product.variation.product_count;
      const amazingOfferCount = props.product.variation.amazing_offer_count;
      if (productCount === 0) return 0;
      const soldCount = amazingOfferCount - productCount;
      return Math.floor(soldCount / amazingOfferCount * 100);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Timer = _sfc_main$1;
      if (_ctx.product && _ctx.product.variation && _ctx.product.variation.amazing_offer_count) {
        _push(`<div${ssrRenderAttrs(_attrs)}>`);
        if (unref(soldPercentage) >= 50) {
          _push(`<div class="w-full h-1" style="${ssrRenderStyle({ "direction": "ltr" })}"><div class="h-full bg-red-600" style="${ssrRenderStyle({ width: unref(soldPercentage) + "%" })}"></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="flex w-full pt-1 justify-between items-center text-red-500">`);
        if (unref(soldPercentage) >= 50) {
          _push(`<div class="text-sm"><span>${ssrInterpolate(_ctx.$replaceEnNumber(unref(soldPercentage)))}% </span><span class="text-gray-500"> فروش رفته </span></div>`);
        } else {
          _push(`<div></div>`);
        }
        if (_ctx.product.variation.end_amazing_offer) {
          _push(ssrRenderComponent(_component_Timer, {
            "total-seconds": unref(timeRemaining) > 0 ? unref(timeRemaining) : 24 * 60 * 60,
            class: "!p-0 font-bold"
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/promotions/ProductFooter.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=ProductFooter-C3hk50fR.js.map
