import { _ as _sfc_main$1 } from "./Tooltip-B8G2HT4W.js";
import { defineComponent, ref, watch, resolveComponent, unref, mergeProps, withCtx, createVNode, toDisplayString, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderList, ssrRenderComponent, ssrRenderStyle, ssrRenderClass } from "vue/server-renderer";
import { u as useState } from "../server.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SelectComponent",
  __ssrInlineRender: true,
  props: ["variations"],
  setup(__props) {
    const theme = useState("theme");
    const props = __props;
    const colors = ref([]);
    const selectedColor = ref(null);
    const selectedVariationId = useState("variation-id");
    const variationIndex = ref(1);
    let selectedVariation = null;
    const afterChangedList = () => {
      selectedVariation = props.variations.find((variation) => variation.id == selectedVariationId.value);
      if (selectedVariation) {
        for (let i = 1; i <= 3; i++) {
          if (selectedVariation["param" + i + "_type"] == "\\Modules\\Colors\\Models\\Color") {
            variationIndex.value = i;
          }
        }
      }
      createColorsList();
      if (colors.value.length > 0) {
        selectedColor.value = colors.value[0].name;
      }
    };
    const createColorsList = () => {
      colors.value = [];
      if (selectedVariation) {
        colors.value = [
          ...new Map(
            props.variations.filter(
              (variation) => variation[`param${variationIndex.value}_type`] === "\\Modules\\Colors\\Models\\Color" && variation[`param${variationIndex.value}`]
            ).map((variation) => variation[`param${variationIndex.value}`]).map((color) => [color.name, color])
            // استفاده از Map برای حذف تکراری‌ها بر اساس name
          ).values()
        ];
      }
    };
    const updateSelectedColor = (color) => {
      const variation = props.variations.find(
        (variation2) => variation2[`param${variationIndex.value}_id`] === color.id
      );
      if (variation) {
        selectedColor.value = color.name;
        selectedVariation = variation;
        selectedVariationId.value = variation.id;
      }
    };
    watch(() => selectedVariationId.value, () => {
      if (colors.value.length == 0) {
        afterChangedList();
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_tooltip = _sfc_main$1;
      const _component_fa_icon = resolveComponent("fa-icon");
      if (unref(colors).length > 0 && unref(selectedColor) != null) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full colors" }, _attrs))}><div class="w-full my-3"><span class="text-gray-600">رنگ : </span><span class="text-black font-bold">${ssrInterpolate(unref(selectedColor))}</span></div>`);
        if (unref(theme) === "desktop") {
          _push(`<ul class="flex w-full flex-wrap"><!--[-->`);
          ssrRenderList(unref(colors), (color, key) => {
            _push(`<li class="m-1">`);
            _push(ssrRenderComponent(_component_tooltip, null, {
              tag: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<div class="rounded-full w-10 h-10 border flex items-center justify-center"${_scopeId}><div style="${ssrRenderStyle({ backgroundColor: color.code })}" class="${ssrRenderClass([{ "active": unref(selectedColor) == color.name }, "rounded-full w-9 h-9 flex items-center justify-center"])}"${_scopeId}>`);
                  if (unref(selectedColor) == color.name) {
                    _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fa", "check"] }, null, _parent2, _scopeId));
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`</div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "rounded-full w-10 h-10 border flex items-center justify-center" }, [
                      createVNode("div", {
                        style: { backgroundColor: color.code },
                        class: [{ "active": unref(selectedColor) == color.name }, "rounded-full w-9 h-9 flex items-center justify-center"],
                        onClick: ($event) => updateSelectedColor(color)
                      }, [
                        unref(selectedColor) == color.name ? (openBlock(), createBlock(_component_fa_icon, {
                          key: 0,
                          icon: ["fa", "check"]
                        })) : createCommentVNode("", true)
                      ], 14, ["onClick"])
                    ])
                  ];
                }
              }),
              content: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`<span class="text-sm"${_scopeId}>${ssrInterpolate(color.name)}</span>`);
                } else {
                  return [
                    createVNode("span", { class: "text-sm" }, toDisplayString(color.name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</li>`);
          });
          _push(`<!--]--></ul>`);
        } else {
          _push(`<ul class="flex w-full flex-wrap r-colors"><!--[-->`);
          ssrRenderList(unref(colors), (color, key) => {
            _push(`<li class="${ssrRenderClass({ "active": unref(selectedColor) == color.name })}"><div style="${ssrRenderStyle({ backgroundColor: color.code })}" class="circle">`);
            if (unref(selectedColor) == color.name) {
              _push(ssrRenderComponent(_component_fa_icon, {
                icon: ["fa", "check"],
                class: [color.name != "سیاه" ? "text-black" : "text-white"]
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`</div><span class="pr-3">${ssrInterpolate(color.name)}</span></li>`);
          });
          _push(`<!--]--></ul>`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/color/SelectComponent.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=SelectComponent-BPlpwZg-.js.map
