import { defineComponent, resolveComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import { u as useState } from "../server.mjs";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SendDetail",
  __ssrInlineRender: true,
  props: {
    variation: {}
  },
  setup(__props) {
    const shopSetting = useState("shopSetting");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "px-3 flex items-center" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "truck-moving"],
        class: "text-black"
      }, null, _parent));
      _push(`<div class="text-xs px-1.5"><span> ارسال توسط </span>`);
      if (_ctx.variation.sender == "self") {
        _push(`<span>${ssrInterpolate(unref(shopSetting).name)}</span>`);
      } else {
        _push(`<span>فروشنده</span>`);
      }
      if (_ctx.variation.preparation_time > 0) {
        _push(`<span> از ${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.variation.preparation_time))} روز کاری آینده </span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/SendDetail.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=SendDetail-CCtW5pOV.js.map
