import { _ as _sfc_main$1 } from "./Tooltip-B8G2HT4W.js";
import { defineComponent, ref, resolveComponent, unref, mergeProps, createSlots, withCtx, createVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderAttrs } from "vue/server-renderer";
import { u as useState, n as navigateTo, c as useNuxtApp, b as useRuntimeConfig } from "../server.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ShortCode",
  __ssrInlineRender: true,
  props: {
    product: {},
    hideTooltip: { type: Boolean }
  },
  setup(__props) {
    const toast = useState("toast");
    const theme = useState("theme");
    const props = __props;
    const user = useState("user");
    const added = ref(false);
    const addToFavoriteList = () => {
      if (user.value == null) {
        navigateTo("/login");
      } else {
        useNuxtApp().$axios.post(
          useRuntimeConfig().public.api + "/user/product/" + props.product.id + "/favorite/add"
        ).then((response) => {
          if (response.data.status == "ok") {
            added.value = true;
          }
        }).catch(() => {
          showToastError();
        });
      }
    };
    const showToastError = () => {
      toast.value = {
        type: "error",
        message: "خطا در اجرای درخواست مجددا تلاش نمایید"
      };
    };
    const removeFromFavoriteList = () => {
      useNuxtApp().$axios.delete(
        useRuntimeConfig().public.api + "/user/product/" + props.product.id + "/favorite/remove"
      ).then((response) => {
        added.value = false;
      }).catch(() => {
        showToastError();
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Tooltip = _sfc_main$1;
      const _component_fa_icon = resolveComponent("fa-icon");
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_Tooltip, mergeProps({ position: "left" }, _attrs), createSlots({
          tag: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["far", "heart"],
                class: ["text-xl cursor-pointer", { "!text-red-600": unref(added) == true }],
                onClick: ($event) => unref(added) == false ? addToFavoriteList() : removeFromFavoriteList()
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_fa_icon, {
                  icon: ["far", "heart"],
                  class: ["text-xl cursor-pointer", { "!text-red-600": unref(added) == true }],
                  onClick: ($event) => unref(added) == false ? addToFavoriteList() : removeFromFavoriteList()
                }, null, 8, ["class", "onClick"])
              ];
            }
          }),
          _: 2
        }, [
          _ctx.hideTooltip == false ? {
            name: "content",
            fn: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div${_scopeId}> افزودن به علاقه مندی ها </div>`);
              } else {
                return [
                  createVNode("div", null, " افزودن به علاقه مندی ها ")
                ];
              }
            }),
            key: "0"
          } : void 0
        ]), _parent));
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center cursor-pointer" }, _attrs))}>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["far", "heart"],
          class: ["text-xl cursor-pointer", { "!text-red-600": unref(added) == true }]
        }, null, _parent));
        _push(`<span class="pr-3">افزودن به علاقه مندی ها</span></div>`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/favourite/ShortCode.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=ShortCode-4kMpWOYS.js.map
