import { _ as _sfc_main$1 } from "./Tooltip-B8G2HT4W.js";
import { u as useState, c as useNuxtApp, b as useRuntimeConfig, h as _sfc_main$2, _ as _sfc_main$3, a as _sfc_main$4 } from "../server.mjs";
import { ref, defineComponent, resolveComponent, mergeProps, unref, createSlots, withCtx, createVNode, createBlock, openBlock, resolveDynamicComponent, Fragment, renderList, createCommentVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderVNode, ssrRenderList, ssrRenderClass, ssrInterpolate } from "vue/server-renderer";
import { u as useMonthsList } from "./MonthsList-B1ySoCWX.js";
import "highcharts";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const useChart = (product) => {
  const theme = useState("theme");
  const chartBox = ref(null);
  const months = useMonthsList();
  const global = useNuxtApp().vueApp.config.globalProperties;
  const dataByDate = {};
  const selectedVariation = ref(null);
  const { api } = useRuntimeConfig().public;
  const { $axios } = useNuxtApp();
  const loading = ref(false);
  const toast = useState("toast");
  const data = ref({});
  const chartOptions = ref({
    chart: {
      type: "line",
      style: {
        fontFamily: "inherit"
      },
      height: theme.value == "desktop" ? 350 : "auto"
    },
    title: {
      text: ""
    },
    yAxis: {
      title: { text: "" },
      labels: {
        formatter() {
          let value = this.value;
          value = global.$replaceEnNumber(global.$numberFormat(value));
          return `<div style="direction:rtl"><span>${value}</span><span> تومان </span></div>`;
        },
        style: {
          fontSize: "12px"
        },
        useHTML: true
      },
      tickPositioner: function() {
        const max = this.max;
        const min = this.min;
        const range = max - min;
        const step = Math.ceil(range / 4);
        const ticks = [];
        for (let i = min; i <= max; i += step) {
          ticks.push(i);
        }
        return ticks;
      }
    },
    xAxis: {
      categories: [],
      crosshair: {
        color: "rgba(236,235,235,0.54)",
        width: 20,
        zIndex: 3
      },
      labels: {
        formatter: function() {
          const categories = chartOptions.value.xAxis.categories;
          if (this.isFirst || this.isLast) {
            const category = global.$replaceEnNumber(categories[this.pos]);
            return `<span style="direction:rtl;">${category}</span>`;
          }
          return "";
        },
        useHTML: true
      }
    },
    tooltip: {
      useHTML: true,
      padding: 0,
      shadow: false,
      formatter() {
        let html = '<div class="price-chart-tooltip">';
        if (dataByDate[this.x] && dataByDate[this.x].seller) {
          html += `<p>
                           <img alt="" width="15px" src="${useRuntimeConfig().public.appUrl + "/images/house-solid.svg"}"/>
                           <span style="padding:0 5px">${dataByDate[this.x].seller.brandName}</span>
                           </p>`;
        }
        if (dataByDate[this.x] && dataByDate[this.x].param2) {
          html += `<p>
                          <img alt="" width="15px" src="${useRuntimeConfig().public.appUrl + "/images/circle-check-solid.svg"}"/>
                          <span style="padding:0 5px">${dataByDate[this.x].param2.name}</span>
                    </p>`;
        }
        html += `<p style="font-weight:bold;font-size:15px">${global.$replaceEnNumber(global.$numberFormat(this.y))} تومان</p><p style="font-size:13px;color:gray">${global.$replaceEnNumber(global.$getDate(dataByDate[this.x].time))} </p></div>`;
        return html;
      },
      style: { fontSize: "14px" }
    },
    plotOptions: {
      series: {
        marker: {
          enabled: false
        }
      }
    },
    series: [
      {
        name: "",
        data: []
      }
    ],
    legend: {
      enabled: false
    }
  });
  const getChartData = () => {
    loading.value = true;
    $axios.get(api + "/product/" + product.id + "/changes-chart").then((response) => {
      var _a;
      data.value = response.data;
      if (data.value && Object.keys(data.value).length > 0) {
        (_a = chartBox.value) == null ? void 0 : _a.show();
        const keys = Object.keys(data.value);
        if (!selectedVariation.value && data.value[keys[0]]) {
          selectedVariation.value = parseInt(keys[0]);
          updateChart();
        }
      } else {
        toast.value = { message: "تغییرات قیمت طی یک ماه برای این کالا ثبت نشده" };
      }
    }).finally(() => {
      loading.value = false;
    });
  };
  const updateChart = () => {
    var _a;
    const changes = ((_a = data.value[selectedVariation.value]) == null ? void 0 : _a.changes) || [];
    const times = [];
    const chartValues = [];
    const zones = [];
    let lastValue = 0;
    changes.forEach((row, index) => {
      const dateData = global.$getDate(row.time);
      const [_, month, day] = dateData.toString().split("/");
      times.push(months[month] + "-" + day);
      dataByDate[months[month] + "-" + day] = row;
      const price = row.price;
      if (price === 0 && lastValue !== null) {
        chartValues.push(lastValue);
        zones.push({
          value: index,
          color: "#bbbbbb"
        });
      } else {
        chartValues.push(price);
        lastValue = price;
        zones.push({
          value: index,
          color: "#4BBFD3"
        });
      }
    });
    chartOptions.value.xAxis.categories = times;
    chartOptions.value.series = [
      {
        name: "قیمت",
        data: chartValues,
        zoneAxis: "x",
        zones
      }
    ];
  };
  const handleVariationClick = (key) => {
    selectedVariation.value = key;
    updateChart();
  };
  return {
    theme,
    chartBox,
    chartOptions,
    data,
    selectedVariation,
    loading,
    getChartData,
    handleVariationClick
  };
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ShortCut",
  __ssrInlineRender: true,
  props: {
    product: {},
    hideTooltip: { type: Boolean }
  },
  setup(__props) {
    const props = __props;
    const {
      theme,
      chartBox,
      chartOptions,
      data,
      loading,
      selectedVariation,
      handleVariationClick,
      getChartData
    } = useChart(props.product);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Tooltip = _sfc_main$1;
      const _component_Loading = _sfc_main$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_highchart = resolveComponent("highchart");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "chart-price-changes" }, _attrs))}>`);
      if (unref(theme) === "desktop") {
        _push(ssrRenderComponent(_component_Tooltip, { position: "left" }, createSlots({
          tag: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<button${_scopeId}>`);
              if (unref(loading)) {
                _push2(ssrRenderComponent(_component_Loading, { type: "small" }, null, _parent2, _scopeId));
              } else {
                _push2(ssrRenderComponent(_component_fa_icon, {
                  icon: ["fas", "chart-line"],
                  class: "text-xl cursor-pointer"
                }, null, _parent2, _scopeId));
              }
              _push2(`</button>`);
            } else {
              return [
                createVNode("button", {
                  onClick: ($event) => unref(getChartData)()
                }, [
                  unref(loading) ? (openBlock(), createBlock(_component_Loading, {
                    key: 0,
                    type: "small"
                  })) : (openBlock(), createBlock(_component_fa_icon, {
                    key: 1,
                    icon: ["fas", "chart-line"],
                    class: "text-xl cursor-pointer"
                  }))
                ], 8, ["onClick"])
              ];
            }
          }),
          _: 2
        }, [
          !_ctx.hideTooltip ? {
            name: "content",
            fn: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div${_scopeId}>نمودار قیمت</div>`);
              } else {
                return [
                  createVNode("div", null, "نمودار قیمت")
                ];
              }
            }),
            key: "0"
          } : void 0
        ]), _parent));
      } else {
        _push(`<div class="flex items-center">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "chart-line"],
          class: "text-xl cursor-pointer"
        }, null, _parent));
        _push(`<span class="pr-3">نمودار قیمت</span></div>`);
      }
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) === "desktop" ? _sfc_main$3 : _sfc_main$4), {
        title: "نمودار قیمت فروش",
        "sub-title": _ctx.product.title,
        ref_key: "chartBox",
        ref: chartBox
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<ul class="flex flex-wrap py-2 px-4"${_scopeId}><!--[-->`);
            ssrRenderList(Object.keys(unref(data)), (key) => {
              _push2(`<!--[-->`);
              if (unref(data)[key] && unref(data)[key]["variation"]) {
                _push2(`<li class="mx-1"${_scopeId}><button class="${ssrRenderClass([{ "!border-black": unref(selectedVariation) === parseInt(key) }, "border-2 border-gray-200 px-4 py-2 rounded-md"])}"${_scopeId}>${ssrInterpolate(unref(data)[key]["variation"].name)}</button></li>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<!--]-->`);
            });
            _push2(`<!--]--></ul>`);
            _push2(ssrRenderComponent(_component_highchart, { options: unref(chartOptions) }, null, _parent2, _scopeId));
            _push2(`<div class="p-2 flex"${_scopeId}><div class="flex items-center"${_scopeId}><div class="w-8 h-1 bg-[#4BBFD3] relative flex justify-center"${_scopeId}><div class="w-3 h-3 rounded-full bg-[#4BBFD3] absolute top-[-4px]"${_scopeId}></div></div><span class="text-sm text-gray-400 mr-1"${_scopeId}>موجود</span></div><div class="flex items-center mr-4"${_scopeId}><div class="w-8 h-1 bg-[#bbbbbb] relative flex justify-center"${_scopeId}><div class="w-3 h-3 rounded-full bg-[#bbbbbb] absolute top-[-4px]"${_scopeId}></div></div><span class="text-sm text-gray-400 mr-1"${_scopeId}>نا موجود</span></div></div>`);
          } else {
            return [
              createVNode("ul", { class: "flex flex-wrap py-2 px-4" }, [
                (openBlock(true), createBlock(Fragment, null, renderList(Object.keys(unref(data)), (key) => {
                  return openBlock(), createBlock(Fragment, null, [
                    unref(data)[key] && unref(data)[key]["variation"] ? (openBlock(), createBlock("li", {
                      key: 0,
                      class: "mx-1"
                    }, [
                      createVNode("button", {
                        onClick: ($event) => unref(handleVariationClick)(parseInt(key)),
                        class: [{ "!border-black": unref(selectedVariation) === parseInt(key) }, "border-2 border-gray-200 px-4 py-2 rounded-md"]
                      }, toDisplayString(unref(data)[key]["variation"].name), 11, ["onClick"])
                    ])) : createCommentVNode("", true)
                  ], 64);
                }), 256))
              ]),
              createVNode(_component_highchart, { options: unref(chartOptions) }, null, 8, ["options"]),
              createVNode("div", { class: "p-2 flex" }, [
                createVNode("div", { class: "flex items-center" }, [
                  createVNode("div", { class: "w-8 h-1 bg-[#4BBFD3] relative flex justify-center" }, [
                    createVNode("div", { class: "w-3 h-3 rounded-full bg-[#4BBFD3] absolute top-[-4px]" })
                  ]),
                  createVNode("span", { class: "text-sm text-gray-400 mr-1" }, "موجود")
                ]),
                createVNode("div", { class: "flex items-center mr-4" }, [
                  createVNode("div", { class: "w-8 h-1 bg-[#bbbbbb] relative flex justify-center" }, [
                    createVNode("div", { class: "w-3 h-3 rounded-full bg-[#bbbbbb] absolute top-[-4px]" })
                  ]),
                  createVNode("span", { class: "text-sm text-gray-400 mr-1" }, "نا موجود")
                ])
              ])
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/price-changes/ShortCut.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=ShortCut-zD63vf6i.js.map
