import { defineComponent, resolveComponent, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent } from "vue/server-renderer";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "ShowProductAdsLabel",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.product.query && _ctx.product.query["ads_id"]) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex justify-end items-center w-full text-sm" }, _attrs))}><span class="text-gray-500">سفارشی</span>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "fa-bullhorn"],
          class: "pr-1 text-red-500"
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ads/ShowProductAdsLabel.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=ShowProductAdsLabel-B6DZSktT.js.map
