import { defineComponent, ref, resolveComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import { u as useState, b as useRuntimeConfig } from "../server.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Slider",
  __ssrInlineRender: true,
  props: {
    setting: {}
  },
  setup(__props) {
    const theme = useState("theme");
    const { serverUrl } = useRuntimeConfig().public;
    const brands = ref([]);
    const injectStyles = [
      `
    .swiper-button-next,
    .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:35px;
      height:35px;
      border:1px solid #dedede;
    }
   .swiper-button-next svg,
   .swiper-button-prev svg {
         width:25px;
         height:25px;
         color:black;
   }
  `
    ];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      if (_ctx.setting) {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: ["py-5", [_ctx.setting.className]]
        }, _attrs))}><p class="text-center pb-5">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "star"],
          class: "text-yellow-400"
        }, null, _parent));
        _push(`<span class="px-2 font-bold">${ssrInterpolate(_ctx.setting.title)}</span></p><swiper-container${ssrRenderAttr("navigation", unref(theme) == "desktop")} slides-per-view="auto"${ssrRenderAttr("injectStyles", injectStyles)}${ssrRenderAttr("space-between", unref(theme) != "desktop" ? 10 : 0)}><!--[-->`);
        ssrRenderList(unref(brands), (brand, key) => {
          _push(`<!--[-->`);
          if (unref(theme) == "desktop") {
            _push(`<!--[-->`);
            if (brand.icon) {
              _push(`<swiper-slide class="${ssrRenderClass([{ "border-l": key != unref(brands).length - 1 }, "w-auto px-10"])}"><img${ssrRenderAttr("src", unref(serverUrl) + "/upload/" + brand.icon)}${ssrRenderAttr("alt", brand.name)} class="w-24 h-20 object-contain my-4"></swiper-slide>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          } else {
            _push(`<!--[-->`);
            if (brand.icon) {
              _push(`<swiper-slide class="w-auto px-5 py-2 h-[110px] bg-gray-100 flex flex-col items-center justify-between"><img${ssrRenderAttr("src", unref(serverUrl) + "/upload/" + brand.icon)}${ssrRenderAttr("alt", brand.name)} class="w-10 h-10 object-contain my-4 darken-blend-mode"><span class="text-xs text-center mb-2">${ssrInterpolate(brand.name)}</span></swiper-slide>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></swiper-container></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/brands/Slider.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=Slider-BIO3-19R.js.map
