import { _ as _sfc_main$1 } from "./ProductsSlider-B4X-edAw.js";
import { b as useRuntimeConfig, c as useNuxtApp, k as __nuxt_component_3 } from "../server.mjs";
import { defineComponent, ref, computed, resolveComponent, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderAttr, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import { u as useMonthsList } from "./MonthsList-B1ySoCWX.js";
import { u as useOrderStore } from "./index-Co4X6G3O.js";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "Summary",
  __ssrInlineRender: true,
  props: {
    submission: {}
  },
  setup(__props) {
    const store = useOrderStore();
    const props = __props;
    const showDetail = ref(false);
    const months = useMonthsList();
    const { serverUrl } = useRuntimeConfig().public;
    const global = useNuxtApp().vueApp.config.globalProperties;
    const getDate = () => {
      let result = "";
      const prefix = `${props.submission.info["name"]}:${props.submission.info["sender"]}`;
      const date = store.formData[`${prefix}_date`];
      const ex = date.toString().split("/");
      if (ex.length == 3 && months[parseInt(ex[1])]) {
        result = `${ex[2]} ${months[parseInt(ex[1])]} ${ex[0]}`;
      }
      return global.$replaceEnNumber(result);
    };
    const getTime = () => {
      const prefix = `${props.submission.info["name"]}:${props.submission.info["sender"]}`;
      return global.$replaceEnNumber(store.formData[`${prefix}_time`]);
    };
    const submissionTotalPrice = computed(() => {
      let price = 0;
      props.submission.products.forEach((product) => {
        price += parseInt((product.variation.price2 * product.count).toString());
      });
      if (props.submission.info.price > 0) {
        price += parseInt(props.submission.info.price.toString());
      }
      return price;
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_OrdersCheckoutProductsSlider = _sfc_main$1;
      const _component_IconsToman = __nuxt_component_3;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="text-gray-800 flex justify-between items-center w-full"><div class="flex items-center font-bold"><img${ssrRenderAttr("src", unref(serverUrl) + "/" + props.submission.info.icon)} class="w-8" alt=""><span class="px-1.5">${ssrInterpolate(getDate())}</span><span> - بازه </span><span class="px-1">${ssrInterpolate(getTime())}</span><div class="bg-gray-100 rounded-xl px-3 py-0.5 text-sm mr-2">${ssrInterpolate(_ctx.$replaceEnNumber(props.submission.products.length))} کالا </div></div><button class="text-sm flex items-center">`);
      if (!unref(showDetail)) {
        _push(`<span>جزئیات مرسوله</span>`);
      } else {
        _push(`<span>بستن</span>`);
      }
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", unref(showDetail) ? "angle-up" : "angle-down"],
        class: "mr-1.5"
      }, null, _parent));
      _push(`</button></div><div class="mt-3 text-sm text-gray-700">${ssrInterpolate(props.submission.info.title)}</div>`);
      if (unref(showDetail)) {
        _push(ssrRenderComponent(_component_OrdersCheckoutProductsSlider, {
          products: props.submission.products,
          "disable-action": ""
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(showDetail)) {
        _push(`<div class="flex items-center text-gray-800"><span>مبلغ مرسوله : </span><span class="mr-1">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(submissionTotalPrice))))}</span>`);
        _push(ssrRenderComponent(_component_IconsToman, { class: "mr-1" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/custom-delivery/Summary.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=Summary-DyiUFoXX.js.map
