import { ref, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderSlot, ssrRenderStyle } from "vue/server-renderer";
const _sfc_main = {
  __name: "Tooltip",
  __ssrInlineRender: true,
  props: {
    position: { type: String, default: "bottom" },
    disable: {
      type: Boolean
    }
  },
  setup(__props) {
    ref(null);
    ref(null);
    const show = ref(false);
    const tooltipStyle = ref({});
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative" }, _attrs))}><div>`);
      ssrRenderSlot(_ctx.$slots, "tag", {}, null, _push, _parent);
      _push(`</div>`);
      if (unref(show) && !__props.disable) {
        _push(`<div class="c-tooltip" style="${ssrRenderStyle(unref(tooltipStyle))}">`);
        ssrRenderSlot(_ctx.$slots, "content", {}, null, _push, _parent);
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Tooltip.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=Tooltip-B8G2HT4W.js.map
