import { _ as _sfc_main$1 } from "./VerticalView-mV-jyVNN.js";
import { _ as _sfc_main$2 } from "./RemoveRequestBtn-CGRu9Gzt.js";
import { _ as _sfc_main$3 } from "./SelectVariationBtn-nIKCeOxT.js";
import { _ as _sfc_main$5 } from "./Pagination-BRp8RD1E.js";
import { defineComponent, ref, unref, withCtx, createVNode, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderClass, ssrRenderList, ssrRenderComponent } from "vue/server-renderer";
import { _ as _sfc_main$4 } from "./EmptyList-DlpsHik2.js";
import { u as useState, c as useNuxtApp, b as useRuntimeConfig } from "../server.mjs";
import "./NuxtImg-DBEieluz.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "./v3-CqizLg04.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/@unhead/vue/dist/index.mjs";
import "./Skeleton-B5XQTW8R.js";
import "./Score-BYZAscMc.js";
import "./user-utils-B9JSuaai.js";
import "./Items-CRlozw8Q.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "pinia";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "UserList",
  __ssrInlineRender: true,
  setup(__props) {
    const toast = useState("toast");
    const theme = ref("theme");
    const list = ref({ data: [] });
    const loading = ref(false);
    const getList = (page = 1) => {
      loading.value = true;
      if (page > 1) {
        const pageContent = (void 0).querySelector(".page-content");
        pageContent.scrollTo(0, 0);
      }
      useNuxtApp().$axios.get(
        useRuntimeConfig().public.api + "/user/favorites?page=" + page
      ).then((response) => {
        loading.value = false;
        list.value = response.data;
      }).catch(() => {
        loading.value = false;
      });
    };
    const removeProductFromList = (productId) => {
      useNuxtApp().$axios.delete(
        useRuntimeConfig().public.api + "/user/product/" + productId + "/favorite/remove"
      ).then(() => {
        getList();
      }).catch(() => {
        toast.value = {
          type: "error",
          message: "خطا در اجرای درخواست مجددا تلاش نمایید"
        };
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeProductSliderVerticalView = _sfc_main$1;
      const _component_UsersRemoveRequestBtn = _sfc_main$2;
      const _component_PriceVariationSelectVariationBtn = _sfc_main$3;
      const _component_Pagination = _sfc_main$5;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="${ssrRenderClass([{ "vertical-list": unref(theme) != "desktop" }, "grid lg:grid-cols-2"])}">`);
      if (!unref(loading)) {
        _push(`<!--[-->`);
        ssrRenderList(unref(list).data, (product) => {
          _push(ssrRenderComponent(_component_ThemeProductSliderVerticalView, {
            key: product.id,
            product
          }, {
            after: withCtx(({ product: product2 }, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="flex items-center pt-3 text-sm"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_UsersRemoveRequestBtn, {
                  then: removeProductFromList,
                  id: product2.id,
                  title: "حذف از لیست علاقه مندی ها",
                  description: "آیا از حذف " + product2.title + " از لیست علاقه مندی ها اطمینان دارید؟",
                  deleteBtnText: "حذف کالا"
                }, null, _parent2, _scopeId));
                if (product2) {
                  _push2(ssrRenderComponent(_component_PriceVariationSelectVariationBtn, {
                    product: product2,
                    "btn-class": product2.status == 1 ? "c-btn2 flex-grow mr-3" : "c-btn2 text-gray-500 border-gray-400 flex-grow mr-3"
                  }, null, _parent2, _scopeId));
                } else {
                  _push2(`<!---->`);
                }
                _push2(`</div>`);
              } else {
                return [
                  createVNode("div", { class: "flex items-center pt-3 text-sm" }, [
                    createVNode(_component_UsersRemoveRequestBtn, {
                      then: removeProductFromList,
                      id: product2.id,
                      title: "حذف از لیست علاقه مندی ها",
                      description: "آیا از حذف " + product2.title + " از لیست علاقه مندی ها اطمینان دارید؟",
                      deleteBtnText: "حذف کالا"
                    }, null, 8, ["id", "description"]),
                    product2 ? (openBlock(), createBlock(_component_PriceVariationSelectVariationBtn, {
                      key: 0,
                      product: product2,
                      "btn-class": product2.status == 1 ? "c-btn2 flex-grow mr-3" : "c-btn2 text-gray-500 border-gray-400 flex-grow mr-3"
                    }, null, 8, ["product", "btn-class"])) : createCommentVNode("", true)
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!--[-->`);
        ssrRenderList(10, (i) => {
          _push(ssrRenderComponent(_component_ThemeProductSliderVerticalView, {
            key: i,
            loading: "",
            product: null
          }, null, _parent));
        });
        _push(`<!--]-->`);
      }
      _push(`</div>`);
      if (!unref(loading) && unref(list).data.length == 0) {
        _push(ssrRenderComponent(_sfc_main$4, { description: "محصولی به لیست علاقه مندی شما اضافه نشده" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_Pagination, {
        data: unref(list),
        "fetch-data": getList,
        offset: 4,
        class: "my-5"
      }, null, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/favourite/UserList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=UserList-u_6VK889.js.map
