import { c as useNuxtApp, b as useRuntimeConfig, g as __nuxt_component_0, r as _sfc_main$4, v as _sfc_main$5, w as _sfc_main$6 } from "../server.mjs";
import { _ as _sfc_main$1 } from "./NuxtImg-DBEieluz.js";
import { _ as __nuxt_component_3 } from "./Skeleton-B5XQTW8R.js";
import { _ as _sfc_main$2, a as _sfc_main$3 } from "./Score-BYZAscMc.js";
import { defineComponent, mergeProps, withCtx, unref, createVNode, resolveDynamicComponent, renderSlot, createBlock, createCommentVNode, openBlock, toDisplayString, Fragment, renderList, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderSlot, ssrInterpolate, ssrRenderList, ssrRenderVNode } from "vue/server-renderer";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "VerticalView",
  __ssrInlineRender: true,
  props: {
    product: {},
    loading: { type: Boolean },
    showColors: { type: Boolean },
    showScore: { type: Boolean },
    index: {}
  },
  setup(__props) {
    const global = useNuxtApp().vueApp.config.globalProperties;
    const footerComponents = global["$product-view:footer"];
    const { serverUrl } = useRuntimeConfig().public;
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_NuxtImg = _sfc_main$1;
      const _component_Skeleton = __nuxt_component_3;
      const _component_ThemeSearchProductColors = _sfc_main$2;
      const _component_CommentScore = _sfc_main$3;
      const _component_PriceVariationDiscountPercentage = _sfc_main$4;
      const _component_PriceVariationProductFinalPrice = _sfc_main$5;
      const _component_PriceVariationProductOldPrice = _sfc_main$6;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product vertical-view" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_nuxt_link, {
        to: _ctx.$getProductPath(_ctx.product)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            ssrRenderSlot(_ctx.$slots, "before", { index: _ctx.index }, null, _push2, _parent2, _scopeId);
            _push2(`<section${_scopeId}><div class="product-image"${_scopeId}>`);
            if (_ctx.product) {
              _push2(ssrRenderComponent(_component_NuxtImg, {
                src: unref(serverUrl) + "/thumbnails/" + _ctx.product.image,
                format: "webp",
                height: 135,
                width: 135,
                loading: "lazy",
                alt: _ctx.product.title,
                class: "image"
              }, null, _parent2, _scopeId));
            } else {
              _push2(ssrRenderComponent(_component_Skeleton, { class: "image my-2" }, null, _parent2, _scopeId));
            }
            if (_ctx.showColors) {
              _push2(ssrRenderComponent(_component_ThemeSearchProductColors, {
                class: "product-colors",
                product: _ctx.product
              }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div><div class="info"${_scopeId}><div class="w-full"${_scopeId}>`);
            if (_ctx.product) {
              _push2(`<span class="title-twl product-title"${_scopeId}>${ssrInterpolate(_ctx.product.title)}</span>`);
            } else {
              _push2(ssrRenderComponent(_component_Skeleton, { class: "h-3 w-full" }, null, _parent2, _scopeId));
            }
            _push2(`</div><div class="min-h-[70px] flex flex-col justify-end"${_scopeId}>`);
            if (_ctx.showScore) {
              _push2(`<div class="w-full flex justify-end pt-3"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_CommentScore, { product: _ctx.product }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.product) {
              _push2(`<div class="flex justify-between pt-3 items-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_PriceVariationDiscountPercentage, {
                variation: _ctx.product.variation
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_PriceVariationProductFinalPrice, {
                variation: _ctx.product.variation
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.product) {
              _push2(`<div class="flex justify-end"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_PriceVariationProductOldPrice, {
                variation: _ctx.product.variation,
                class: "py-1"
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(ssrRenderComponent(_component_Skeleton, { class: "h-3 my-2 w-[80%]" }, null, _parent2, _scopeId));
            }
            if (unref(footerComponents) && _ctx.product) {
              _push2(`<!--[-->`);
              ssrRenderList(unref(footerComponents), (component, key) => {
                ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(component), {
                  key,
                  product: _ctx.product
                }, null), _parent2, _scopeId);
              });
              _push2(`<!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div></div></section>`);
          } else {
            return [
              renderSlot(_ctx.$slots, "before", { index: _ctx.index }),
              createVNode("section", null, [
                createVNode("div", { class: "product-image" }, [
                  _ctx.product ? (openBlock(), createBlock(_component_NuxtImg, {
                    key: 0,
                    src: unref(serverUrl) + "/thumbnails/" + _ctx.product.image,
                    format: "webp",
                    height: 135,
                    width: 135,
                    loading: "lazy",
                    alt: _ctx.product.title,
                    class: "image"
                  }, null, 8, ["src", "alt"])) : (openBlock(), createBlock(_component_Skeleton, {
                    key: 1,
                    class: "image my-2"
                  })),
                  _ctx.showColors ? (openBlock(), createBlock(_component_ThemeSearchProductColors, {
                    key: 2,
                    class: "product-colors",
                    product: _ctx.product
                  }, null, 8, ["product"])) : createCommentVNode("", true)
                ]),
                createVNode("div", { class: "info" }, [
                  createVNode("div", { class: "w-full" }, [
                    _ctx.product ? (openBlock(), createBlock("span", {
                      key: 0,
                      class: "title-twl product-title"
                    }, toDisplayString(_ctx.product.title), 1)) : (openBlock(), createBlock(_component_Skeleton, {
                      key: 1,
                      class: "h-3 w-full"
                    }))
                  ]),
                  createVNode("div", { class: "min-h-[70px] flex flex-col justify-end" }, [
                    _ctx.showScore ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "w-full flex justify-end pt-3"
                    }, [
                      createVNode(_component_CommentScore, { product: _ctx.product }, null, 8, ["product"])
                    ])) : createCommentVNode("", true),
                    _ctx.product ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "flex justify-between pt-3 items-center"
                    }, [
                      createVNode(_component_PriceVariationDiscountPercentage, {
                        variation: _ctx.product.variation
                      }, null, 8, ["variation"]),
                      createVNode(_component_PriceVariationProductFinalPrice, {
                        variation: _ctx.product.variation
                      }, null, 8, ["variation"])
                    ])) : createCommentVNode("", true),
                    _ctx.product ? (openBlock(), createBlock("div", {
                      key: 2,
                      class: "flex justify-end"
                    }, [
                      createVNode(_component_PriceVariationProductOldPrice, {
                        variation: _ctx.product.variation,
                        class: "py-1"
                      }, null, 8, ["variation"])
                    ])) : (openBlock(), createBlock(_component_Skeleton, {
                      key: 3,
                      class: "h-3 my-2 w-[80%]"
                    })),
                    unref(footerComponents) && _ctx.product ? (openBlock(true), createBlock(Fragment, { key: 4 }, renderList(unref(footerComponents), (component, key) => {
                      return openBlock(), createBlock(resolveDynamicComponent(component), {
                        key,
                        product: _ctx.product
                      }, null, 8, ["product"]);
                    }), 128)) : createCommentVNode("", true)
                  ])
                ])
              ])
            ];
          }
        }),
        _: 3
      }, _parent));
      ssrRenderSlot(_ctx.$slots, "after", {
        index: _ctx.index,
        product: _ctx.product
      }, null, _push, _parent);
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/product-slider/VerticalView.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=VerticalView-mV-jyVNN.js.map
