import { ssrRenderAttrs, ssrInterpolate, ssrRenderStyle, ssrRenderList, ssrRenderAttr, ssrRenderComponent } from "vue/server-renderer";
import { useSSRContext, ref, unref, mergeProps, defineComponent } from "vue";
import { u as useState, b as useRuntimeConfig } from "../server.mjs";
import VueQrcode from "vue-qrcode";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main$4 = {
  __name: "Company",
  __ssrInlineRender: true,
  props: ["company"],
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      if (__props.company !== null) {
        _push(`<div${ssrRenderAttrs(_attrs)}><div class="info-row">`);
        if (__props.company.name !== "") {
          _push(`<div><span>فروشنده : </span><span>${ssrInterpolate(__props.company.name)}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.company.national_id !== "") {
          _push(`<div><span>شناسه ملی : </span><span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.company.national_id))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.company.registration_number !== "") {
          _push(`<div><span>شماره ثبت : </span><span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.company.registration_number))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.company.economical_number !== "") {
          _push(`<div><span>شماره اقتصادی : </span><span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.company.economical_number))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="info-row"><div style="${ssrRenderStyle({ "width": "50%" })}"><span>نشانی شرکت : </span><span>${ssrInterpolate(__props.company.address)}</span></div><div><span>کد پستی : </span><span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.company.postal_code))}</span></div><div><span>تلفن و فکس : </span><span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.company.phone))}</span></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/factor/Company.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = {
  __name: "User",
  __ssrInlineRender: true,
  props: ["order"],
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      if (__props.order.user !== null && __props.order.address !== null) {
        _push(`<div${ssrRenderAttrs(_attrs)}><div class="info-row"><div><span>خریدار : </span><span>${ssrInterpolate(__props.order.address.recipient_name)} ${ssrInterpolate(__props.order.address.recipient_last_name)}</span></div><div><span>شماره اقتصادی / شماره ملی : </span>`);
        if (__props.order.user.nationalCode !== void 0) {
          _push(`<span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.order.user.nationalCode))}</span>`);
        } else {
          _push(`<span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.order.user.economical_number))}</span>`);
        }
        _push(`</div></div><div class="info-row"><div style="${ssrRenderStyle({ "width": "75%" })}"><span>نشانی : </span><span>${ssrInterpolate(__props.order.address.address)}</span></div><div><span>کد پستی : </span><span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.order.address.postalCode))}</span></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/factor/User.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = {
  __name: "Products",
  __ssrInlineRender: true,
  props: ["submission"],
  setup(__props) {
    const shopSetting = useState("shopSetting");
    const sumData = ref({
      price1: 0,
      price2: 0,
      discount: 0,
      finalPrice: 0,
      count: 0,
      shippingCost: 0
    });
    function getDiscount(item) {
      return (item.price1 - item.price2) * item.count * 10;
    }
    function getFinalPrice(item) {
      return item.price2 * item.count * 10;
    }
    return (_ctx, _push, _parent, _attrs) => {
      if (unref(shopSetting) != null) {
        _push(`<table${ssrRenderAttrs(mergeProps({ class: "products" }, _attrs))}><thead><tr><th>ردیف</th><th>شناسه کالا</th><th>شرح کالا</th>`);
        if (unref(shopSetting)["multi-seller"] === "true") {
          _push(`<th>آمر</th>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<th>تعداد</th><th>مبلغ واحد (ریال)</th><th>مبلغ کل (ریال)</th><th>تخفیف (ریال)</th><th>مبلغ کل پس از تخفیف (ریال)</th><th class="w-[150px]">جمع مالیات و عوارض ارزش افزوده (ریال)</th><th>جمع کل پس از تخفیف و مالیات و عوارض (ریال)</th></tr></thead><tbody><!--[-->`);
        ssrRenderList(__props.submission.items, (item, key) => {
          _push(`<tr><td>${ssrInterpolate(_ctx.$replaceEnNumber(key + 1))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(item.product_id))}</td><td class="w-[300px]"><div class="text-start">`);
          if (item.product !== null) {
            _push(`<span>${ssrInterpolate(item.product.title)}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--[-->`);
          ssrRenderList(item.variation, (param) => {
            _push(`<!--[-->`);
            if (param != null && param.name !== void 0) {
              _push(`<span> | ${ssrInterpolate(param.name)}</span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          });
          _push(`<!--]--></div></td>`);
          if (unref(shopSetting)["multi-seller"] === "true") {
            _push(`<td>${ssrInterpolate(item.seller.brand_name)}</td>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<td>${ssrInterpolate(_ctx.$replaceEnNumber(item.count))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(item.price1 * 10)))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(item.price1 * item.count * 10)))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(getDiscount(item))))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(getFinalPrice(item))))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber("0"))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(getFinalPrice(item))))}</td></tr>`);
        });
        _push(`<!--]-->`);
        if (unref(sumData) !== null) {
          _push(`<tr><td${ssrRenderAttr("colspan", unref(shopSetting)["multi-seller"] === "true" ? 4 : 3)}> جمع </td><td>${ssrInterpolate(_ctx.$replaceEnNumber(unref(sumData).count))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(sumData).price1)))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(sumData).price2)))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(sumData).discount)))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(sumData).finalPrice)))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber("0"))}</td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(sumData).finalPrice)))}</td></tr>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(sumData) !== null) {
          _push(`<tr><td${ssrRenderAttr("colspan", unref(shopSetting)["multi-seller"] === "true" ? 10 : 9)}> هزینه ارسال : </td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(sumData).shippingCost).toString()))}</td></tr>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(sumData) !== null) {
          _push(`<tr><td${ssrRenderAttr("colspan", unref(shopSetting)["multi-seller"] === "true" ? 10 : 9)} style="${ssrRenderStyle({ "background-color": "#e0e0e0" })}"> جمع کل پس از کسر تخفیف با احتساب مالیات و عوارض (ریال) : </td><td>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(sumData).shippingCost + unref(sumData).finalPrice)))}</td></tr>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</tbody></table>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/factor/Products.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "View",
  __ssrInlineRender: true,
  props: {
    order: {},
    submission: {},
    company: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_OrdersFactorCompany = _sfc_main$4;
      const _component_OrdersFactorUser = _sfc_main$3;
      const _component_OrdersFactorProducts = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(_attrs)}><h1 class="text-center py-5 text-xl"> صورت حساب الکترونیکی فروش </h1><table class="w-full my-4"><tbody><tr><td class="w-[1.8cm] h-[2.5cm]"><div class="header-item border"><span class="portait">فروشنده</span></div></td><td class="px-3 h-[2.5cm]"><div class="border w-full h-full">`);
      _push(ssrRenderComponent(_component_OrdersFactorCompany, { company: _ctx.company }, null, _parent));
      _push(`</div></td><td class="w-[5cm] h-[2.5cm]"><div class="border h-full p-3 flex flex-col justify-between"><p class="flex justify-between"><span>شماره فاکتور: </span><span class="text-black">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.order.order_id))}</span></p><p class="flex justify-between"><span>تاریخ ثبت : </span><span class="text-black">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$getDate(_ctx.order.created_at)))}</span></p></div></td></tr><tr><td class="w-[1.8cm] h-[2.5cm]"><div class="header-item border"><span class="portait">خریدار</span></div></td><td colspan="2" class="h-[2.5cm]"><div class="h-full border my-3" style="${ssrRenderStyle({ "margin-right": "10px" })}">`);
      _push(ssrRenderComponent(_component_OrdersFactorUser, { order: _ctx.order }, null, _parent));
      _push(`</div></td></tr></tbody></table>`);
      _push(ssrRenderComponent(_component_OrdersFactorProducts, { submission: _ctx.submission }, null, _parent));
      _push(`<div class="w-full border break-inside" style="${ssrRenderStyle({ "border-top": "0 !important" })}"><div class="footer py-10"><div class="w-1/2 pr-10"><p> مهر و امضای گیرنده </p><div class="w-full flex justify-end"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/images/company-seal.jpg")} class="max-w-[150px]"></div></div><div class="w-1/2 pr-5"><p> مهر و امضای تحویل دهنده </p><div class="w-full flex justify-end">`);
      _push(ssrRenderComponent(unref(VueQrcode), {
        value: _ctx.order.order_id.toString()
      }, null, _parent));
      _push(`</div></div></div></div></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/factor/View.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "[id]",
  __ssrInlineRender: true,
  setup(__props) {
    const order = ref(null);
    ref(false);
    const company = ref(null);
    const shopSetting = useState("shopSetting");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_OrdersFactorView = _sfc_main$1;
      if (unref(shopSetting)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "factor-page p-3" }, _attrs))}><div class="flex justify-between items-center" id="print-box"><div><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/" + unref(shopSetting).icon)} class="logo"></div><div><button class="btn btn-danger"> پرینت </button></div></div>`);
        if (unref(order) && unref(company)) {
          _push(`<div><!--[-->`);
          ssrRenderList(unref(order).submissions, (submission, key) => {
            _push(ssrRenderComponent(_component_OrdersFactorView, {
              class: { "page-break": key > 0 },
              key,
              submission,
              order: unref(order),
              company: unref(company)
            }, null, _parent));
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/orders/invoice/[id].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=_id_-DOsnPJF7.js.map
