import { _ as _sfc_main$7 } from "./Layout-tZUvOK2Y.js";
import { _ as _sfc_main$8 } from "./Box-P2bb9SjA.js";
import _sfc_main$a from "./FactorLink-DOFSg108.js";
import { c as useNuxtApp, k as __nuxt_component_3, g as __nuxt_component_0, b as useRuntimeConfig, o as _sfc_main$6, u as useState, h as _sfc_main$9 } from "../server.mjs";
import { defineComponent, mergeProps, useSSRContext, computed, unref, withCtx, createVNode, resolveDynamicComponent, ref, createSlots, createBlock, createCommentVNode, openBlock, Fragment, renderList } from "vue";
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderComponent, ssrRenderList, ssrRenderAttr, ssrRenderVNode } from "vue/server-renderer";
import { u as useMonthsList } from "./MonthsList-B1ySoCWX.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "DetailItems",
  __ssrInlineRender: true,
  props: {
    title: {},
    value: {},
    disablePoint: { type: Boolean }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: ["max-md:py-2 flex items-center max-md:justify-between", { "md:px-3": !_ctx.disablePoint }]
      }, _attrs))}>`);
      if (!_ctx.disablePoint) {
        _push(`<div class="point hidden md:block"></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<span class="${ssrRenderClass([{ "md:px-2": !_ctx.disablePoint }, "text-gray-700"])}">${ssrInterpolate(_ctx.title)}</span><span class="${ssrRenderClass([{ "md:px-2": _ctx.disablePoint }, "text-black font-bold"])}">${ssrInterpolate(_ctx.value)}</span></div>`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/DetailItems.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "AddressInfo",
  __ssrInlineRender: true,
  props: {
    order: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_OrdersUserDetailItems = _sfc_main$5;
      if (_ctx.order.address) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-5 border-b" }, _attrs))}><div class="max-md:px-3 text-gray-400 flex flex-col md:flex-row">`);
        _push(ssrRenderComponent(_component_OrdersUserDetailItems, {
          title: "تحویل گیرنده",
          "disable-point": "",
          value: _ctx.order.address.recipient_name + " " + _ctx.order.address.recipient_last_name
        }, null, _parent));
        _push(ssrRenderComponent(_component_OrdersUserDetailItems, {
          title: "شماره موبایل",
          value: _ctx.$replaceEnNumber(_ctx.order.address.recipient_mobile_number)
        }, null, _parent));
        _push(`</div><div class="md:pt-3 max-md:px-4 flex max-md:flex-col"><span class="text-gray-500">آدرس</span><span class="font-bold text-black max-md:py-2 md:px-2">${ssrInterpolate(_ctx.order.address.address)}</span></div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/AddressInfo.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "PaymentHistory",
  __ssrInlineRender: true,
  props: {
    histories: {}
  },
  setup(__props) {
    const props = __props;
    const global = useNuxtApp().vueApp.config.globalProperties;
    const paymentMethods = global["$orders:payment-methods"];
    const getMethodTitle = (name) => {
      const method = paymentMethods.find((method2) => method2.value == name);
      return method ? method.title : "";
    };
    const filteredHistories = computed(() => {
      return props.histories.filter((history) => history.price > 0);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_IconsToman = __nuxt_component_3;
      if (unref(filteredHistories)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "space-y-3" }, _attrs))}><p class="font-bold text-lg">روش‌های پرداخت</p><!--[-->`);
        ssrRenderList(unref(filteredHistories), (history, key) => {
          _push(`<div class="border rounded-lg px-4 py-3 flex justify-between items-center bg-gray-50 dark:bg-gray-800"><span class="text-gray-600 dark:text-gray-300">${ssrInterpolate(getMethodTitle(history.method))}</span><span class="font-semibold text-gray-800 dark:text-white flex items-center">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(history.price)))} `);
          _push(ssrRenderComponent(_component_IconsToman, { class: "ml-1 text-base" }, null, _parent));
          _push(`</span></div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/PaymentHistory.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
function useOrder() {
  const global = useNuxtApp().vueApp.config.globalProperties;
  const orderStatutes = global["$order:statutes"];
  const months = useMonthsList();
  const daysOfWeek = [
    "یک‌شنبه",
    "دوشنبه",
    "سه‌شنبه",
    "چهارشنبه",
    "پنج‌شنبه",
    "جمعه",
    "شنبه"
  ];
  const getOrderDate = function(createdAt) {
    const date = global.$getDate(createdAt);
    let result = "";
    const ex = date.toString().split("/");
    if (ex.length == 3 && months[parseInt(ex[1])]) {
      result = `${ex[2]} ${months[parseInt(ex[1])]} ${ex[0]}`;
    }
    return result;
  };
  const getSubmissionDate = function(createdAt) {
    const mDate = new Date(createdAt * 1e3);
    const date = global.$getDate(createdAt);
    const dayOfWeekIndex = mDate.getDay();
    let result = "";
    const ex = date.toString().split("/");
    if (ex.length == 3 && months[parseInt(ex[1])]) {
      result = `${daysOfWeek[dayOfWeekIndex]} ${ex[2]} ${months[parseInt(ex[1])]}`;
    }
    return result;
  };
  const getTotalShippingCost = (order) => {
    let fixedCost = 0;
    let variableCost = 0;
    order.submissions.forEach((submission) => {
      if (submission.shipping_cost >= 0) {
        fixedCost += submission.shipping_cost;
      } else {
        variableCost = -1;
      }
    });
    if (fixedCost == 0 && variableCost == -1) {
      return "پس کرایه";
    } else if (fixedCost > 0) {
      return global.$numberFormat(fixedCost) + " تومان" + (variableCost == -1 ? " پس کرایه" : "");
    } else {
      return "رایگان";
    }
  };
  const getShippingCost = (submission) => {
    let fixedCost = 0;
    let variableCost = 0;
    if (submission.shipping_cost >= 0) {
      fixedCost = submission.shipping_cost;
    } else {
      variableCost = -1;
    }
    if (fixedCost == 0 && variableCost == -1) {
      return "پس کرایه";
    } else if (fixedCost > 0) {
      return global.$numberFormat(fixedCost) + " تومان" + (variableCost == -1 ? " پس کرایه" : "");
    } else {
      return "رایگان";
    }
  };
  const getShippingPrice = (submission) => {
    let price = 0;
    submission.items.forEach((item) => {
      price += item.price2;
    });
    return price;
  };
  return {
    getShippingPrice,
    getTotalShippingCost,
    getShippingCost,
    getOrderDate,
    getSubmissionDate,
    orderStatutes
  };
}
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "SubmissionProducts",
  __ssrInlineRender: true,
  props: {
    submission: {}
  },
  setup(__props) {
    const global = useNuxtApp().vueApp.config.globalProperties;
    const components = global["$submission-product:footer"];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_PriceVariationPriceBox = _sfc_main$6;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-4 md:px-5" }, _attrs))}><!--[-->`);
      ssrRenderList(_ctx.submission.items, (item, key) => {
        _push(`<div class="${ssrRenderClass([{ "border-b": key != _ctx.submission.items.length - 1 }, "py-5"])}"><div class="flex">`);
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: _ctx.$getProductPath(item.product)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + item.product.image)} class="w-[140px]" alt=""${_scopeId}>`);
            } else {
              return [
                createVNode("img", {
                  src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + item.product.image,
                  class: "w-[140px]",
                  alt: ""
                }, null, 8, ["src"])
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`<div class="px-3 md:px-5 text-sm"><h1 class="font-bold text-black">${ssrInterpolate(item.product.title)}</h1>`);
        if (item.param1) {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(item.param1_type)), {
            class: "py-2 text-gray-600",
            data: item.param1
          }, null), _parent);
        } else {
          _push(`<!---->`);
        }
        if (item.param2) {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(item.param2_type)), {
            class: "py-3 text-gray-600",
            data: item.param2
          }, null), _parent);
        } else {
          _push(`<!---->`);
        }
        _push(ssrRenderComponent(_component_PriceVariationPriceBox, {
          variation: item,
          class: "flex flex-col items-start pt-3"
        }, null, _parent));
        _push(`</div></div>`);
        if (unref(components) && _ctx.submission.status >= 5) {
          _push(`<!--[-->`);
          ssrRenderList(unref(components), (component, key2) => {
            ssrRenderVNode(_push, createVNode(resolveDynamicComponent(component), {
              key: key2,
              product: item.product
            }, null), _parent);
          });
          _push(`<!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      });
      _push(`<!--]--></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/SubmissionProducts.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Submission",
  __ssrInlineRender: true,
  props: {
    submission: {},
    number: {}
  },
  setup(__props) {
    const { serverUrl } = useRuntimeConfig().public;
    const {
      getShippingPrice,
      orderStatutes,
      getShippingCost,
      getSubmissionDate
    } = useOrder();
    const props = __props;
    const global = useNuxtApp().vueApp.config.globalProperties;
    const deliveryMethods = global["$delivery-methods"];
    const sendMethod = computed(() => {
      return deliveryMethods.find((method) => method.key == props.submission.send_type);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_OrdersUserDetailItems = _sfc_main$5;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="border rounded-md px-5 py-3"><div class="md:flex items-center"><div class="md:w-1/2"><div class="flex items-center"><span class="font-bold text-sm">مرسوله ${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.number))}</span>`);
      if (unref(sendMethod)) {
        _push(`<div class="flex items-center pr-5 text-sm"><img class="w-7"${ssrRenderAttr("src", unref(serverUrl) + "/" + unref(sendMethod).icon)} alt=""><span class="pr-3 text-black">${ssrInterpolate(unref(sendMethod).title)}</span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="pt-3">`);
      _push(ssrRenderComponent(_component_OrdersUserDetailItems, {
        title: "زمان تحویل",
        "disable-point": "",
        value: _ctx.$replaceEnNumber(unref(getSubmissionDate)(_ctx.submission.delivery_date) + " بازه " + _ctx.submission.delivery_time)
      }, null, _parent));
      _push(`</div></div>`);
      if (unref(orderStatutes)[_ctx.submission.status]) {
        _push(`<div class="max-md:pt-3 md:w-1/2"><span class="text-sm font-bold">${ssrInterpolate(unref(orderStatutes)[_ctx.submission.status].title)}</span><div class="${ssrRenderClass([{
          "bg-green-500": _ctx.submission.status >= 5,
          "bg-yellow-400": _ctx.submission.status < 5
        }, "w-full rounded-md mt-3 h-3"])}"></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="md:flex pt-6">`);
      _push(ssrRenderComponent(_component_OrdersUserDetailItems, {
        title: "هزینه ارسال",
        "disable-point": "",
        value: _ctx.$replaceEnNumber(unref(getShippingCost)(_ctx.submission))
      }, null, _parent));
      _push(ssrRenderComponent(_component_OrdersUserDetailItems, {
        title: "مبلغ مرسوله:",
        value: _ctx.$replaceEnNumber(_ctx.$numberFormat(unref(getShippingPrice)(_ctx.submission))) + " تومان"
      }, null, _parent));
      _push(ssrRenderComponent(_component_OrdersUserDetailItems, {
        title: "کد پیگیری مرسوله:",
        value: _ctx.$replaceEnNumber(_ctx.submission.id)
      }, null, _parent));
      _push(`</div></div>`);
      _push(ssrRenderComponent(_sfc_main$2, { submission: _ctx.submission }, null, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/orders/user/Submission.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "[id]",
  __ssrInlineRender: true,
  setup(__props) {
    const {
      getOrderDate,
      getTotalShippingCost
    } = useOrder();
    const theme = useState("theme");
    const order = ref(null);
    const loading = ref(true);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_UsersLayout = _sfc_main$7;
      const _component_UsersPanelBox = _sfc_main$8;
      const _component_OrdersUserFactorLink = _sfc_main$a;
      const _component_Loading = _sfc_main$9;
      const _component_OrdersUserDetailItems = _sfc_main$5;
      const _component_OrdersUserAddressInfo = _sfc_main$4;
      const _component_OrdersUserPaymentHistory = _sfc_main$3;
      const _component_OrdersUserSubmission = _sfc_main$1;
      _push(ssrRenderComponent(_component_UsersLayout, _attrs, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_UsersPanelBox, {
              title: unref(theme) == "desktop" ? "جزئیات سفارش" : void 0,
              class: "order-detail",
              backUrl: "/profile/orders"
            }, createSlots({
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (unref(loading)) {
                    _push3(`<div class="w-full flex justify-center py-10"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_Loading, null, null, _parent3, _scopeId2));
                    _push3(`</div>`);
                  } else if (unref(order)) {
                    _push3(`<div${_scopeId2}><div class="max-md:px-3 py-2 text-gray-400 flex flex-col md:flex-row border-b"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_OrdersUserDetailItems, {
                      title: "کد سفارش",
                      "disable-point": "",
                      value: _ctx.$replaceEnNumber(unref(order).order_id)
                    }, null, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_OrdersUserDetailItems, {
                      title: "تاریخ ثبت سفارش",
                      value: _ctx.$replaceEnNumber(unref(getOrderDate)(unref(order).created_at))
                    }, null, _parent3, _scopeId2));
                    _push3(`</div>`);
                    _push3(ssrRenderComponent(_component_OrdersUserAddressInfo, { order: unref(order) }, null, _parent3, _scopeId2));
                    _push3(`<div class="max-md:px-3 py-5 text-gray-400 flex flex-col md:flex-row border-b"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_OrdersUserDetailItems, {
                      title: "مبلغ",
                      "disable-point": "",
                      value: _ctx.$replaceEnNumber(_ctx.$numberFormat(unref(order).final_price)) + " تومان "
                    }, null, _parent3, _scopeId2));
                    if (unref(order).final_price != unref(order).total_price) {
                      _push3(ssrRenderComponent(_component_OrdersUserDetailItems, {
                        title: "سود شما از این خرید",
                        value: _ctx.$replaceEnNumber(_ctx.$numberFormat(unref(order).total_price - unref(order).final_price + unref(order).tax)) + " تومان "
                      }, null, _parent3, _scopeId2));
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(ssrRenderComponent(_component_OrdersUserDetailItems, {
                      title: "هزینه ارسال (بر اساس وزن و حجم) ",
                      value: _ctx.$replaceEnNumber(unref(getTotalShippingCost)(unref(order)))
                    }, null, _parent3, _scopeId2));
                    _push3(`</div>`);
                    if (unref(order).status >= 5 && unref(order).payment_history && unref(order).payment_history.length > 0) {
                      _push3(ssrRenderComponent(_component_OrdersUserPaymentHistory, {
                        histories: unref(order).payment_history,
                        class: "mt-4"
                      }, null, _parent3, _scopeId2));
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(`<!--[-->`);
                    ssrRenderList(unref(order).submissions, (submission, key) => {
                      _push3(`<div class="p-3"${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_OrdersUserSubmission, {
                        submission,
                        number: key + 1 + " از " + unref(order).submissions.length
                      }, null, _parent3, _scopeId2));
                      _push3(`</div>`);
                    });
                    _push3(`<!--]--></div>`);
                  } else {
                    _push3(`<!---->`);
                  }
                } else {
                  return [
                    unref(loading) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "w-full flex justify-center py-10"
                    }, [
                      createVNode(_component_Loading)
                    ])) : unref(order) ? (openBlock(), createBlock("div", { key: 1 }, [
                      createVNode("div", { class: "max-md:px-3 py-2 text-gray-400 flex flex-col md:flex-row border-b" }, [
                        createVNode(_component_OrdersUserDetailItems, {
                          title: "کد سفارش",
                          "disable-point": "",
                          value: _ctx.$replaceEnNumber(unref(order).order_id)
                        }, null, 8, ["value"]),
                        createVNode(_component_OrdersUserDetailItems, {
                          title: "تاریخ ثبت سفارش",
                          value: _ctx.$replaceEnNumber(unref(getOrderDate)(unref(order).created_at))
                        }, null, 8, ["value"])
                      ]),
                      createVNode(_component_OrdersUserAddressInfo, { order: unref(order) }, null, 8, ["order"]),
                      createVNode("div", { class: "max-md:px-3 py-5 text-gray-400 flex flex-col md:flex-row border-b" }, [
                        createVNode(_component_OrdersUserDetailItems, {
                          title: "مبلغ",
                          "disable-point": "",
                          value: _ctx.$replaceEnNumber(_ctx.$numberFormat(unref(order).final_price)) + " تومان "
                        }, null, 8, ["value"]),
                        unref(order).final_price != unref(order).total_price ? (openBlock(), createBlock(_component_OrdersUserDetailItems, {
                          key: 0,
                          title: "سود شما از این خرید",
                          value: _ctx.$replaceEnNumber(_ctx.$numberFormat(unref(order).total_price - unref(order).final_price + unref(order).tax)) + " تومان "
                        }, null, 8, ["value"])) : createCommentVNode("", true),
                        createVNode(_component_OrdersUserDetailItems, {
                          title: "هزینه ارسال (بر اساس وزن و حجم) ",
                          value: _ctx.$replaceEnNumber(unref(getTotalShippingCost)(unref(order)))
                        }, null, 8, ["value"])
                      ]),
                      unref(order).status >= 5 && unref(order).payment_history && unref(order).payment_history.length > 0 ? (openBlock(), createBlock(_component_OrdersUserPaymentHistory, {
                        key: 0,
                        histories: unref(order).payment_history,
                        class: "mt-4"
                      }, null, 8, ["histories"])) : createCommentVNode("", true),
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(order).submissions, (submission, key) => {
                        return openBlock(), createBlock("div", {
                          key: submission.id,
                          class: "p-3"
                        }, [
                          createVNode(_component_OrdersUserSubmission, {
                            submission,
                            number: key + 1 + " از " + unref(order).submissions.length
                          }, null, 8, ["submission", "number"])
                        ]);
                      }), 128))
                    ])) : createCommentVNode("", true)
                  ];
                }
              }),
              _: 2
            }, [
              unref(theme) === "desktop" ? {
                name: "leading",
                fn: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_OrdersUserFactorLink, null, null, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_OrdersUserFactorLink)
                    ];
                  }
                }),
                key: "0"
              } : void 0
            ]), _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_UsersPanelBox, {
                title: unref(theme) == "desktop" ? "جزئیات سفارش" : void 0,
                class: "order-detail",
                backUrl: "/profile/orders"
              }, createSlots({
                default: withCtx(() => [
                  unref(loading) ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "w-full flex justify-center py-10"
                  }, [
                    createVNode(_component_Loading)
                  ])) : unref(order) ? (openBlock(), createBlock("div", { key: 1 }, [
                    createVNode("div", { class: "max-md:px-3 py-2 text-gray-400 flex flex-col md:flex-row border-b" }, [
                      createVNode(_component_OrdersUserDetailItems, {
                        title: "کد سفارش",
                        "disable-point": "",
                        value: _ctx.$replaceEnNumber(unref(order).order_id)
                      }, null, 8, ["value"]),
                      createVNode(_component_OrdersUserDetailItems, {
                        title: "تاریخ ثبت سفارش",
                        value: _ctx.$replaceEnNumber(unref(getOrderDate)(unref(order).created_at))
                      }, null, 8, ["value"])
                    ]),
                    createVNode(_component_OrdersUserAddressInfo, { order: unref(order) }, null, 8, ["order"]),
                    createVNode("div", { class: "max-md:px-3 py-5 text-gray-400 flex flex-col md:flex-row border-b" }, [
                      createVNode(_component_OrdersUserDetailItems, {
                        title: "مبلغ",
                        "disable-point": "",
                        value: _ctx.$replaceEnNumber(_ctx.$numberFormat(unref(order).final_price)) + " تومان "
                      }, null, 8, ["value"]),
                      unref(order).final_price != unref(order).total_price ? (openBlock(), createBlock(_component_OrdersUserDetailItems, {
                        key: 0,
                        title: "سود شما از این خرید",
                        value: _ctx.$replaceEnNumber(_ctx.$numberFormat(unref(order).total_price - unref(order).final_price + unref(order).tax)) + " تومان "
                      }, null, 8, ["value"])) : createCommentVNode("", true),
                      createVNode(_component_OrdersUserDetailItems, {
                        title: "هزینه ارسال (بر اساس وزن و حجم) ",
                        value: _ctx.$replaceEnNumber(unref(getTotalShippingCost)(unref(order)))
                      }, null, 8, ["value"])
                    ]),
                    unref(order).status >= 5 && unref(order).payment_history && unref(order).payment_history.length > 0 ? (openBlock(), createBlock(_component_OrdersUserPaymentHistory, {
                      key: 0,
                      histories: unref(order).payment_history,
                      class: "mt-4"
                    }, null, 8, ["histories"])) : createCommentVNode("", true),
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(order).submissions, (submission, key) => {
                      return openBlock(), createBlock("div", {
                        key: submission.id,
                        class: "p-3"
                      }, [
                        createVNode(_component_OrdersUserSubmission, {
                          submission,
                          number: key + 1 + " از " + unref(order).submissions.length
                        }, null, 8, ["submission", "number"])
                      ]);
                    }), 128))
                  ])) : createCommentVNode("", true)
                ]),
                _: 2
              }, [
                unref(theme) === "desktop" ? {
                  name: "leading",
                  fn: withCtx(() => [
                    createVNode(_component_OrdersUserFactorLink)
                  ]),
                  key: "0"
                } : void 0
              ]), 1032, ["title"])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/profile/orders/[id].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=_id_-DqRYbEGj.js.map
