import { u as useState, h as _sfc_main$1, g as __nuxt_component_0, b as useRuntimeConfig } from "../server.mjs";
import { ref, watch, defineComponent, resolveComponent, mergeProps, unref, withCtx, createVNode, toDisplayString, createTextVNode, createBlock, openBlock, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderClass, ssrInterpolate, ssrRenderAttr } from "vue/server-renderer";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "pinia";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
function useCategoriesPage() {
  const categories = useState("categories");
  const selectedMainCategoryId = ref(null);
  const selectedChildCategoryId = ref(null);
  const theme = useState("theme");
  const getCategories = function(parentId) {
    return categories.value.filter((category) => category.parent_id == parentId);
  };
  const getCategory = function(id) {
    return categories.value.find((category) => category.id == id);
  };
  const showOrHideChildCategoriesBox = (id) => {
    if (selectedChildCategoryId.value == id) {
      selectedChildCategoryId.value = null;
    } else {
      selectedChildCategoryId.value = id;
    }
  };
  watch(() => categories.value, () => {
    if (categories.value != null && categories.value.length > 0 && selectedMainCategoryId.value == null) {
      selectedMainCategoryId.value = categories.value[0].id;
    }
  });
  return {
    categories,
    selectedMainCategoryId,
    selectedChildCategoryId,
    theme,
    getCategory,
    getCategories,
    showOrHideChildCategoriesBox
  };
}
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "categories",
  __ssrInlineRender: true,
  setup(__props) {
    const {
      categories,
      selectedMainCategoryId,
      selectedChildCategoryId,
      getCategory,
      getCategories
    } = useCategoriesPage();
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_Loading = _sfc_main$1;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_nuxt_link = __nuxt_component_0;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "categories-page h-full flex" }, _attrs))}>`);
      if (!unref(categories)) {
        _push(`<div class="h-full w-full flex items-center justify-center">`);
        _push(ssrRenderComponent(_component_Loading, null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="main-categories overflow-auto"><ul><!--[-->`);
      ssrRenderList(unref(getCategories)("0"), (category, key) => {
        _push(`<li class="${ssrRenderClass([{ "active": unref(selectedMainCategoryId) == category.id }, "flex flex-col items-center text-xs py-4 cursor-pointer border-b"])}">`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: category.icon
        }, null, _parent));
        _push(`<span class="pt-3 px-1 text-[11px]">${ssrInterpolate(category.name)}</span></li>`);
      });
      _push(`<!--]--></ul></div>`);
      if (unref(selectedMainCategoryId)) {
        _push(`<div class="child-categories">`);
        _push(ssrRenderComponent(_component_nuxt_link, {
          class: "flex items-center text-xs !text-blue-400",
          to: `/search/${(_a = unref(getCategory)(unref(selectedMainCategoryId))) == null ? void 0 : _a.slug}`
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span${_scopeId}>همه محصولات ${ssrInterpolate(unref(getCategory)(unref(selectedMainCategoryId)).name)}</span>`);
              _push2(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "fa-angle-left"],
                class: "px-2"
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode("span", null, "همه محصولات " + toDisplayString(unref(getCategory)(unref(selectedMainCategoryId)).name), 1),
                createVNode(_component_fa_icon, {
                  icon: ["fas", "fa-angle-left"],
                  class: "px-2"
                })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`<!--[-->`);
        ssrRenderList(unref(getCategories)(unref(selectedMainCategoryId)), (category, key) => {
          _push(`<div>`);
          if (unref(getCategories)(category.id).length == 0) {
            _push(ssrRenderComponent(_component_nuxt_link, {
              class: "category border-b",
              to: "/search/" + category.slug
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(category.name)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(category.name), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else {
            _push(`<a class="category border-b"><span>${ssrInterpolate(category.name)}</span>`);
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", unref(selectedChildCategoryId) == category.id ? "fa-angle-up" : "fa-angle-down"]
            }, null, _parent));
            _push(`</a>`);
          }
          if (unref(selectedChildCategoryId) == category.id) {
            _push(`<ul class="grid grid-cols-3 gap-2"><!--[-->`);
            ssrRenderList(unref(getCategories)(unref(selectedChildCategoryId)), (childCategory, key2) => {
              _push(`<li class="p-2">`);
              _push(ssrRenderComponent(_component_nuxt_link, {
                class: "flex items-center flex-col",
                to: childCategory.url ?? "/search/" + childCategory.slug
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<div class="image-box"${_scopeId}>`);
                    if (childCategory.image) {
                      _push2(`<img${ssrRenderAttr("alt", childCategory.name)} class="w-full max-w-12 blend-mode-darken"${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/upload/" + childCategory.image)}${_scopeId}>`);
                    } else {
                      _push2(`<span class="text-[10px]"${_scopeId}>${ssrInterpolate(childCategory.name)}</span>`);
                    }
                    _push2(`</div><span class="text-[12px] pt-1.5"${_scopeId}>${ssrInterpolate(childCategory.name)}</span>`);
                  } else {
                    return [
                      createVNode("div", { class: "image-box" }, [
                        childCategory.image ? (openBlock(), createBlock("img", {
                          key: 0,
                          alt: childCategory.name,
                          class: "w-full max-w-12 blend-mode-darken",
                          src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/upload/" + childCategory.image
                        }, null, 8, ["alt", "src"])) : (openBlock(), createBlock("span", {
                          key: 1,
                          class: "text-[10px]"
                        }, toDisplayString(childCategory.name), 1))
                      ]),
                      createVNode("span", { class: "text-[12px] pt-1.5" }, toDisplayString(childCategory.name), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent));
              _push(`</li>`);
            });
            _push(`<!--]--></ul>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/categories.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=categories-4_8INg3v.js.map
