import { _ as _sfc_main$1 } from "./ProductLoading-DIaXfK3g.js";
import { _ as _sfc_main$2 } from "./ProductView-CNzvSvNo.js";
import { ref, defineComponent, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderClass, ssrRenderList } from "vue/server-renderer";
import { defineStore } from "pinia";
import { u as useState, c as useNuxtApp, b as useRuntimeConfig, j as useRouter } from "../server.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/hookable/dist/index.mjs";
import "./Skeleton-B5XQTW8R.js";
import "./NuxtImg-DBEieluz.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ufo/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/h3/dist/index.mjs";
import "./v3-CqizLg04.js";
import "D:/Work/Ahmadi/shop/frontend/node_modules/@unhead/vue/dist/index.mjs";
import "./Score-BYZAscMc.js";
import "ofetch";
import "#internal/nuxt/paths";
import "D:/Work/Ahmadi/shop/frontend/node_modules/unctx/dist/index.mjs";
import "vue-router";
import "D:/Work/Ahmadi/shop/frontend/node_modules/radix3/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "highcharts";
import "lodash";
import "D:/Work/Ahmadi/shop/frontend/node_modules/perfect-debounce/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/ohash/dist/index.mjs";
import "@vue/shared";
const useAIImageSearch = defineStore("imageSearch", () => {
  const toast = useState("toast");
  const loading = ref(false);
  const products = ref([]);
  const { $axios } = useNuxtApp();
  const { api } = useRuntimeConfig().public;
  const maxSizeInBytes = 2 * 1024 * 1024;
  const router = useRouter();
  const uploadImage = async (file) => {
    if (!file.type.startsWith("image/")) {
      toast.value = {
        type: "error",
        message: "فقط فایل تصویری مجاز است."
      };
      return;
    }
    if (file.size > maxSizeInBytes) {
      toast.value = {
        type: "error",
        message: "حجم تصویر نباید بیشتر از ۲ مگابایت باشد."
      };
      return;
    }
    await sendUploadRequest(file);
  };
  const sendUploadRequest = async (file) => {
    var _a, _b;
    const formData = new FormData();
    formData.append("image", file);
    loading.value = true;
    await router.push("/image-search");
    try {
      const response = await $axios.post(api + "/products/search-by-image", formData, {
        headers: { "Content-Type": "multipart/form-data" }
      });
      products.value = response.data;
    } catch (error) {
      toast.value = {
        type: "error",
        message: ((_b = (_a = error == null ? void 0 : error.response) == null ? void 0 : _a.data) == null ? void 0 : _b.message) || "خطا در آپلود تصویر."
      };
    } finally {
      loading.value = false;
    }
  };
  return {
    products,
    loading,
    uploadImage
  };
});
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "image-search",
  __ssrInlineRender: true,
  setup(__props) {
    ref(null);
    const theme = useState("theme");
    const searchState = useAIImageSearch();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeSearchProductLoading = _sfc_main$1;
      const _component_ThemeSearchProductView = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "py-5 search-products by-image" }, _attrs))}>`);
      if (unref(searchState).loading) {
        _push(ssrRenderComponent(_component_ThemeSearchProductLoading, null, null, _parent));
      } else if (unref(searchState).products.length > 0) {
        _push(`<div class="${ssrRenderClass([{ "grid grid-cols-2 md:grid-cols-3": unref(theme) != "mobile" }, "products-list"])}"><!--[-->`);
        ssrRenderList(unref(searchState).products, (product) => {
          _push(ssrRenderComponent(_component_ThemeSearchProductView, {
            product,
            key: product.id
          }, null, _parent));
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<div class="flex flex-col items-center py-10 text-gray-500 h-full justify-center"><p class="text-xl">محصول مشابهی یافت نشد ! </p><button class="select-button px-5 py-3 mt-5"> انتخاب تصویر جدید </button></div>`);
      }
      _push(`<input type="file" class="hidden" accept="image/*">`);
      if (unref(searchState).products.length > 0) {
        _push(`<button class="select-button px-2 z-10 py-2.5 mt-5 text-xs absolute left-[15px] bottom-20"> انتخاب تصویر جدید </button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/image-search.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=image-search-DOvJq-5N.js.map
