import { ref } from "vue";
function input(props, model) {
  const error = ref(false);
  const inputKeyUp = function() {
    validateInput(props);
  };
  const validateInput = function(props2) {
    let result = true;
    if (props2.rules) {
      result = validate(
        model.value,
        props2.rules,
        props2.label
      );
    }
    if (result === true) {
      error.value = false;
    } else {
      error.value = result;
    }
    return result;
  };
  const validate = function(value, rules, label) {
    if (typeof rules == "string") {
      rules = rules.toString().split("|");
    }
    let result = true;
    for (let i = 0; i < rules.length; i++) {
      if (result === true && rules[i] !== void 0 && rules[i] != null) {
        if (typeof rules[i] == "function") {
          result = rules[i](value, label);
        } else {
          const ruleArrName = rules[i].toString().split(":");
          if (ruleArrName.length === 2) {
            result = functions[ruleArrName[0]](value, label, ruleArrName[1]);
          } else {
            result = functions[ruleArrName[0]](value, label);
          }
        }
      }
    }
    return result;
  };
  const functions = {
    "min": function(value, label, length) {
      if (value.toString().trim().length < length) {
        return "" + label + " حداقل باید دارای " + length + " کاراکتر باشد";
      }
      return true;
    },
    "max": function(value, label, length) {
      if (value.toString().trim().length > length) {
        return "" + label + " حداکثر باید دارای " + length + " کاراکتر باشد";
      }
      return true;
    },
    "nationalCode": function(value, label) {
      let result = "کد ملی معتبر نمی باشد";
      if (!isNaN(parseInt(value)) && value.toString().length === 10) {
        let sum = 0;
        for (let i = 0; i < 9; i++) {
          let n = parseInt(value[i]);
          sum += (10 - i) * n;
        }
        const ret = sum % 11;
        const parity = parseInt(value[9]);
        if (ret < 2 && ret === parity || ret >= 2 && ret === 11 - parity) {
          result = true;
        }
      }
      return result;
    },
    "required": function(value, label) {
      if (value == null || value.toString().trim() === "") {
        return "" + label + " نمی تواند خالی باشد";
      } else {
        return true;
      }
    },
    "mobile": function(value, label) {
      let result = "" + label + " وارد شده معتبر نمی باشد";
      if (!isNaN(value)) {
        value = parseInt(value);
        if (value.toString().length === 10 && value.toString().charAt(0) === "9") {
          return true;
        }
      }
      return result;
    },
    "length": function(value, label, length) {
      if (value.toString().trim().length !== length) {
        return `${label} باید شامل ${length} کاراکتر باشد`;
      }
      return true;
    },
    "email": function validateEmail(value, label) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!value.toString().trim().match(emailRegex)) {
        return `${label} باید یک ایمیل معتبر باشد`;
      }
      return true;
    }
  };
  const checknationalCode = function(value, label) {
    let result = "کد ملی معتبر نمی باشد";
    if (!isNaN(parseInt(value)) && value.toString().length === 10) {
      let sum = 0;
      for (let i = 0; i < 9; i++) {
        let n = parseInt(value[i]);
        sum += (10 - i) * n;
      }
      const ret = sum % 11;
      const parity = parseInt(value[9]);
      if (ret < 2 && ret == parity || ret >= 2 && ret == 11 - parity) {
        result = true;
      }
    }
    return result;
  };
  return {
    error,
    checknationalCode,
    inputKeyUp,
    validateInput,
    functions
  };
}
export {
  input as i
};
//# sourceMappingURL=input-CqSTwEhb.js.map
