import { b as useRuntimeConfig, u as useState, g as __nuxt_component_0, l as _sfc_main$7 } from "../server.mjs";
import { defineComponent, mergeProps, unref, useSSRContext, resolveComponent, createVNode, resolveDynamicComponent, withCtx, toDisplayString } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderVNode, ssrRenderClass, ssrRenderSlot } from "vue/server-renderer";
import { _ as _sfc_main$6 } from "./SendDetail-CCtW5pOV.js";
const _sfc_main$5 = /* @__PURE__ */ defineComponent({
  __name: "ProductImage",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<img${ssrRenderAttrs(mergeProps({
        src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + _ctx.product.image,
        class: "w-full",
        alt: _ctx.product.title
      }, _attrs))}>`);
    };
  }
});
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cart/ProductImage.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const _sfc_main$4 = {
  __name: "StatusInWarehouse",
  __ssrInlineRender: true,
  props: ["variation"],
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "store-alt"],
        class: "!text-red-600"
      }, null, _parent));
      if (__props.variation.sender === "self" && __props.variation.seller_id > 0 && __props.variation.preparation_time > 0) {
        _push(`<span class="px-3 text-sm"> موجود در انبار فروشنده </span>`);
      } else {
        _push(`<span class="px-3 text-sm"> موجود در انبار فروشگاه </span>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/StatusInWarehouse.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "StockNotice",
  __ssrInlineRender: true,
  props: {
    variation: {}
  },
  setup(__props) {
    const shopSetting = useState("shopSetting");
    return (_ctx, _push, _parent, _attrs) => {
      if (_ctx.variation.product_count <= 10 && _ctx.variation.product_count > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "!text-red-600" }, _attrs))}><span>تنها </span><span>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.variation.product_count))}</span><span> عدد در انبار </span>`);
        if (unref(shopSetting)) {
          _push(`<!--[-->`);
          if (_ctx.variation.sender === "self") {
            _push(`<span>${ssrInterpolate(unref(shopSetting).name)}</span>`);
          } else if (_ctx.variation.seller) {
            _push(`<span>${ssrInterpolate(_ctx.variation.seller.brandName)}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span> باقی مانده </span></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/StockNotice.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "CartDetail",
  __ssrInlineRender: true,
  props: {
    variation: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_PriceVariationStatusInWarehouse = _sfc_main$4;
      const _component_PriceVariationSendDetail = _sfc_main$6;
      const _component_PriceVariationStockNotice = _sfc_main$3;
      _push(`<div${ssrRenderAttrs(_attrs)}><!--[-->`);
      ssrRenderList(3, (i) => {
        _push(`<!--[-->`);
        if (_ctx.$variationParamComponent(_ctx.variation["param" + i + "_type"])) {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.$variationParamComponent(_ctx.variation["param" + i + "_type"])), {
            data: _ctx.variation["param" + i],
            class: "text-sm py-1"
          }, null), _parent);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--><div class="text-sm py-3">`);
      _push(ssrRenderComponent(_component_PriceVariationStatusInWarehouse, { variation: _ctx.variation }, null, _parent));
      _push(`<ul class="send-detail my-3 !p-0"><li class="flex items-center"><div class="flex flex-col items-center"><div class="w-[1px] h-3 bg-blue-200"></div><div class="w-1 h-1 rounded-full bg-blue-200 m-1"></div></div>`);
      _push(ssrRenderComponent(_component_PriceVariationSendDetail, { variation: _ctx.variation }, null, _parent));
      _push(`</li></ul></div><div class="flex items-center">`);
      _push(ssrRenderComponent(_component_PriceVariationStockNotice, {
        variation: _ctx.variation,
        class: "text-xs"
      }, null, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/CartDetail.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ProductPrice",
  __ssrInlineRender: true,
  props: {
    variation: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[-->`);
      if (_ctx.variation.price1 > _ctx.variation.price2) {
        _push(`<span class="font-bold text-red-500 py-2">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(_ctx.variation.price1 - _ctx.variation.price2)))} تومان تخفیف </span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<span class="font-bold py-2">${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(_ctx.variation.price2)))} تومان </span><!--]-->`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cart/ProductPrice.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "products",
  __ssrInlineRender: true,
  props: {
    products: {},
    disableAction: { type: Boolean }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0;
      const _component_CartProductImage = _sfc_main$5;
      const _component_PriceVariationCartDetail = _sfc_main$2;
      const _component_CartAction = _sfc_main$7;
      const _component_CartProductPrice = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(_attrs)}><!--[-->`);
      ssrRenderList(_ctx.products, (product, key) => {
        _push(`<div class="${ssrRenderClass([{ "!border-b block": key != _ctx.products.length - 1 }, "p-2"])}"><div class="flex"><div class="w-[170px] p-3 cart-action">`);
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: _ctx.$getProductPath(product)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_CartProductImage, { product }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_CartProductImage, { product }, null, 8, ["product"])
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div><div class="flex-grow w-full flex flex-col">`);
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: _ctx.$getProductPath(product)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<h1 class="cart-product-title"${_scopeId}>${ssrInterpolate(product.title)}</h1>`);
            } else {
              return [
                createVNode("h1", { class: "cart-product-title" }, toDisplayString(product.title), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`<div class="header-cart-variation-detail">`);
        _push(ssrRenderComponent(_component_PriceVariationCartDetail, {
          variation: product.variation
        }, null, _parent));
        _push(`</div></div></div><div class="flex"><div class="w-[170px] p-3 cart-action">`);
        if (!_ctx.disableAction) {
          _push(ssrRenderComponent(_component_CartAction, {
            product,
            "hide-cart-link": ""
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex-grow w-full flex flex-col">`);
        _push(ssrRenderComponent(_component_CartProductPrice, {
          variation: product.variation,
          class: "!px-0"
        }, null, _parent));
        _push(`</div></div>`);
        ssrRenderSlot(_ctx.$slots, "footer", { product }, null, _push, _parent);
        _push(`</div>`);
      });
      _push(`<!--]--></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cart/products.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
//# sourceMappingURL=products-6mNvaXLL.js.map
