import { defineStore } from "pinia";
import { s as searchStore } from "./search-products-xw_89Bg_.js";
import { ref } from "vue";
import { b as useRuntimeConfig, c as useNuxtApp } from "../server.mjs";
const useProductsAdsStore = defineStore("productsAdsStore", (ProductsAdsStore) => {
  const searchState = searchStore();
  const ads = ref({});
  const { api } = useRuntimeConfig().public;
  const { $axios } = useNuxtApp();
  const getAds = (category) => {
    $axios.get(api + "/ads/search/products/" + category.id).then((response) => {
      ads.value = response.data;
      updateProductsList();
    });
  };
  const updateProductsList = () => {
    var _a;
    if (searchState.page == 1 && ads.value.search_list) {
      if (searchState.result && searchState.result.products && searchState.result.products.data.length > 0 && ((_a = ads.value.search_list) == null ? void 0 : _a.length) > 0) {
        const original = [...searchState.result.products.data];
        const firstTwo = original.slice(0, 2);
        const merged = [
          ...firstTwo,
          ...ads.value.search_list,
          ...original.slice(2)
        ];
        searchState.updateResult({
          ...searchState.result,
          products: {
            ...searchState.result.products,
            data: merged
          }
        });
      }
    }
  };
  const clearAds = () => {
    ads.value = {
      search_list: [],
      sidebar: []
    };
  };
  return {
    getAds,
    updateProductsList,
    clearAds,
    ads
  };
});
export {
  useProductsAdsStore as u
};
//# sourceMappingURL=products-ads-store-DuWXzJJS.js.map
