import { c as useNuxtApp, b as useRuntimeConfig } from "../server.mjs";
import { ref } from "vue";
import "D:/Work/Ahmadi/shop/frontend/node_modules/klona/dist/index.mjs";
import "D:/Work/Ahmadi/shop/frontend/node_modules/defu/dist/defu.mjs";
import "#internal/nuxt/paths";
import { defineStore } from "pinia";
const searchStore = defineStore("search-products", () => {
  const page = ref(1);
  const status = ref("pending");
  const requestUrl = ref("");
  const result = ref({});
  const appBarTitle = ref(null);
  const sortItems = [
    { title: "پربازدیدترین", value: 21 },
    { title: "جدیدترین", value: 23 },
    { title: "پرفروش‌ترین‌", value: 24 },
    { title: "ارزان‌ترین", value: 25 },
    { title: "گران‌ترین", value: 26 },
    { title: "سریع‌ترین ارسال", value: 27 }
  ];
  const queries = ref({});
  const endLoaded = ref(false);
  const { $axios } = useNuxtApp();
  const changeSortProducts = (item) => {
    page.value = 1;
    result.value.products.data = [];
    endLoaded.value = false;
    queries.value["orderBy"] = item.value;
  };
  const scroll = () => {
    const loadMore = (void 0).querySelector(`.load-more`);
    if (loadMore) {
      const observer = new IntersectionObserver(
        ([entry]) => {
          if (entry.isIntersecting) {
            if (status.value == "success" && !endLoaded.value) {
              page.value++;
              loadMoreProducts();
            }
          }
        },
        { threshold: 0.6 }
      );
      observer.observe(loadMore);
    }
  };
  const loadMoreProducts = () => {
    status.value = "pending";
    let urlWithoutQuery = (void 0).location.origin + (void 0).location.pathname;
    if (queries.value && Object.keys(queries.value).length > 0) {
      urlWithoutQuery = urlWithoutQuery + "?page=" + page.value + "&" + paramsToQueryString(queries.value);
    }
    (void 0).history.pushState(null, "", urlWithoutQuery);
    $axios.get(getSearchUrl()).then((response) => {
      status.value = "success";
      if (result.value.products) {
        result.value.products.data = [
          ...result.value.products.data,
          ...response.data.products.data
        ];
      } else {
        result.value = response.data;
      }
      if (response.data.products.data.length < 10) {
        endLoaded.value = true;
      }
    }).catch(() => {
      status.value = "error";
    });
  };
  const paramsToQueryString = (queries2) => {
    return Object.entries(queries2).map(([key, value]) => {
      if (typeof value === "object") {
        let name = key;
        const ar = key.toString().split("_");
        if (ar.length == 2) {
          name = ar[0] + "[" + ar[1] + "]";
          return Object.entries(value).map(
            ([subKey], index) => `${name}[${index}]=${encodeURIComponent(subKey)}`
          ).join("&");
        }
        return Object.entries(value).map(
          ([subKey, subValue], index) => `${name}[${subKey}]=${encodeURIComponent(subValue)}`
        ).join("&");
      }
      return `${key}=${encodeURIComponent(value)}`;
    }).join("&");
  };
  const setDefaultQueries = () => {
  };
  const removeFilters = () => {
    queries.value = {};
  };
  const addOrRemoveFilter = (name, value) => {
    queries.value[name] = queries.value[name] || {};
    const entry = Object.entries(queries.value[name]).find(([key2, selectedValue]) => selectedValue == value);
    const key = entry ? entry[0] : null;
    if (!key) {
      queries.value[name][Object.keys(queries.value[name]).length] = value;
    } else {
      delete queries.value[name][key];
      if (Object.keys(queries.value[name]).length === 0) {
        delete queries.value[name];
      }
    }
  };
  const getSearchUrl = () => {
    let url = useRuntimeConfig().public.api + requestUrl.value + "&page=" + page.value;
    if (queries.value && Object.keys(queries.value).length > 0) {
      url = url + "&" + paramsToQueryString(queries.value);
    }
    return url;
  };
  const updateQueries = (value) => {
    queries.value = value;
  };
  const updateResult = (data) => {
    var _a, _b;
    result.value = data;
    if (((_b = (_a = data.products) == null ? void 0 : _a.data) == null ? void 0 : _b.length) < 10) {
      endLoaded.value = true;
    }
  };
  const updateRequestState = (value) => {
    status.value = value;
  };
  const reset = () => {
    page.value = 1;
    endLoaded.value = false;
    updateResult({});
  };
  const updateRequestUrl = (url) => {
    requestUrl.value = url;
  };
  return {
    page,
    queries,
    result,
    sortItems,
    status,
    endLoaded,
    requestUrl,
    appBarTitle,
    updateResult,
    getSearchUrl,
    updateRequestState,
    addOrRemoveFilter,
    removeFilters,
    updateQueries,
    setDefaultQueries,
    loadMoreProducts,
    scroll,
    reset,
    updateRequestUrl,
    changeSortProducts
  };
});
export {
  searchStore as s
};
//# sourceMappingURL=search-products-xw_89Bg_.js.map
