import { b as useRuntimeConfig, c as useNuxtApp, h as _sfc_main$k, g as __nuxt_component_0$2 } from './server.mjs';
import { _ as _sfc_main$1 } from './Dialog-CBk-AHyk.mjs';
import { defineComponent, ref, resolveComponent, unref, withCtx, createVNode, isRef, useSSRContext } from 'vue';
import { ssrRenderList, ssrRenderComponent } from 'vue/server-renderer';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';
import './Component-C6QGchKb.mjs';
import './user-utils-B9JSuaai.mjs';
import './TextInput-BtVMT3NE.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "AddCommentBuyer",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const form = ref(null);
    const { api } = useRuntimeConfig().public;
    const { $axios } = useNuxtApp();
    const props = __props;
    const score = ref(0);
    const loading = ref(false);
    const updateProductScore = (n) => {
      loading.value = true;
      $axios.post(api + "/user/comment/score", {
        "score": n,
        "product_id": props.product.id
      }).then((response) => {
        score.value = n;
        loading.value = false;
      }).catch(() => {
        loading.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_Loading = _sfc_main$k;
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_CommentCreateDialog = _sfc_main$1;
      _push(`<!--[--><div class="flex justify-between mt-7"><div class="flex items-center"><span>\u0627\u0645\u062A\u06CC\u0627\u0632 \u062F\u0647\u06CC\u062F : </span><div class="flex items-center">`);
      if (!unref(loading)) {
        _push(`<!--[-->`);
        ssrRenderList(5, (i) => {
          _push(ssrRenderComponent(_component_fa_icon, {
            key: i,
            icon: ["fas", "star"],
            class: ["px-2 text-[17px] cursor-pointer text-gray-400", { "text-yellow-400": unref(score) && unref(score) >= i }],
            onClick: ($event) => updateProductScore(i)
          }, null, _parent));
        });
        _push(`<!--]-->`);
      } else {
        _push(ssrRenderComponent(_component_Loading, { type: "small" }, null, _parent));
      }
      _push(`</div></div>`);
      _push(ssrRenderComponent(_component_nuxt_link, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<button class="c-btn bg-white h-8 text-red-500 text-sm px-3"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_fa_icon, { icon: ["far", "comment"] }, null, _parent2, _scopeId));
            _push2(`<span class="px-3"${_scopeId}>\u0627\u0641\u0632\u0648\u062F\u0646 \u0646\u0638\u0631</span></button>`);
          } else {
            return [
              createVNode("button", {
                class: "c-btn bg-white h-8 text-red-500 text-sm px-3",
                onClick: ($event) => unref(form).show()
              }, [
                createVNode(_component_fa_icon, { icon: ["far", "comment"] }),
                createVNode("span", { class: "px-3" }, "\u0627\u0641\u0632\u0648\u062F\u0646 \u0646\u0638\u0631")
              ], 8, ["onClick"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_component_CommentCreateDialog, {
        ref_key: "form",
        ref: form,
        product: { ..._ctx.product, ...{ purchase_status: "purchased" } },
        modelValue: unref(score),
        "onUpdate:modelValue": ($event) => isRef(score) ? score.value = $event : null
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comment/AddCommentBuyer.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=AddCommentBuyer-C5-rzThg.mjs.map
