import { b as useRuntimeConfig, u as useState, y as _sfc_main$5 } from './server.mjs';
import { defineComponent, computed, resolveComponent, unref, mergeProps, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderAttr, ssrRenderStyle, ssrRenderComponent } from 'vue/server-renderer';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "DisplayOfferLabel",
  __ssrInlineRender: true,
  props: {
    product: {}
  },
  setup(__props) {
    const props = __props;
    const { appUrl } = useRuntimeConfig().public;
    const selectedVariationId = useState("variation-id");
    const selectedVariation = computed(() => {
      var _a;
      return (_a = props.product.variations) == null ? void 0 : _a.find((row) => row.id == selectedVariationId.value);
    });
    const currentTimestamp = computed(() => Math.floor(Date.now() / 1e3));
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Timer = _sfc_main$5;
      const _component_fa_icon = resolveComponent("fa-icon");
      if (unref(selectedVariation) && unref(selectedVariation).promotion_time) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full flex items-center justify-between bg-red-100 px-2 py-0.5" }, _attrs))}><img alt=""${ssrRenderAttr("src", unref(appUrl) + "/images/IncredibleOffer.svg")}><div class="flex items-center" style="${ssrRenderStyle({ "color": "rgb(230, 18, 61)" })}">`);
        _push(ssrRenderComponent(_component_Timer, {
          "total-seconds": unref(selectedVariation).promotion_time - unref(currentTimestamp)
        }, null, _parent));
        _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "clock"] }, null, _parent));
        _push(`</div></div>`);
      } else if (_ctx.product.variation && _ctx.product.variation.promotion_time) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full" }, _attrs))}><img alt=""${ssrRenderAttr("src", unref(appUrl) + "/images/IncredibleOffer.svg")}></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/promotions/DisplayOfferLabel.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=DisplayOfferLabel-NawhS09e.mjs.map
