import { e as useRoute, j as useRouter, b as useRuntimeConfig } from './server.mjs';
import { defineComponent, resolveComponent, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderAttr } from 'vue/server-renderer';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "IncredibleOffersAppBar",
  __ssrInlineRender: true,
  setup(__props) {
    const route = useRoute();
    useRouter();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full text-white incredible-offers-appbar flex items-center justify-between h-full px-3" }, _attrs))}>`);
      if (unref(route).path != "/") {
        _push(`<button>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          icon: ["fas", "arrow-right"],
          class: "pl-3 cursor-pointer"
        }, null, _parent));
        _push(`</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/incredible-offers-text.svg")} alt=""><div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/promotions/IncredibleOffersAppBar.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=IncredibleOffersAppBar-ByttlwWQ.mjs.map
