import { computed, unref, mergeProps, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderClass, ssrInterpolate } from 'vue/server-renderer';

const _sfc_main = {
  __name: "Pagination",
  __ssrInlineRender: true,
  props: {
    data: {
      type: Object
    },
    offset: {
      type: Number,
      default: 4
    },
    fetchData: {
      type: Function
    }
  },
  setup(__props) {
    const props = __props;
    const pages = computed(() => {
      let pages2 = [];
      if (props.data.to !== void 0) {
        let from = props.data.current_page - props.offset;
        if (from < 1) {
          from = 1;
        }
        let to = from + props.offset;
        if (to > props.data.last_page) {
          to = props.data.last_page;
        }
        for (let page = from; page <= to; page++) {
          pages2.push(page);
        }
      }
      return pages2;
    });
    return (_ctx, _push, _parent, _attrs) => {
      if (unref(pages).length > 1) {
        _push(`<ul${ssrRenderAttrs(mergeProps({ class: "pagination" }, _attrs))}>`);
        if (__props.data.current_page > 1) {
          _push(`<li class="page-item text-sm"><a class="page-link"> \u0642\u0628\u0644\u06CC </a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--[-->`);
        ssrRenderList(unref(pages), (page) => {
          _push(`<li class="${ssrRenderClass([[page == __props.data.current_page ? "active" : "not-active"], "page-item mx-1"])}"><a class="page-link"><span>${ssrInterpolate(_ctx.$replaceEnNumber(page))}</span></a></li>`);
        });
        _push(`<!--]-->`);
        if (__props.data.last_page > unref(pages)[unref(pages).length - 1]) {
          _push(`<li class="page-item mx-1"><a class="page-link"><span>...</span></a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.data.last_page > unref(pages)[unref(pages).length - 1]) {
          _push(`<li class="page-item not-active mx-1"><a class="page-link"><span>${ssrInterpolate(_ctx.$replaceEnNumber(__props.data.last_page))}</span></a></li>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.data.current_page < __props.data.last_page) {
          _push(`<li class="page-item text-sm mx-1"><a class="page-link"><span>\u0628\u0639\u062F\u06CC</span></a></li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</ul>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Pagination.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=Pagination-BRp8RD1E.mjs.map
