import { _ as _sfc_main$2 } from './TextInput-BtVMT3NE.mjs';
import { defineComponent, ref, watch, resolveComponent, mergeProps, unref, isRef, withCtx, createVNode, mergeModels, useModel, watchEffect, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderStyle, ssrInterpolate } from 'vue/server-renderer';
import { s as searchStore } from './search-products-xw_89Bg_.mjs';
import './server.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main$1 = {
  __name: "RangeSlider",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    min: { type: Number, default: 0 },
    max: { type: Number, default: 100 },
    hideValue: { type: Boolean },
    labels: Array
  }, {
    "min-value": {},
    "min-valueModifiers": {},
    "max-value": {},
    "max-valueModifiers": {}
  }),
  emits: /* @__PURE__ */ mergeModels(["after-changed"], ["update:min-value", "update:max-value"]),
  setup(__props, { emit: __emit }) {
    const props = __props;
    const { min, max, hideValue, labels } = props;
    const sliderTrack = ref(null);
    const left = useModel(__props, "min-value");
    const right = useModel(__props, "max-value");
    const leftNormalized = ref(0);
    const rightNormalized = ref(100);
    ref(false);
    ref(null);
    ref(0);
    ref(0);
    const updateSliderTrack = () => {
      const leftPercent = 100 - leftNormalized.value;
      const rightPercent = 100 - rightNormalized.value;
      const background = `linear-gradient(to right, #ddd ${rightPercent}%, #4ecad4 ${rightPercent}% ${leftPercent}%, #ddd ${leftPercent}%)`;
      if (sliderTrack.value) {
        sliderTrack.value.style.background = background;
      }
    };
    const normalize = (value) => (value - min) / (max - min) * 100;
    watchEffect(() => {
      leftNormalized.value = normalize(left.value);
      rightNormalized.value = normalize(right.value);
      updateSliderTrack();
    });
    const formatPrice = (price) => `${price.toLocaleString()} \u062A\u0648\u0645\u0627\u0646`;
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "slider-container",
        dir: "rtl"
      }, _attrs))}><div class="slider-track"></div><div class="slider-thumb" style="${ssrRenderStyle({ right: `${unref(leftNormalized) / 100 * 100}%` })}"></div><div class="slider-thumb" style="${ssrRenderStyle({ right: `calc(${unref(rightNormalized) / 100 * 100}% - 10px)` })}"></div>`);
      if (unref(labels)) {
        _push(`<div class="slider-labels"><div>`);
        if (!unref(hideValue)) {
          _push(`<span>${ssrInterpolate(formatPrice(left.value))} -</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span>${ssrInterpolate(unref(labels)[0])}</span></div><div class="ml-[-10px]">`);
        if (!unref(hideValue)) {
          _push(`<span>${ssrInterpolate(formatPrice(right.value))} -</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<span>${ssrInterpolate(unref(labels)[1])}</span></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/RangeSlider.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "PriceRange",
  __ssrInlineRender: true,
  props: {
    hideTitle: { type: Boolean }
  },
  setup(__props) {
    const store = searchStore();
    const boxStats = ref({});
    const minPrice = ref(store.result["min_price"]);
    const maxPrice = ref(store.result["max_price"]);
    const afterChanged = () => {
      if (!store.queries["price"] || store.queries["price"]["min"] != minPrice.value || store.queries["price"]["max"] != maxPrice.value) {
        store.queries = {
          ...store.queries,
          ...{
            price: {
              min: minPrice.value,
              max: maxPrice.value
            }
          }
        };
      }
    };
    watch(() => minPrice.value, () => {
      if (minPrice.value > store.result["max_price"]) {
        minPrice.value = store.result["max_price"];
      }
    });
    watch(() => store.queries, () => {
      var _a, _b;
      if (Object.keys(store.queries).length == 0) {
        minPrice.value = (_a = store.result["min_price"]) != null ? _a : 0;
        maxPrice.value = (_b = store.result["max_price"]) != null ? _b : maxPrice.value;
      }
    }, { deep: true });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FormTextInput = _sfc_main$2;
      const _component_RangeSlider = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "filter-box" }, _attrs))}>`);
      if (!_ctx.hideTitle) {
        _push(`<div class="title"><div class="flex items-center"> \u0645\u062D\u062F\u0648\u062F\u0647 \u0642\u06CC\u0645\u062A `);
        if (unref(store).queries["price"]) {
          _push(`<div class="w-1 h-1 rounded-full bg-blue-400 mx-1"></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        _push(ssrRenderComponent(_component_fa_icon, {
          class: "text-gray-500",
          icon: [
            "fas",
            unref(boxStats)["price-range"] ? "fa-angle-up" : "fa-angle-down"
          ]
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(boxStats)["price-range"] || _ctx.hideTitle) {
        _push(`<div class="content"><div>`);
        _push(ssrRenderComponent(_component_FormTextInput, {
          type: "number",
          class: "price-rang",
          real: unref(minPrice),
          "onUpdate:real": ($event) => isRef(minPrice) ? minPrice.value = $event : null,
          separator: ",",
          name: "min-price",
          onFocusout: ($event) => afterChanged()
        }, {
          perfix: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex items-center text-sm"${_scopeId}>\u0627\u0632</div>`);
            } else {
              return [
                createVNode("div", { class: "flex items-center text-sm" }, "\u0627\u0632")
              ];
            }
          }),
          suffix: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex items-center text-sm"${_scopeId}>\u062A\u0648\u0645\u0627\u0646</div>`);
            } else {
              return [
                createVNode("div", { class: "flex items-center text-sm" }, "\u062A\u0648\u0645\u0627\u0646")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_FormTextInput, {
          type: "number",
          class: "price-rang",
          real: unref(maxPrice),
          "onUpdate:real": ($event) => isRef(maxPrice) ? maxPrice.value = $event : null,
          separator: ",",
          name: "max-price",
          onFocusout: ($event) => afterChanged()
        }, {
          perfix: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex items-center text-sm"${_scopeId}>\u0628\u0647</div>`);
            } else {
              return [
                createVNode("div", { class: "flex items-center text-sm" }, "\u0628\u0647")
              ];
            }
          }),
          suffix: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex items-center text-sm"${_scopeId}>\u062A\u0648\u0645\u0627\u0646</div>`);
            } else {
              return [
                createVNode("div", { class: "flex items-center text-sm" }, "\u062A\u0648\u0645\u0627\u0646")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><div class="pl-5">`);
        _push(ssrRenderComponent(_component_RangeSlider, {
          min: unref(store).result["min_price"],
          max: unref(store).result["max_price"],
          "hide-value": "",
          "min-value": unref(minPrice),
          "onUpdate:minValue": ($event) => isRef(minPrice) ? minPrice.value = $event : null,
          "max-value": unref(maxPrice),
          "onUpdate:maxValue": ($event) => isRef(maxPrice) ? maxPrice.value = $event : null,
          onAfterChanged: afterChanged,
          labels: ["\u0627\u0631\u0632\u0627\u0646\u062A\u0631\u06CC\u0646", "\u06AF\u0631\u0627\u0646\u062A\u0631\u06CC\u0646"]
        }, null, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/filters/PriceRange.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=PriceRange-05ikxTno.mjs.map
