import { defineComponent, ref, resolveComponent, createVNode, resolveDynamicComponent, unref, withCtx, toDisplayString, withModifiers, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderVNode, ssrInterpolate } from 'vue/server-renderer';
import { c as clearUserData } from './user-utils-B9JSuaai.mjs';
import { u as useState, _ as _sfc_main$i, a as _sfc_main$o, c as useNuxtApp, b as useRuntimeConfig, n as navigateTo } from './server.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "RemoveRequestBtn",
  __ssrInlineRender: true,
  props: {
    then: { type: Function },
    id: {},
    requestUrl: {},
    title: {},
    description: {},
    deleteBtnText: {}
  },
  setup(__props) {
    const toast = useState("toast");
    const boxRef = ref(null);
    const theme = useState("theme");
    const props = __props;
    const sendDeleteRequest = () => {
      useNuxtApp().$axios.delete(
        useRuntimeConfig().public.api + "/user/statistics/recent-visits/" + props.id
      ).then(() => {
        props.then(props.id);
      }).catch((error) => {
        toast.value = {
          message: "\u062E\u0637\u0627 \u062F\u0631 \u0627\u062C\u0631\u0627\u06CC \u062F\u0631\u062E\u0648\u0627\u0633\u062A \u0645\u062C\u062F\u062F\u0627 \u062A\u0644\u0627\u0634 \u0646\u0645\u0627\u06CC\u06CC\u062F",
          type: "error"
        };
        if (error && error.status && error.status == 401) {
          clearUserData();
          navigateTo("/login");
        }
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<!--[--><button class="c-btn2 border-gray-300 text-gray-500 px-3">`);
      _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "trash"] }, null, _parent));
      _push(`<span class="pr-3">\u062D\u0630\u0641</span></button>`);
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$i : _sfc_main$o), {
        "content-class": "w-full !h-auto bottom-0",
        direction: "bottom",
        title: _ctx.title,
        ref_key: "boxRef",
        ref: boxRef
      }, {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex w-full justify-end p-3"${_scopeId}><button class="c-btn2 px-5"${_scopeId}> \u062E\u06CC\u0631 </button><button class="c-btn mr-3 px-5"${_scopeId}>${ssrInterpolate(_ctx.deleteBtnText)}</button></div>`);
          } else {
            return [
              createVNode("div", { class: "flex w-full justify-end p-3" }, [
                createVNode("button", {
                  class: "c-btn2 px-5",
                  onClick: withModifiers(($event) => unref(boxRef).hide(), ["prevent"])
                }, " \u062E\u06CC\u0631 ", 8, ["onClick"]),
                createVNode("button", {
                  class: "c-btn mr-3 px-5",
                  onClick: withModifiers(($event) => sendDeleteRequest(), ["prevent"])
                }, toDisplayString(_ctx.deleteBtnText), 9, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<p class="text-gray-600 px-4 py-7 max-w-[700px] leading-8"${_scopeId}>${ssrInterpolate(_ctx.description)}</p>`);
          } else {
            return [
              createVNode("p", { class: "text-gray-600 px-4 py-7 max-w-[700px] leading-8" }, toDisplayString(_ctx.description), 1)
            ];
          }
        }),
        _: 1
      }), _parent);
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/users/RemoveRequestBtn.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=RemoveRequestBtn-CGRu9Gzt.mjs.map
