import { d as _sfc_main$b, u as useState, e as useRoute, c as useNuxtApp, b as useRuntimeConfig } from './server.mjs';
import { defineComponent, resolveComponent, unref, mergeProps, ref, computed, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import { s as searchStore } from './search-products-xw_89Bg_.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

function useBrandFilter() {
  const store = searchStore();
  const brands = useState("brands");
  useState("categories");
  const category = ref();
  useRoute().params;
  const showList = ref(false);
  const selectedBrands = ref({});
  const { $axios } = useNuxtApp();
  const { api } = useRuntimeConfig().public;
  const filteredBrand = computed(() => {
    if (!category.value) {
      return brands.value;
    }
    return brands.value.filter((brand) => {
      if (!brand.categories) return false;
      const categoryList = brand.categories.toString().split(",");
      return categoryList.includes(category.value.id.toString());
    });
  });
  const addOrRemoveFilter = (brandId) => {
    store.addOrRemoveFilter("brands", brandId.toString());
  };
  return {
    selectedBrands,
    showList,
    store,
    filteredBrand,
    brands,
    addOrRemoveFilter
  };
}
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SearchSelectBrand",
  __ssrInlineRender: true,
  props: {
    mobileTheme: { type: Boolean }
  },
  setup(__props) {
    const {
      selectedBrands,
      showList,
      store,
      filteredBrand,
      brands,
      addOrRemoveFilter
    } = useBrandFilter();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FormCheckBox = _sfc_main$b;
      if (unref(brands)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "filter-box" }, _attrs))}>`);
        if (!_ctx.mobileTheme) {
          _push(`<div class="title"><div class="flex items-center"> \u0628\u0631\u0646\u062F \u0647\u0627 `);
          if (unref(store).queries["brands"]) {
            _push(`<div class="w-1 h-1 rounded-full bg-blue-400 mx-1"></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
          _push(ssrRenderComponent(_component_fa_icon, {
            class: "text-gray-500",
            icon: ["fas", unref(showList) ? "fa-angle-up" : "fa-angle-down"]
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(showList) || _ctx.mobileTheme) {
          _push(`<div class="content"><ul><!--[-->`);
          ssrRenderList(unref(filteredBrand), (brand) => {
            _push(`<li class="flex items-center py-3 text-sm justify-between">`);
            _push(ssrRenderComponent(_component_FormCheckBox, {
              label: brand.name,
              name: brand.id,
              afterClick: unref(addOrRemoveFilter),
              modelValue: unref(selectedBrands)[brand.id],
              "onUpdate:modelValue": ($event) => unref(selectedBrands)[brand.id] = $event
            }, null, _parent));
            _push(`<span class="text-xs text-gray-500">${ssrInterpolate(brand.english_name)}</span></li>`);
          });
          _push(`<!--]--></ul></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/brands/SearchSelectBrand.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=SearchSelectBrand-DjsAD_lu.mjs.map
