import { _ as _sfc_main$3 } from './TextInput-BtVMT3NE.mjs';
import { defineComponent, mergeModels, useModel, resolveComponent, mergeProps, unref, ref, inject, watch, isRef, createVNode, resolveDynamicComponent, withCtx, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderClass, ssrRenderList, ssrRenderComponent, ssrRenderStyle, ssrRenderAttr, ssrRenderVNode } from 'vue/server-renderer';
import { u as useState, _ as _sfc_main$i, a as _sfc_main$o } from './server.mjs';
import { i as input } from './input-CqSTwEhb.mjs';

function useSelectTagListView(config) {
  const searchText = ref("");
  const listItems = ref([]);
  const listIndex = ref(0);
  const previousItems = () => {
    if (listIndex.value > 0) {
      listItems.value.splice(listIndex.value, 1);
      listIndex.value--;
    }
  };
  const showChildList = (item) => {
    var _a;
    const list = getItemsList(item[(_a = config.itemValue) != null ? _a : "value"]);
    if (list.length > 0) {
      listIndex.value++;
      listItems.value[listIndex.value] = list;
    }
  };
  const getItemsList = function(value) {
    let items = [];
    for (let i = 0; i < config.items.length; i++) {
      if (config.items[i][config.nestedProperty] == value) {
        items.push(config.items[i]);
      }
    }
    return items;
  };
  return {
    searchText,
    listIndex,
    listItems,
    getItemsList,
    showChildList,
    previousItems
  };
}
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "ListView",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    config: {}
  }, {
    "modelValue": {},
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const model = useModel(__props, "modelValue");
    const props = __props;
    if (props.config.multiSelect && (!model.value || typeof model.value == "string")) {
      model.value = {};
    }
    const {
      searchText,
      listIndex,
      listItems,
      getItemsList,
      showChildList
    } = useSelectTagListView(props.config);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormTextInput = _sfc_main$3;
      const _component_fa_icon = resolveComponent("fa-icon");
      if (unref(listItems)[unref(listIndex)]) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "h-full" }, _attrs))}>`);
        if (unref(listItems)[unref(listIndex)].length > 10) {
          _push(`<div class="mx-3 my-1.5">`);
          _push(ssrRenderComponent(_component_FormTextInput, {
            placeholder: "\u062C\u0633\u062A\u062C\u0648",
            "hide-label": "",
            modelValue: unref(searchText),
            "onUpdate:modelValue": ($event) => isRef(searchText) ? searchText.value = $event : null,
            class: "search-input w-full",
            name: "search-text"
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<ul class="w-full h-full!p-0">`);
        if (unref(listIndex) > 0) {
          _push(`<li class="text-gray-600 p-3">`);
          _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "arrow-right"] }, null, _parent));
          _push(`</li>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--[-->`);
        ssrRenderList(unref(listItems)[unref(listIndex)], (item) => {
          var _a, _b, _c, _d, _e, _f;
          _push(`<!--[-->`);
          if (item[(_a = _ctx.config.itemText) != null ? _a : "title"].toString().indexOf(unref(searchText)) >= 0) {
            _push(`<li class="${ssrRenderClass([{ "active": model.value == item[(_b = _ctx.config.itemValue) != null ? _b : "value"] }, "py-3 px-6 lg:p-3 flex justify-between items-center cursor-pointer"])}"><div class="flex items-center"><span>${ssrInterpolate(_ctx.$replaceEnNumber(item[(_c = _ctx.config.itemText) != null ? _c : "title"]))}</span></div>`);
            if (_ctx.config.multiSelect && model.value[item[(_d = _ctx.config.itemValue) != null ? _d : "value"]]) {
              _push(`<div>`);
              _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "check"] }, null, _parent));
              _push(`</div>`);
            } else {
              _push(`<!---->`);
            }
            if (item[(_e = _ctx.config.itemValue) != null ? _e : "value"] && unref(getItemsList)(item[(_f = _ctx.config.itemValue) != null ? _f : "value"]).length > 0) {
              _push(ssrRenderComponent(_component_fa_icon, {
                icon: ["fas", "angle-left"],
                onClick: ($event) => unref(showChildList)(item)
              }, null, _parent));
            } else {
              _push(`<!---->`);
            }
            _push(`</li>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></ul></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/select/ListView.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "ModalList",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    config: {},
    show: { type: Boolean }
  }, {
    "modelValue": {},
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const model = useModel(__props, "modelValue");
    const theme = useState("theme");
    const boxRef = ref(null);
    const props = __props;
    watch(() => props.show, () => {
      var _a, _b;
      if (props.show) {
        (_a = boxRef.value) == null ? void 0 : _a.show();
      } else {
        (_b = boxRef.value) == null ? void 0 : _b.hide();
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormSelectListView = _sfc_main$2;
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$i : _sfc_main$o), mergeProps({
        ref_key: "boxRef",
        ref: boxRef,
        direction: "bottom",
        "content-class": "w-full bottom-0 " + (_ctx.config.items.length > 10 ? "!h-full" : "!h-auto"),
        afterClose: _ctx.config.afterClose,
        title: _ctx.config.label,
        class: "text-[14px]"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_FormSelectListView, {
              config: _ctx.config,
              modelValue: model.value,
              "onUpdate:modelValue": ($event) => model.value = $event
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_FormSelectListView, {
                config: _ctx.config,
                modelValue: model.value,
                "onUpdate:modelValue": ($event) => model.value = $event
              }, null, 8, ["config", "modelValue", "onUpdate:modelValue"])
            ];
          }
        }),
        _: 1
      }), _parent);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/select/ModalList.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
function useSelectTag(props, model) {
  const { error } = input(props, model);
  const theme = useState("theme");
  const showList = ref(false);
  const text = ref(null);
  const selectIcon = ref(null);
  const icon = ref(null);
  const addRule = inject("addRule");
  inject("removeRule");
  const selectViewBox = ref(null);
  const findItemWithValue = (value) => {
    return props.items.find((item) => {
      var _a;
      return item[(_a = props.itemValue) != null ? _a : "value"] == value;
    }) || null;
  };
  const selectItem = (item) => {
    var _a, _b, _c, _d, _e, _f;
    if (props.multiSelect) {
      model.value[item[(_a = props.itemValue) != null ? _a : "value"]] = !model.value[item[(_b = props.itemValue) != null ? _b : "value"]];
      if (!model.value[item[(_c = props.itemValue) != null ? _c : "value"]]) {
        delete model.value[item[(_d = props.itemValue) != null ? _d : "value"]];
      }
    } else {
      model.value = item[(_e = props.itemValue) != null ? _e : "value"];
      text.value = item[(_f = props.itemText) != null ? _f : "title"];
      showList.value = false;
    }
    icon.value = item.icon || null;
  };
  const toggleList = () => {
    if (!props.disable) {
      showList.value = !showList.value;
      if (selectIcon.value) {
        selectIcon.value.$el.style.transform = showList.value ? "rotate(180deg)" : "rotate(0deg)";
      }
    }
  };
  const removeMultiSelectedItem = (key) => {
    delete model.value[key];
  };
  const afterClose = () => {
    showList.value = false;
    selectIcon.value.$el.style.transform = showList.value ? "rotate(180deg)" : "rotate(0deg)";
  };
  watch(
    () => props.items,
    () => {
      if (model.value) {
        const item = findItemWithValue(model.value);
        if (item) selectItem(item);
      }
    }
  );
  watch(
    () => model.value,
    () => {
      const item = findItemWithValue(model.value);
      if (item) selectItem(item);
    }
  );
  return {
    error,
    text,
    selectIcon,
    icon,
    addRule,
    theme,
    showList,
    selectViewBox,
    afterClose,
    findItemWithValue,
    removeMultiSelectedItem,
    selectItem,
    toggleList
  };
}
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SelectTag",
  __ssrInlineRender: true,
  props: /* @__PURE__ */ mergeModels({
    name: {},
    rules: {},
    disable: { type: Boolean },
    label: {},
    items: {},
    itemText: {},
    itemValue: {},
    hideLabel: { type: Boolean },
    nestedProperty: {},
    placeholder: {},
    multiSelect: { type: Boolean },
    useModal: { type: Boolean }
  }, {
    "modelValue": {},
    "modelModifiers": {}
  }),
  emits: ["update:modelValue"],
  setup(__props) {
    const props = __props;
    const model = useModel(__props, "modelValue");
    if (!model.value) {
      model.value = "";
    }
    const {
      theme,
      showList,
      text,
      selectIcon,
      error,
      selectViewBox,
      removeMultiSelectedItem,
      selectItem,
      findItemWithValue,
      afterClose
    } = useSelectTag(props, model);
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_FormSelectListView = _sfc_main$2;
      const _component_FormSelectModalList = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: ["select-tag input-box relative base-space", { "disable": _ctx.disable }],
        ref_key: "selectViewBox",
        ref: selectViewBox
      }, _attrs))}>`);
      if (!_ctx.hideLabel) {
        _push(`<label>${ssrInterpolate(_ctx.label)}</label>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([{ "error-border": unref(error) }, "input form-control flex items-center cursor-pointer justify-between"])}">`);
      if (!_ctx.multiSelect) {
        _push(`<div class="text-sm">${ssrInterpolate(!unref(text) && _ctx.placeholder ? _ctx.placeholder : _ctx.$replaceEnNumber((_a = unref(text)) != null ? _a : ""))}</div>`);
      } else {
        _push(`<div class="flex h-full items-center"><!--[-->`);
        ssrRenderList(model.value, (value, key, index) => {
          var _a2;
          _push(`<!--[-->`);
          if (index < 3) {
            _push(`<div class="bg-gray-200 rounded-lg mx-2 p-2 text-xs">`);
            if (value && unref(findItemWithValue)(key)) {
              _push(`<span>${ssrInterpolate(unref(findItemWithValue)(key)[(_a2 = _ctx.itemText) != null ? _a2 : "title"])}</span>`);
            } else {
              _push(`<!---->`);
            }
            _push(ssrRenderComponent(_component_fa_icon, {
              icon: ["fas", "close"],
              class: "pr-2",
              onClick: ($event) => unref(removeMultiSelectedItem)(key)
            }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></div>`);
      }
      _push(ssrRenderComponent(_component_fa_icon, {
        ref_key: "selectIcon",
        ref: selectIcon,
        icon: ["fas", "angle-down"]
      }, null, _parent));
      _push(`</div>`);
      if (unref(theme) === "desktop" && !_ctx.useModal) {
        _push(`<!--[-->`);
        if (unref(showList) && !_ctx.disable) {
          _push(`<div class="item-list w-full mt-1.5" style="${ssrRenderStyle({ "width": "calc(100% - 15px)" })}">`);
          _push(ssrRenderComponent(_component_FormSelectListView, {
            class: "my-1.5",
            modelValue: model.value,
            "onUpdate:modelValue": ($event) => model.value = $event,
            config: { ...props, ...{ "selectItem": unref(selectItem) } }
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(ssrRenderComponent(_component_FormSelectModalList, {
          show: unref(showList),
          modelValue: model.value,
          "onUpdate:modelValue": ($event) => model.value = $event,
          config: {
            ...props,
            ...{ "selectItem": unref(selectItem), "afterClose": unref(afterClose) }
          }
        }, null, _parent));
      }
      if (unref(error) !== false) {
        _push(`<div class="text-red-500 text-[14px] py-1">${ssrInterpolate(unref(error))}</div>`);
      } else {
        _push(`<!---->`);
      }
      if (_ctx.name) {
        _push(`<input type="hidden"${ssrRenderAttr("name", _ctx.name)} class="c-input"${ssrRenderAttr("value", model.value)}>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/SelectTag.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=SelectTag-Cc2QTMT4.mjs.map
