import { defineComponent, resolveComponent, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import { u as useState } from './server.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "SendDetail",
  __ssrInlineRender: true,
  props: {
    variation: {}
  },
  setup(__props) {
    const shopSetting = useState("shopSetting");
    return (_ctx, _push, _parent, _attrs) => {
      const _component_fa_icon = resolveComponent("fa-icon");
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "px-3 flex items-center" }, _attrs))}>`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "truck-moving"],
        class: "text-black"
      }, null, _parent));
      _push(`<div class="text-xs px-1.5"><span> \u0627\u0631\u0633\u0627\u0644 \u062A\u0648\u0633\u0637 </span>`);
      if (_ctx.variation.sender == "self") {
        _push(`<span>${ssrInterpolate(unref(shopSetting).name)}</span>`);
      } else {
        _push(`<span>\u0641\u0631\u0648\u0634\u0646\u062F\u0647</span>`);
      }
      if (_ctx.variation.preparation_time > 0) {
        _push(`<span> \u0627\u0632 ${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.variation.preparation_time))} \u0631\u0648\u0632 \u06A9\u0627\u0631\u06CC \u0622\u06CC\u0646\u062F\u0647 </span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/priceVariation/SendDetail.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=SendDetail-CCtW5pOV.mjs.map
