import { _ as _sfc_main$4 } from './List-2tRGzJIt.mjs';
import { u as useState, m as useFetch, c as useNuxtApp, e as useRoute, i as _export_sfc, b as useRuntimeConfig } from './server.mjs';
import { defineComponent, withAsyncContext, unref, withCtx, createVNode, resolveDynamicComponent, createBlock, createCommentVNode, openBlock, Fragment, renderList, renderSlot, watch, resolveComponent, mergeProps, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderVNode, ssrRenderSlot, ssrInterpolate, ssrRenderClass, ssrRenderAttr } from 'vue/server-renderer';
import { _ as _sfc_main$5 } from './ProductView-CNzvSvNo.mjs';
import { _ as _sfc_main$6 } from './ProductLoading-DIaXfK3g.mjs';
import { s as searchStore } from './search-products-xw_89Bg_.mjs';
import { u as useHead } from './v3-CqizLg04.mjs';

const _sfc_main$3 = {};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs) {
  const _component_fa_icon = resolveComponent("fa-icon");
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex flex-col items-center w-full py-10" }, _attrs))}><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.appUrl + "/images/not-found.svg")} alt=""><div class="border rounded-md text-center px-5 py-6 my-5 lg:w-[400px]"><div>`);
  _push(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "circle-info"] }, null, _parent));
  _push(`<span class="pr-1"> \u06A9\u0627\u0644\u0627\u06CC\u06CC \u0628\u0627 \u0627\u06CC\u0646 \u0645\u0634\u062E\u0635\u0627\u062A \u067E\u06CC\u062F\u0627 \u0646\u06A9\u0631\u062F\u06CC\u0645 </span></div><p class="text-gray-500 mt-3"> \u067E\u06CC\u0634\u0646\u0647\u0627\u062F \u0645\u06CC\u200C\u06A9\u0646\u06CC\u0645 \u0641\u06CC\u0644\u062A\u0631\u0647\u0627 \u0631\u0627 \u062A\u063A\u06CC\u06CC\u0631 \u062F\u0647\u06CC\u062F </p></div></div>`);
}
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/search/NotFound.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["ssrRender", _sfc_ssrRender]]);
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "SearchProducts",
  __ssrInlineRender: true,
  props: {
    category: {},
    result: {},
    status: {}
  },
  setup(__props) {
    const props = __props;
    const store = searchStore();
    if (props.result) {
      store.updateResult(props.result);
      store.status = "success";
    }
    watch(() => props.result, () => {
      store.updateResult(props.result);
      store.status = "success";
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FiltersList = _sfc_main$4;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_ThemeSearchNotFound = __nuxt_component_0;
      const _component_ThemeSearchProductView = _sfc_main$5;
      const _component_ThemeSearchProductLoading = _sfc_main$6;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "search-products" }, _attrs))}>`);
      ssrRenderSlot(_ctx.$slots, "before", {}, null, _push, _parent);
      _push(`<div>`);
      if (_ctx.category) {
        _push(`<p class="text-xl font-bold">${ssrInterpolate(_ctx.category.name)}</p>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex py-5 relative items-start"><div class="flex flex-col sidebar">`);
      ssrRenderSlot(_ctx.$slots, "before-sidebar", {}, null, _push, _parent);
      _push(`<div class="border rounded-md py-4"><div class="px-4 flex justify-between"><span class="font-bold">\u0641\u06CC\u0644\u062A\u0631\u0647\u0627</span>`);
      if (Object.keys(unref(store).queries).length > 0) {
        _push(`<span class="cursor-pointer text-xs text-blue-400"> \u062D\u0630\u0641 \u0641\u06CC\u0644\u062A\u0631 \u0647\u0627 </span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      _push(ssrRenderComponent(_component_FiltersList, {
        category_id: _ctx.category ? _ctx.category.id : 0
      }, null, _parent));
      _push(`</div></div><div class="flex-grow w-full"><div class="flex justify-between border-b pb-3"><div class="flex items-center">`);
      _push(ssrRenderComponent(_component_fa_icon, {
        icon: ["fas", "arrow-down-wide-short"],
        class: "px-3"
      }, null, _parent));
      _push(`<span class="text-black">\u0645\u0631\u062A\u0628 \u0633\u0627\u0632\u06CC:</span><ul class="sort-items ma-0"><!--[-->`);
      ssrRenderList(unref(store).sortItems, (item) => {
        _push(`<li><span class="${ssrRenderClass([item.value == unref(store).queries["orderBy"] ? "active" : ""])}">${ssrInterpolate(item.title)}</span></li>`);
      });
      _push(`<!--]--></ul></div>`);
      if (unref(store).result && unref(store).result.products) {
        _push(`<span class="text-gray-400">${ssrInterpolate(_ctx.$replaceEnNumber(unref(store).result.products.total))} \u06A9\u0627\u0644\u0627 </span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (unref(store).result.products && unref(store).result.products.data.length == 0 && unref(store).status != "pending") {
        _push(ssrRenderComponent(_component_ThemeSearchNotFound, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="products-list">`);
      if (unref(store).result && unref(store).result.products) {
        _push(`<!--[-->`);
        ssrRenderList(unref(store).result.products.data, (product) => {
          _push(ssrRenderComponent(_component_ThemeSearchProductView, {
            product,
            key: product.id
          }, null, _parent));
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (unref(store).status == "pending" || _ctx.status == "pending") {
        _push(ssrRenderComponent(_component_ThemeSearchProductLoading, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="load-more py-10"></div>`);
      ssrRenderSlot(_ctx.$slots, "after-products", {}, null, _push, _parent);
      _push(`</div></div></div></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/desktop/SearchProducts.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "SearchProducts",
  __ssrInlineRender: true,
  props: {
    category: {},
    result: {},
    status: {}
  },
  setup(__props) {
    const props = __props;
    const store = searchStore();
    const theme = useState("theme");
    if (props.result) {
      store.updateResult(props.result);
      store.status = "success";
    }
    watch(() => props.result, () => {
      store.updateResult(props.result);
      store.status = "success";
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeSearchNotFound = __nuxt_component_0;
      const _component_ThemeSearchProductView = _sfc_main$5;
      const _component_ThemeSearchProductLoading = _sfc_main$6;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "search-products" }, _attrs))}>`);
      ssrRenderSlot(_ctx.$slots, "before", {}, null, _push, _parent);
      if (unref(store).result.products && unref(store).result.products.data.length == 0 && unref(store).status != "pending") {
        _push(ssrRenderComponent(_component_ThemeSearchNotFound, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([{ "grid grid-cols-2 md:grid-cols-3": unref(theme) != "mobile" }, "products-list"])}">`);
      if (unref(store).result && unref(store).result.products) {
        _push(`<!--[-->`);
        ssrRenderList(unref(store).result.products.data, (product) => {
          _push(ssrRenderComponent(_component_ThemeSearchProductView, {
            product,
            key: product.id
          }, null, _parent));
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (unref(store).status == "pending" || _ctx.status == "pending") {
        _push(ssrRenderComponent(_component_ThemeSearchProductLoading, null, null, _parent));
      } else {
        _push(`<!---->`);
      }
      ssrRenderSlot(_ctx.$slots, "after-products", {}, null, _push, _parent);
      _push(`</div><div class="load-more py-10"></div></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/mobile/SearchProducts.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
function useSearchProducts() {
  const global = useNuxtApp().vueApp.config.globalProperties;
  const theme = useState("theme");
  const searchState = searchStore();
  searchState.updateResult({});
  searchState.setDefaultQueries();
  let afterProductContents = global["$products-search:after-list"];
  afterProductContents = global.$sort(afterProductContents, "index");
  let beforeSidebar = global["$products-search:before-sidebar"];
  beforeSidebar = global.$sort(beforeSidebar, "index");
  watch(() => useRoute().query["q"], () => {
    searchState.setDefaultQueries();
    searchState.updateResult({});
    searchState.loadMoreProducts();
  });
  watch(() => searchState.queries, () => {
    if (searchState.result.products) {
      searchState.reset();
      searchState.loadMoreProducts();
    }
  }, { deep: true });
  return {
    theme,
    afterProductContents,
    searchState,
    beforeSidebar
  };
}
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "View",
  __ssrInlineRender: true,
  props: {
    category: {},
    requestUrl: {}
  },
  async setup(__props) {
    var _a;
    let __temp, __restore;
    const props = __props;
    const shopSetting = useState("shopSetting");
    const {
      theme,
      afterProductContents,
      beforeSidebar,
      searchState
    } = useSearchProducts();
    searchState.updateRequestUrl(props.requestUrl);
    const { data: result, status } = ([__temp, __restore] = withAsyncContext(() => useFetch(
      searchState.getSearchUrl(),
      {
        server: true,
        lazy: false
      },
      "$lCb43B8zXy"
    )), __temp = await __temp, __restore(), __temp);
    let meta = [];
    if (result.value && result.value.seo) {
      meta.push({
        name: "description",
        content: result.value.seo.description
      });
      meta.push({
        name: "keywords",
        content: result.value.seo.keywords
      });
    }
    useHead({
      title: props.category ? `\u0645\u062D\u0635\u0648\u0644\u0627\u062A ${props.category.name}` : (_a = shopSetting.value) == null ? void 0 : _a.name,
      meta
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ThemeDesktopSearchProducts = _sfc_main$2;
      const _component_ThemeMobileSearchProducts = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_ThemeDesktopSearchProducts, {
          category: _ctx.category,
          result: unref(result),
          status: unref(status)
        }, {
          before: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              ssrRenderSlot(_ctx.$slots, "before", {}, null, _push2, _parent2, _scopeId);
            } else {
              return [
                renderSlot(_ctx.$slots, "before")
              ];
            }
          }),
          "after-products": withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(afterProductContents)) {
                _push2(`<!--[-->`);
                ssrRenderList(unref(afterProductContents), (row) => {
                  ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(row.component), { category: _ctx.category }, null), _parent2, _scopeId);
                });
                _push2(`<!--]-->`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                unref(afterProductContents) ? (openBlock(true), createBlock(Fragment, { key: 0 }, renderList(unref(afterProductContents), (row) => {
                  return openBlock(), createBlock(resolveDynamicComponent(row.component), { category: _ctx.category }, null, 8, ["category"]);
                }), 256)) : createCommentVNode("", true)
              ];
            }
          }),
          "before-sidebar": withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(beforeSidebar)) {
                _push2(`<!--[-->`);
                ssrRenderList(unref(beforeSidebar), (row) => {
                  ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(row.component), { category: _ctx.category }, null), _parent2, _scopeId);
                });
                _push2(`<!--]-->`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                unref(beforeSidebar) ? (openBlock(true), createBlock(Fragment, { key: 0 }, renderList(unref(beforeSidebar), (row) => {
                  return openBlock(), createBlock(resolveDynamicComponent(row.component), { category: _ctx.category }, null, 8, ["category"]);
                }), 256)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 3
        }, _parent));
      } else {
        _push(ssrRenderComponent(_component_ThemeMobileSearchProducts, {
          category: _ctx.category,
          result: unref(result),
          status: unref(status)
        }, {
          before: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              ssrRenderSlot(_ctx.$slots, "before", {}, null, _push2, _parent2, _scopeId);
            } else {
              return [
                renderSlot(_ctx.$slots, "before")
              ];
            }
          }),
          "after-products": withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(afterProductContents)) {
                _push2(`<!--[-->`);
                ssrRenderList(unref(afterProductContents), (row) => {
                  ssrRenderVNode(_push2, createVNode(resolveDynamicComponent(row.component), null, null), _parent2, _scopeId);
                });
                _push2(`<!--]-->`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                unref(afterProductContents) ? (openBlock(true), createBlock(Fragment, { key: 0 }, renderList(unref(afterProductContents), (row) => {
                  return openBlock(), createBlock(resolveDynamicComponent(row.component));
                }), 256)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 3
        }, _parent));
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/search/View.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=View-DJhaXJ-z.mjs.map
