import { g as __nuxt_component_0$2, u as useState, b as useRuntimeConfig } from './server.mjs';
import { defineComponent, mergeProps, withCtx, createTextVNode, createVNode, resolveDynamicComponent, unref, createBlock, createCommentVNode, openBlock, toDisplayString, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderSlot, ssrRenderList, ssrRenderVNode, ssrRenderAttr } from 'vue/server-renderer';
import { _ as __nuxt_component_3 } from './Skeleton-B5XQTW8R.mjs';
import { _ as _sfc_main$5 } from './VerticalView-mV-jyVNN.mjs';

const _sfc_main$4 = /* @__PURE__ */ defineComponent({
  __name: "HorizontalView",
  __ssrInlineRender: true,
  props: {
    product: {},
    index: {}
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_Skeleton = __nuxt_component_3;
      _push(ssrRenderComponent(_component_nuxt_link, mergeProps({
        class: "product horizontal-view",
        to: _ctx.$getProductPath(_ctx.product)
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="image-box"${_scopeId}>`);
            if (_ctx.product) {
              _push2(`<img${ssrRenderAttr("alt", _ctx.product.title)}${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + _ctx.product.image)} class="image"${_scopeId}>`);
            } else {
              _push2(ssrRenderComponent(_component_Skeleton, { class: "image m-2" }, null, _parent2, _scopeId));
            }
            _push2(`</div>`);
            if (_ctx.product) {
              _push2(`<span class="text-blue-400 mx-3 num"${_scopeId}>${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.index))}</span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="w-full title-box"${_scopeId}>`);
            if (_ctx.product != null) {
              _push2(`<span class="title-twl product-title"${_scopeId}>${ssrInterpolate(_ctx.product.title)}</span>`);
            } else {
              _push2(ssrRenderComponent(_component_Skeleton, { class: "h-3 w-full" }, null, _parent2, _scopeId));
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "image-box" }, [
                _ctx.product ? (openBlock(), createBlock("img", {
                  key: 0,
                  alt: _ctx.product.title,
                  src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + _ctx.product.image,
                  class: "image"
                }, null, 8, ["alt", "src"])) : (openBlock(), createBlock(_component_Skeleton, {
                  key: 1,
                  class: "image m-2"
                }))
              ]),
              _ctx.product ? (openBlock(), createBlock("span", {
                key: 0,
                class: "text-blue-400 mx-3 num"
              }, toDisplayString(_ctx.$replaceEnNumber(_ctx.index)), 1)) : createCommentVNode("", true),
              createVNode("div", { class: "w-full title-box" }, [
                _ctx.product != null ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "title-twl product-title"
                }, toDisplayString(_ctx.product.title), 1)) : (openBlock(), createBlock(_component_Skeleton, {
                  key: 1,
                  class: "h-3 w-full"
                }))
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
});
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/product-slider/HorizontalView.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const _sfc_main$3 = /* @__PURE__ */ defineComponent({
  __name: "GridList",
  __ssrInlineRender: true,
  props: {
    loading: { type: Boolean },
    products: {},
    theme: {}
  },
  setup(__props) {
    const theme = useState("theme");
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "product-grid-list lg:gap-2" }, _attrs))}>`);
      if (!_ctx.loading) {
        _push(`<!--[-->`);
        ssrRenderList(_ctx.products, (product, key) => {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "horizontal-view" ? _sfc_main$4 : _sfc_main$5), {
            product,
            index: key + 1,
            loading: _ctx.loading
          }, null), _parent);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!--[-->`);
        ssrRenderList(10, (i) => {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "horizontal-view" ? _sfc_main$4 : _sfc_main$5), {
            product: null,
            index: i,
            loading: _ctx.loading
          }, null), _parent);
        });
        _push(`<!--]-->`);
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/product-slider/GridList.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "HorizontalList",
  __ssrInlineRender: true,
  props: {
    loading: { type: Boolean },
    products: {},
    theme: {},
    slideSpace: {},
    breakpoints: {}
  },
  setup(__props) {
    const theme = useState("theme");
    const injectStyles = [
      `.swiper-button-next,
     .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:35px;
      height:35px;
      border:1px solid #dedede;
   }
   .swiper-button-next svg,
   .swiper-button-prev svg {
      width:20px;
      height:20px;
      color:black;
  }`
    ];
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b;
      _push(`<swiper-container${ssrRenderAttrs(mergeProps({
        navigation: unref(theme) == "desktop",
        injectStyles,
        class: "products-horizontal-slider",
        "space-between": (_a = _ctx.slideSpace) != null ? _a : 0,
        breakpoints: (_b = _ctx.breakpoints) != null ? _b : {
          380: { slidesPerView: 2 },
          768: { slidesPerView: 3 },
          1024: { slidesPerView: 4 },
          1280: { slidesPerView: 5 }
        }
      }, _attrs), "swiper-container")}>`);
      if (!_ctx.loading) {
        _push(`<!--[-->`);
        ssrRenderList(_ctx.products, (product, index) => {
          _push(`<swiper-slide class="w-auto h-auto flex justify-items-stretch">`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "horizontal-view" ? _sfc_main$4 : _sfc_main$5), {
            product,
            index,
            loading: _ctx.loading
          }, null), _parent);
          _push(`</swiper-slide>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!--[-->`);
        ssrRenderList(10, (i) => {
          _push(`<swiper-slide>`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "horizontal-view" ? _sfc_main$4 : _sfc_main$5), {
            product: null,
            index: i,
            loading: _ctx.loading
          }, null), _parent);
          _push(`</swiper-slide>`);
        });
        _push(`<!--]-->`);
      }
      _push(`</swiper-container>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/product-slider/HorizontalList.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "MultiRow",
  __ssrInlineRender: true,
  props: {
    loading: { type: Boolean },
    products: {},
    theme: {},
    slideSpace: {},
    row: {},
    column: {}
  },
  setup(__props) {
    const getProductKey = (column, n) => {
      let number = column - 1 + n + (column - 1);
      if (column > 1) {
        number = number + (column - 1);
      }
      return number;
    };
    const injectStyles = [
      `.swiper-button-next,
  .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:35px;
      height:35px;
      border:1px solid #dedede;
  }
  .swiper-button-next svg,
  .swiper-button-prev svg {
     width:20px;
     height:20px;
     color:black;
  }`
    ];
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<swiper-container${ssrRenderAttrs(mergeProps({
        class: "products-horizontal-slider",
        navigation: true,
        "slides-per-view": _ctx.column,
        injectStyles
      }, _attrs), "swiper-container")}>`);
      if (!_ctx.loading) {
        _push(`<!--[-->`);
        ssrRenderList(Math.ceil(_ctx.products.length / parseInt(_ctx.row)), (index) => {
          _push(`<swiper-slide><!--[-->`);
          ssrRenderList(parseInt(_ctx.row), (n) => {
            _push(`<!--[-->`);
            if (_ctx.products[getProductKey(index, n) - 1]) {
              ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.theme == "horizontal-view" ? _sfc_main$4 : _sfc_main$5), {
                product: _ctx.products[getProductKey(index, n) - 1],
                index: getProductKey(index, n),
                loading: _ctx.loading
              }, null), _parent);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          });
          _push(`<!--]--></swiper-slide>`);
        });
        _push(`<!--]-->`);
      } else if (_ctx.row) {
        _push(`<!--[-->`);
        ssrRenderList(Math.ceil(10 / parseInt(_ctx.row)), (index) => {
          _push(`<swiper-slide><!--[-->`);
          ssrRenderList(parseInt(_ctx.row), (n) => {
            ssrRenderVNode(_push, createVNode(resolveDynamicComponent(_ctx.theme == "horizontal-view" ? _sfc_main$4 : _sfc_main$5), {
              product: null,
              index: getProductKey(index, n),
              loading: _ctx.loading
            }, null), _parent);
          });
          _push(`<!--]--></swiper-slide>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</swiper-container>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/product-slider/MultiRow.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "View",
  __ssrInlineRender: true,
  props: {
    title: {},
    row: {},
    column: {},
    theme: {},
    slideSpace: {},
    products: {},
    hideMoreLink: { type: Boolean },
    loading: { type: Boolean }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_ThemeProductSliderGridList = _sfc_main$3;
      const _component_ThemeProductSliderHorizontalList = _sfc_main$2;
      const _component_ThemeProductSliderMultiRow = _sfc_main$1;
      if (_ctx.loading || ((_a = _ctx.products) == null ? void 0 : _a.length) > 0) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "products-list" }, _attrs))}>`);
        if (_ctx.title) {
          _push(`<div class="flex items-center justify-between"><div><h5 class="title font-bold py-4">${ssrInterpolate(_ctx.title)}</h5><div class="title-line"></div></div>`);
          if (!_ctx.hideMoreLink) {
            _push(ssrRenderComponent(_component_nuxt_link, {
              to: "/",
              class: "text-red-500"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(` \u0645\u0634\u0627\u0647\u062F\u0647 \u0647\u0645\u0647 `);
                } else {
                  return [
                    createTextVNode(" \u0645\u0634\u0627\u0647\u062F\u0647 \u0647\u0645\u0647 ")
                  ];
                }
              }),
              _: 1
            }, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        ssrRenderSlot(_ctx.$slots, "header", {}, null, _push, _parent);
        if (_ctx.row == "n" && _ctx.column == "n") {
          _push(ssrRenderComponent(_component_ThemeProductSliderGridList, {
            loading: _ctx.loading,
            products: _ctx.products,
            theme: _ctx.theme
          }, null, _parent));
        } else if (_ctx.row == "1" && _ctx.column == "n") {
          _push(ssrRenderComponent(_component_ThemeProductSliderHorizontalList, {
            loading: _ctx.loading,
            products: _ctx.products,
            theme: _ctx.theme,
            slideSpace: _ctx.slideSpace,
            class: "mt-5"
          }, null, _parent));
        } else {
          _push(ssrRenderComponent(_component_ThemeProductSliderMultiRow, {
            loading: _ctx.loading,
            products: _ctx.products,
            row: _ctx.row,
            theme: _ctx.theme,
            column: _ctx.column
          }, null, _parent));
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/theme/product-slider/View.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=View-Sprhesqe.mjs.map
