import { b as _sfc_main$1, _ as _sfc_main$2, a as _sfc_main$3 } from './PopularQuestion-pEC7Yvxp.mjs';
import { e as useRoute, c as useNuxtApp, m as useFetch, b as useRuntimeConfig } from './server.mjs';
import { defineComponent, ref, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderAttr, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import './Skeleton-B5XQTW8R.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "[id]",
  __ssrInlineRender: true,
  setup(__props) {
    const categoryId = useRoute().params["id"];
    const nuxtApp = useNuxtApp();
    const category = ref(null);
    const findCategory = (categories) => {
      category.value = categories.find((row) => row.id == categoryId);
    };
    const { data: questions } = useFetch(
      useRuntimeConfig().public.api + "/faq/questions?category_id=".categoryId,
      {
        key: "faq-questions-" + categoryId,
        getCachedData(key) {
          return nuxtApp.payload.data[key] || nuxtApp.static.data[key];
        }
      },
      "$1eLgpq2pTA"
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FaqQuestionsList = _sfc_main$1;
      const _component_FaqCategories = _sfc_main$2;
      const _component_FaqPopularQuestion = _sfc_main$3;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "faq" }, _attrs))}><div class="header"><div class="cover">`);
      if (unref(category)) {
        _push(`<div class="rounded-full bg-white p-4"><img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.staticServerUrl + "/images/" + unref(category).icon)} class="w-8"${ssrRenderAttr("alt", unref(category).name)}></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(category)) {
        _push(`<h5 class="font-bold py-3">${ssrInterpolate(unref(category).name)}</h5>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="content">`);
      if (unref(questions)) {
        _push(ssrRenderComponent(_component_FaqQuestionsList, {
          questions: unref(questions),
          class: "my-10"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_FaqCategories, { "get-categories": findCategory }, null, _parent));
      _push(ssrRenderComponent(_component_FaqPopularQuestion, null, null, _parent));
      _push(`</div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/faq/category/[id].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=_id_-BBkYCaiD.mjs.map
