import { _ as _sfc_main$1 } from './PositionView-ByKT-amv.mjs';
import { defineComponent, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent } from 'vue/server-renderer';
import { u as useState, b as useRuntimeConfig } from './server.mjs';
import { u as useHead } from './v3-CqizLg04.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';
import '../routes/renderer.mjs';
import 'vue-bundle-renderer/runtime';
import 'unhead/server';
import 'devalue';
import 'unhead/utils';
import 'unhead/plugins';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const shopSetting = useState("shopSetting");
    const { appUrl, serverUrl } = useRuntimeConfig().public;
    useHead({
      title: "\u0641\u0631\u0648\u0634\u06AF\u0627\u0647 \u0627\u06CC\u0646\u062A\u0631\u0646\u062A\u06CC " + shopSetting.value.name,
      meta: [
        {
          name: "description",
          content: shopSetting.value.description
        },
        {
          name: "keywords",
          content: shopSetting.value.tags
        }
      ],
      script: [
        {
          type: "application/ld+json",
          children: JSON.stringify({
            "@context": "https://schema.org",
            "@type": "Organization",
            "name": shopSetting.value.name,
            "url": appUrl,
            "logo": serverUrl + "/" + shopSetting.value.icon,
            "contactPoint": {
              "@type": "ContactPoint",
              "telephone": "+989141592083",
              "contactType": "customer service",
              "areaServed": "IR",
              "availableLanguage": "\u0641\u0627\u0631\u0633\u06CC"
            }
          })
        }
      ]
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_DesignPositionView = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_DesignPositionView, { position: "desktop-index" }, null, _parent));
      } else {
        _push(ssrRenderComponent(_component_DesignPositionView, { position: "mobile-index" }, null, _parent));
      }
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=index-DLFsVDyN.mjs.map
