import { u as useState, e as useRoute, g as __nuxt_component_0$2, b as useRuntimeConfig, o as _sfc_main$c, m as useFetch, c as useNuxtApp, j as useRouter, _ as _sfc_main$i, a as _sfc_main$o, n as navigateTo } from './server.mjs';
import { _ as _sfc_main$3 } from './SelectVariationBtn-nIKCeOxT.mjs';
import { _ as _sfc_main$4 } from './TextInput-BtVMT3NE.mjs';
import { _ as _sfc_main$5 } from './VerticalView-mV-jyVNN.mjs';
import { defineComponent, ref, watch, mergeProps, unref, resolveComponent, withCtx, createVNode, createBlock, createCommentVNode, openBlock, withModifiers, toDisplayString, resolveDynamicComponent, isRef, createTextVNode, Fragment, renderList, nextTick, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderClass, ssrRenderStyle, ssrRenderAttr, ssrRenderVNode } from 'vue/server-renderer';

function comparison() {
  const data = ref([]);
  const characteristicsId = ref({});
  const page = ref(1);
  const endLoaded = ref(false);
  const products = ref({ data: [] });
  const sendRequest = ref(false);
  const category_id = ref(0);
  const getComparisonData = async (arrayId) => {
    if (!arrayId.length) return;
    const query = arrayId.map((id, i) => `product_id[${i}]=${id}`).join("&");
    const { data: result, error } = await useFetch(`${useRuntimeConfig().public.api}/product/compare?${query}`, "$0FEREfMpJg");
    if (!error.value && result.value) {
      data.value = result.value;
      result.value.forEach(({ specifications }) => updateCharacteristicsId(specifications));
    }
  };
  const updateCharacteristicsId = (specifications) => {
    const objectId = Object.keys(specifications).reduce((acc, key) => {
      acc[+key] = { id: key, ...specifications[key] };
      return acc;
    }, {});
    characteristicsId.value = { ...characteristicsId.value, ...objectId };
  };
  const scroll = () => {
    const loadMore = (void 0).querySelector(".load-more");
    if (loadMore) {
      const observer = new IntersectionObserver(
        ([entry]) => {
          if (entry.isIntersecting && !sendRequest.value && !endLoaded.value) {
            page.value++;
            searchProducts(category_id.value);
          }
        },
        { threshold: 0.6 }
      );
      observer.observe(loadMore);
    }
  };
  const searchProducts = async (catId) => {
    if (sendRequest.value) return;
    sendRequest.value = true;
    category_id.value = catId;
    try {
      const { data: newProducts } = await useNuxtApp().$axios.get(`${useRuntimeConfig().public.api}/site/products?category_id=${catId}&variation=true&page=${page.value}`);
      products.value.data = products.value.data.concat(newProducts.data);
      if (newProducts.data.length < 15) endLoaded.value = true;
    } finally {
      sendRequest.value = false;
    }
  };
  return {
    characteristicsId,
    data,
    products,
    sendRequest,
    scroll,
    searchProducts,
    getComparisonData
  };
}
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "SelectionProducts",
  __ssrInlineRender: true,
  props: {
    category_id: {}
  },
  setup(__props, { expose: __expose }) {
    const props = __props;
    const {
      products,
      scroll,
      sendRequest,
      searchProducts
    } = comparison();
    const theme = useState("theme");
    const boxRef = ref(null);
    const searchText = ref(null);
    let bodyEl = ".comparison-box .modal .body";
    const show = () => {
      if (products.value.data.length == 0) {
        searchProducts(props.category_id);
      }
      boxRef.value.show();
      nextTick(() => {
        var _a;
        (_a = (void 0).querySelector(bodyEl)) == null ? void 0 : _a.addEventListener("scroll", scroll);
      });
    };
    const addProductToComparisonList = (productId) => {
      if ((void 0).location.href.toString().indexOf("/" + productId) == -1) {
        const route = ((void 0).location.href + "/" + productId).toString().replace(
          useRuntimeConfig().public.appUrl,
          ""
        );
        navigateTo(route);
        boxRef.value.hide();
      }
    };
    const afterClose = () => {
      var _a;
      (_a = (void 0).querySelector(bodyEl)) == null ? void 0 : _a.removeEventListener("scroll", scroll);
    };
    __expose({
      show
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormTextInput = _sfc_main$4;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_ThemeProductSliderVerticalView = _sfc_main$5;
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(theme) == "desktop" ? _sfc_main$i : _sfc_main$o), mergeProps({
        ref_key: "boxRef",
        ref: boxRef,
        direction: "bottom",
        "content-class": "w-full !h-full bottom-0",
        title: "\u0627\u0646\u062A\u062E\u0627\u0628 \u06A9\u0627\u0644\u0627 \u0628\u0631\u0627\u06CC \u0645\u0642\u0627\u06CC\u0633\u0647",
        "after-close": afterClose
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="w-full px-4"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_FormTextInput, {
              placeholder: "\u062C\u0633\u062A\u062C\u0648\u06CC \u06A9\u0627\u0644\u0627 \u0647\u0627",
              modelValue: unref(searchText),
              "onUpdate:modelValue": ($event) => isRef(searchText) ? searchText.value = $event : null,
              class: "w-full"
            }, {
              perfix: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="flex items-center"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "search"] }, null, _parent3, _scopeId2));
                  _push3(`</div>`);
                } else {
                  return [
                    createVNode("div", { class: "flex items-center" }, [
                      createVNode(_component_fa_icon, { icon: ["fas", "search"] })
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (unref(products).total != void 0) {
              _push2(`<div class="w-full flex justify-between text-sm py-2"${_scopeId}><span${_scopeId}>\u0628\u0631\u062A\u0631\u06CC\u0646 \u06A9\u0627\u0644\u0627\u0647\u0627 \u0628\u0631\u0627\u06CC \u0645\u0642\u0627\u06CC\u0633\u0647</span> ${ssrInterpolate(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(products).total)))} \u06A9\u0627\u0644\u0627 </div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div><div class="${ssrRenderClass([{ "vertical-list": unref(theme) != "desktop" }, "grid lg:grid-cols-2 gap-2 max-md:px-2"])}"${_scopeId}><!--[-->`);
            ssrRenderList(unref(products).data, (product) => {
              _push2(ssrRenderComponent(_component_ThemeProductSliderVerticalView, {
                key: product.id,
                product,
                onClick: ($event) => addProductToComparisonList(product.id)
              }, null, _parent2, _scopeId));
            });
            _push2(`<!--]-->`);
            if (unref(sendRequest)) {
              _push2(`<!--[-->`);
              ssrRenderList(5, (i) => {
                _push2(ssrRenderComponent(_component_ThemeProductSliderVerticalView, {
                  key: i,
                  loading: unref(sendRequest),
                  product: null
                }, null, _parent2, _scopeId));
              });
              _push2(`<!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="load-more py-10"${_scopeId}></div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full px-4" }, [
                createVNode(_component_FormTextInput, {
                  placeholder: "\u062C\u0633\u062A\u062C\u0648\u06CC \u06A9\u0627\u0644\u0627 \u0647\u0627",
                  modelValue: unref(searchText),
                  "onUpdate:modelValue": ($event) => isRef(searchText) ? searchText.value = $event : null,
                  class: "w-full"
                }, {
                  perfix: withCtx(() => [
                    createVNode("div", { class: "flex items-center" }, [
                      createVNode(_component_fa_icon, { icon: ["fas", "search"] })
                    ])
                  ]),
                  _: 1
                }, 8, ["modelValue", "onUpdate:modelValue"]),
                unref(products).total != void 0 ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "w-full flex justify-between text-sm py-2"
                }, [
                  createVNode("span", null, "\u0628\u0631\u062A\u0631\u06CC\u0646 \u06A9\u0627\u0644\u0627\u0647\u0627 \u0628\u0631\u0627\u06CC \u0645\u0642\u0627\u06CC\u0633\u0647"),
                  createTextVNode(" " + toDisplayString(_ctx.$replaceEnNumber(_ctx.$numberFormat(unref(products).total))) + " \u06A9\u0627\u0644\u0627 ", 1)
                ])) : createCommentVNode("", true)
              ]),
              createVNode("div", {
                class: ["grid lg:grid-cols-2 gap-2 max-md:px-2", { "vertical-list": unref(theme) != "desktop" }]
              }, [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(products).data, (product) => {
                  return openBlock(), createBlock(_component_ThemeProductSliderVerticalView, {
                    key: product.id,
                    product,
                    onClick: withModifiers(($event) => addProductToComparisonList(product.id), ["prevent"])
                  }, null, 8, ["product", "onClick"]);
                }), 128)),
                unref(sendRequest) ? (openBlock(), createBlock(Fragment, { key: 0 }, renderList(5, (i) => {
                  return createVNode(_component_ThemeProductSliderVerticalView, {
                    key: i,
                    loading: unref(sendRequest),
                    product: null
                  }, null, 8, ["loading"]);
                }), 64)) : createCommentVNode("", true),
                createVNode("div", { class: "load-more py-10" })
              ], 2)
            ];
          }
        }),
        _: 1
      }), _parent);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comparison/SelectionProducts.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "Products",
  __ssrInlineRender: true,
  props: {
    max: {},
    data: {}
  },
  setup(__props) {
    const props = __props;
    const selectionProductsBox = ref(null);
    const theme = useState("theme");
    const scrollTopValue = ref(0);
    const removeProductOfComparisonList = (id) => {
      let route = (void 0).location.href.toString().replace("/" + id, "").replace(useRuntimeConfig().public.appUrl, "");
      route = route == "/compare" ? "" : route;
      useRouter().push(route);
    };
    const getBoxWidth = () => {
      if (theme.value === "desktop") {
        const max = 4;
        const length = props.data.length;
        return 100 / (length < max ? length + 1 : length);
      }
      return 50;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_nuxt_link = __nuxt_component_0$2;
      const _component_fa_icon = resolveComponent("fa-icon");
      const _component_PriceVariationPriceBox = _sfc_main$c;
      const _component_PriceVariationSelectVariationBtn = _sfc_main$3;
      const _component_ComparisonSelectionProducts = _sfc_main$2;
      _push(`<!--[--><div class="selected-products"><!--[-->`);
      ssrRenderList(_ctx.data, (row, key) => {
        _push(`<div class="${ssrRenderClass([{ "border-l": key + 1 != _ctx.max }, "product p-5"])}" style="${ssrRenderStyle({ width: getBoxWidth() + "%" })}">`);
        _push(ssrRenderComponent(_component_nuxt_link, {
          to: _ctx.$getProductPath(row.product)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="relative flex flex-col items-center"${_scopeId}>`);
              if (unref(scrollTopValue) < 100 || unref(theme) == "desktop") {
                _push2(`<img${ssrRenderAttr("src", ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + row.product.image)} class="max-md:w-[100px] w-[130px]"${_scopeId}>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<div class="remove-icon"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_fa_icon, { icon: ["fas", "close"] }, null, _parent2, _scopeId));
              _push2(`</div><div class="title-twl pt-3 text-center my-2 max-md:text-[11px]"${_scopeId}>${ssrInterpolate(row.product.title)}</div>`);
              if (row.product.status == 1) {
                _push2(ssrRenderComponent(_component_PriceVariationPriceBox, {
                  variation: row.product.variation,
                  "hide-discount": ""
                }, null, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "relative flex flex-col items-center" }, [
                  unref(scrollTopValue) < 100 || unref(theme) == "desktop" ? (openBlock(), createBlock("img", {
                    key: 0,
                    src: ("useRuntimeConfig" in _ctx ? _ctx.useRuntimeConfig : unref(useRuntimeConfig))().public.serverUrl + "/thumbnails/" + row.product.image,
                    class: "max-md:w-[100px] w-[130px]"
                  }, null, 8, ["src"])) : createCommentVNode("", true),
                  createVNode("div", {
                    onClick: withModifiers(($event) => removeProductOfComparisonList(row.product.id), ["prevent"]),
                    class: "remove-icon"
                  }, [
                    createVNode(_component_fa_icon, { icon: ["fas", "close"] })
                  ], 8, ["onClick"]),
                  createVNode("div", { class: "title-twl pt-3 text-center my-2 max-md:text-[11px]" }, toDisplayString(row.product.title), 1),
                  row.product.status == 1 ? (openBlock(), createBlock(_component_PriceVariationPriceBox, {
                    key: 1,
                    variation: row.product.variation,
                    "hide-discount": ""
                  }, null, 8, ["variation"])) : createCommentVNode("", true)
                ])
              ];
            }
          }),
          _: 2
        }, _parent));
        if (row.product.status == 1) {
          _push(ssrRenderComponent(_component_PriceVariationSelectVariationBtn, {
            product: row.product,
            "btn-class": "c-btn mx-auto",
            text: "\u0627\u0641\u0632\u0648\u062F\u0646 \u0628\u0647 \u0633\u0628\u062F",
            "hide-icon": unref(theme) !== "desktop"
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      });
      _push(`<!--]-->`);
      if (_ctx.data.length < _ctx.max) {
        _push(`<div style="${ssrRenderStyle({ width: getBoxWidth() + "%" })}" class="selection"><button class="px-4 py-2 bg-white rounded-md"> \u0627\u0646\u062A\u062E\u0627\u0628 \u06A9\u0627\u0644\u0627 </button></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (_ctx.data.length > 0) {
        _push(ssrRenderComponent(_component_ComparisonSelectionProducts, {
          ref_key: "selectionProductsBox",
          ref: selectionProductsBox,
          category_id: _ctx.data[0].product.category_id
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comparison/Products.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "page",
  __ssrInlineRender: true,
  setup(__props) {
    const {
      characteristicsId,
      data,
      getComparisonData
    } = comparison();
    const max = ref(4);
    const theme = useState("theme");
    useRoute();
    const arrayId = ref([]);
    watch(() => arrayId.value, () => {
      getComparisonData(arrayId.value);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ComparisonProducts = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full" }, _attrs))}><div class="comparison-box relative">`);
      _push(ssrRenderComponent(_component_ComparisonProducts, {
        data: unref(data),
        max: unref(max)
      }, null, _parent));
      _push(`<div class="specifications w-full">`);
      if (unref(theme) == "desktop") {
        _push(`<!--[-->`);
        ssrRenderList(_ctx.$sort(unref(characteristicsId), "position"), (item) => {
          _push(`<div class="flex"><!--[-->`);
          ssrRenderList(unref(data), (row, key) => {
            _push(`<div class="item border-b p-3 lg:p-5">`);
            if (key == 0) {
              _push(`<span class="text-gray-500 text-[15px]">${ssrInterpolate(item.key)}</span>`);
            } else {
              _push(`<span></span>`);
            }
            if (row["specifications"][item.id] !== void 0) {
              _push(`<div class="py-3 !text-black"><!--[-->`);
              ssrRenderList(row["specifications"][item.id].values, (value) => {
                _push(`<p class="ma-0 !p-0">${ssrInterpolate(value)}</p>`);
              });
              _push(`<!--]--></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          });
          _push(`<!--]--></div>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<table class="w-full mt-3 !text-[13px]"><!--[-->`);
        ssrRenderList(_ctx.$sort(unref(characteristicsId), "position"), (item, key) => {
          _push(`<tr><th class="${ssrRenderClass([{ "border-b": key != Object.keys(unref(characteristicsId)).length - 1 }, "min-w-[80px] bg-gray-100 text-center p-2 !font-normal"])}">${ssrInterpolate(item.key)}</th><!--[-->`);
          ssrRenderList(unref(data), (row, key2) => {
            _push(`<td class="${ssrRenderClass([{ "border-b": key != Object.keys(unref(characteristicsId)).length - 1 }, "p-2"])}">`);
            if (row["specifications"][item.id] !== void 0) {
              _push(`<div class="py-3 !text-black"><!--[-->`);
              ssrRenderList(row["specifications"][item.id].values, (value) => {
                _push(`<span>${ssrInterpolate(value)}</span>`);
              });
              _push(`<!--]--></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</td>`);
          });
          _push(`<!--]--></tr>`);
        });
        _push(`<!--]--></table>`);
      }
      _push(`</div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/comparison/page.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as _ };
//# sourceMappingURL=page-3hCjrg13.mjs.map
