import { _ as _sfc_main$3, a as _sfc_main$1 } from './Factor-gB4gfjyT.mjs';
import { defineComponent, mergeProps, unref, createVNode, resolveDynamicComponent, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderVNode } from 'vue/server-renderer';
import { u as useOrderStore } from './index-Co4X6G3O.mjs';
import { u as useState, c as useNuxtApp } from './server.mjs';
import 'pinia';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "payment",
  __ssrInlineRender: true,
  setup(__props) {
    const theme = useState("theme");
    const global = useNuxtApp().vueApp.config.globalProperties;
    const paymentMethods = global.$sort(
      global["$payment:methods"],
      "index"
    );
    const order = useOrderStore();
    let contents = global["$payment:contents"];
    contents = global.$sort(
      contents,
      "index"
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_OrdersCheckoutHeader = _sfc_main$3;
      const _component_OrdersCheckoutFactor = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "checkout-order" }, _attrs))}>`);
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_OrdersCheckoutHeader, {
          title: "\u067E\u0631\u062F\u0627\u062E\u062A",
          "back-route": "/checkout/shipping"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="w-full lg:flex"><div class="w-full lg:[width:calc(100%-300px)] mt-4"><div class="lg:border rounded-md mb-3 w-full py-3 px-3 lg:px-5"><span class="font-bold">\u0627\u0646\u062A\u062E\u0627\u0628 \u0631\u0648\u0634 \u067E\u0631\u062F\u0627\u062E\u062A</span><ul class="select-payment-method"><!--[-->`);
      ssrRenderList(unref(paymentMethods), (method, key) => {
        _push(`<li>`);
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(method.component), { class: "py-5" }, null), _parent);
        _push(`</li>`);
      });
      _push(`<!--]--></ul></div>`);
      if (unref(contents)) {
        _push(`<!--[-->`);
        ssrRenderList(unref(contents), (content, key) => {
          _push(`<div class="lg:border rounded-md mb-3 w-full py-3 px-3 lg:px-5">`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(content.component), { key }, null), _parent);
          _push(`</div>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (unref(order).data && unref(order).data.submissions) {
        _push(`<div class="lg:border rounded-md mb-3 w-full py-3 px-5"><p class="font-bold"> \u062E\u0644\u0627\u0635\u0647 \u0633\u0641\u0627\u0631\u0634 </p><!--[-->`);
        ssrRenderList(unref(order).data.submissions, (submission, key) => {
          _push(`<div class="w-full py-3">`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(submission.info.component + "-summary"), { submission }, null), _parent);
          _push(`</div>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="order-factor"><div class="content">`);
      _push(ssrRenderComponent(_component_OrdersCheckoutFactor, null, null, _parent));
      _push(`</div></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/checkout/payment.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=payment-B3OgT_De.mjs.map
