import { _ as _sfc_main$3, a as _sfc_main$1 } from './Factor-gB4gfjyT.mjs';
import { _ as __nuxt_component_3 } from './Skeleton-B5XQTW8R.mjs';
import { defineComponent, watch, mergeProps, unref, createVNode, resolveDynamicComponent, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderVNode } from 'vue/server-renderer';
import { f as cartStore, u as useState, c as useNuxtApp, j as useRouter } from './server.mjs';
import { u as useOrderStore } from './index-Co4X6G3O.mjs';
import '../_/nitro.mjs';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'node:fs';
import 'node:url';
import 'ipx';
import 'node:path';
import 'node:crypto';
import 'pinia';
import 'vue-router';
import 'highcharts';
import 'lodash';
import '@vue/shared';

const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "shipping",
  __ssrInlineRender: true,
  setup(__props) {
    const cart = cartStore();
    const order = useOrderStore();
    const theme = useState("theme");
    const selectedAddressId = useState("selected-address-id");
    const global = useNuxtApp().vueApp.config.globalProperties;
    let contents = global["$shipping-page:content"];
    if (contents) {
      contents = global.$sort(contents, "index");
    }
    watch(() => selectedAddressId.value, () => {
      order.getOrderInfo(selectedAddressId.value);
      order.formData["addressId"] = selectedAddressId.value;
      order.itemsDeducted = {};
    });
    watch(() => cart.cartData, () => {
      order.getOrderInfo(selectedAddressId.value);
    });
    watch(() => order.loading, (value, oldValue) => {
      if (!value && oldValue) {
        if (order.data.submissions.length == 0) {
          useRouter().push("/cart");
        }
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_OrdersCheckoutHeader = _sfc_main$3;
      const _component_Skeleton = __nuxt_component_3;
      const _component_OrdersCheckoutFactor = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "checkout-order" }, _attrs))}>`);
      if (unref(theme) == "desktop") {
        _push(ssrRenderComponent(_component_OrdersCheckoutHeader, {
          title: "\u0622\u062F\u0631\u0633 \u0648 \u0632\u0645\u0627\u0646 \u0627\u0631\u0633\u0627\u0644",
          "back-route": "/cart"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="w-full lg:flex"><div class="max-lg:w-full mt-4 lg:[width:calc(100%-300px)]">`);
      if (unref(contents)) {
        _push(`<!--[-->`);
        ssrRenderList(unref(contents), (content, key) => {
          _push(`<div class="lg:border rounded-md mb-3 w-full py-3 px-3 lg:px-5">`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(content.component), null, null), _parent);
          _push(`</div>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (unref(order).data && unref(order).data.submissions) {
        _push(`<!--[-->`);
        ssrRenderList(unref(order).data.submissions, (submission, key) => {
          _push(`<div class="lg:border rounded-md mb-3 w-full py-3 px-5">`);
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(submission.info.component), {
            "delivery-method": submission.info,
            products: submission.products,
            "delivery-times": submission["delivery-times"]
          }, null), _parent);
          _push(`</div>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (unref(order).loading) {
        _push(`<div class="lg:border rounded-md p-4">`);
        _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-14 rounded-md" }, null, _parent));
        _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-14 mt-4 rounded-md" }, null, _parent));
        _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-14 mt-4 rounded-md" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="order-factor"><div class="content">`);
      if (unref(order).loading) {
        _push(`<div>`);
        _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-4 rounded-md my-2" }, null, _parent));
        _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-4 rounded-md my-2" }, null, _parent));
        _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-4 rounded-md my-2" }, null, _parent));
        _push(ssrRenderComponent(_component_Skeleton, { class: "w-full h-4 rounded-md my-2" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(ssrRenderComponent(_component_OrdersCheckoutFactor, null, null, _parent));
      }
      _push(`</div></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/checkout/shipping.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
//# sourceMappingURL=shipping-Dy4XH0oE.mjs.map
