export function useManageUserComments(){

    const comments=ref<Record<string, any>>({data:[]});
    const {api,serverUrl}=useRuntimeConfig().public;
    const {$axios}=useNuxtApp();

    onMounted(()=>{
       getComments();
    });

    const getComments=(page=1)=>{
        $axios.get(api+'/user/comments?page='+page)
            .then((response)=>{
               comments.value=response.data;
            });
    }

    return{
        comments,
        serverUrl,
        getComments
    }
}