import {commentFormStore} from '~/stores/comment-form';

export function useUploadCommentFile(product:Record<string, any>){
    const form=commentFormStore(product.id);
    const maxFiles=5;
    const  file=ref<HTMLInputElement|null>(null);
    const uploadingFiles=ref<Record<string, File|string>[]>([]);
    const {api}=useRuntimeConfig().public;
    const {$axios}=useNuxtApp();
    const getImageUrl=(file:File)=>{
        return URL.createObjectURL(file!)
    };

    const selectedFile=()=>{
        if (file.value?.files?.[0]) {
            const index = uploadingFiles.value.length;
            uploadingFiles.value.push({
                file:file.value.files[0],
                status:'loading'
            });
            $axios.post(api+'/user/comment/upload',{
                files:[file.value.files[0]],
                product_id:product.id
            },{
                headers:{'Content-Type':'multipart/form-data'}
            })
            .then((response)=>{
                if(response.data.status=='ok'){
                    uploadingFiles.value[index].status='success';
                    form.formData.files[index]=response.data.paths[0];
                }
            }).catch(()=>{
                uploadingFiles.value.splice(index,1);
            });
        }
    }

    const removeFile=(index:number)=>{
        if(uploadingFiles.value[index].status=='success'){
            uploadingFiles.value.splice(index,1);
            form.formData.files.splice(index,1);
        }
        else{
            uploadingFiles.value.splice(index,1);
        }
    }

    return {
        form,
        file,
        selectedFile,
        removeFile,
        getImageUrl,
        uploadingFiles,
        maxFiles
    }
}