import {productStore} from '@/stores/product';

export function useProduct(global:Record<string, any>){

    const shopSetting=useState<Record<string, any>>('shopSetting');
    const theme=useState('theme');
    const route=useRoute();
    const {api,serverUrl,appUrl}=useRuntimeConfig().public;

    let requestUrl=  api+'/product/'+route.params['id'];
    if (Object.keys(route.query).length > 0) {
        const queryString = new URLSearchParams(route.query.toString()).toString();
        requestUrl += '?' + queryString;
    }

    const store=productStore();
    const getMeta=(product:Record<string, any>)=>{
        return [
            {
                name:"description",
                content:product.description
            },
            {
                name:"keywords",
                content:product.tags
            },
            {
                property: "og:title",
                content: "فروشگاه اینترنتی " + shopSetting.value?.name + " - " + product.title
            },
            {
                property: "og:description",
                content: product.description
            },
            {
                property: "og:image",
                content: serverUrl+'/thumbnails/'+product.image
            },
            {
                property: "og:url",
                content: appUrl+'/'+global.$getProductPath(product)
            },
            {
                property: "og:type",
                content: "product"
            }
        ];
    }

    const getSimilarProductsSetting=(product:Record<string, any>|null)=>{
        return product ? {
            title: "محصولات مشابه",
            column: "n",
            row: "1",
            theme: "vertical-view",
            className: "mb-7",
            "requestUrl": `${api}/shop/similar-products?product_id=${product.id}&category_id=${product.category_id}&brand_id=${product.brand_id}`
        } : null;
    }

    return {
        theme,
        api,
        store,
        requestUrl,
        shopSetting,
        getMeta,
        getSimilarProductsSetting
    }
}