import {productStore} from "~/stores/product";
import {galleryStore} from "~/stores/gallery";
export function useTabGallery(){

    const swiperRef=ref<any>(null);
    const store=productStore();
    const gallery=galleryStore();
    const theme=useState('theme');
    const boxRef=ref<any>(null);

    onMounted(()=>{
        gallery.getCommentsMedia(store.product?.id);
    });

    const show=()=>{
        boxRef.value?.show();
        nextTick(()=>{
            swiperRef.value?.swiper.on('slideChange',()=>{
                const activeSlideIndex=swiperRef.value!.swiper.activeIndex;
                const slide = swiperRef.value!.swiper.slides[activeSlideIndex];
                gallery.onMainSlideChanged(
                    slide,
                    activeSlideIndex,
                );
            });
        });
    }

    const changeMainSlider=(index:number)=>{
        swiperRef.value?.swiper.slideTo(index);
    }

    watch(()=>store.activeMediaPath,()=>{
        show();
        nextTick(()=>{
            gallery.slideShowBasedActivePath(
                store.activeMediaPath!
            );
        });
    });

    watch(()=>gallery.slideIndex,()=>{
        swiperRef.value?.swiper.slideTo(gallery.slideIndex);
    });

    const injectStyles=[
        `.swiper-button-next,
  .swiper-button-prev {
      background-color: white;
      border-radius: 100% ;
      width:35px;
      height:35px;
      border:1px solid #dedede;
  }
  .swiper-button-next svg,
  .swiper-button-prev svg {
     width:20px;
     height:20px;
     color:black;
  }`];

    return{
        show,
        changeMainSlider,
        swiperRef,
        theme,
        boxRef,
        gallery,
        store,
        injectStyles
    }
}