import {productStore} from "~/stores/product";
import type {reviewType} from "~/types/Review";

export function useProductPage(){

    const store = productStore();
    const reviews = ref<reviewType[]>([]);
    const loading = ref(false);
    const showAllReviews = ref(false);
    const nuxtApp = useNuxtApp();

    onMounted(() => {
        if(store.descriptionOffcanvas=='show'){
            showAllReviews.value=true;
        }
        setTimeout(getProductExpertReviews, 1000);
    });

    const getProductExpertReviews = () => {
        if (store.product) {
            getReviews();
        }
    }

    const getReviews = async () => {
        const url = useRuntimeConfig().public.api
            + '/products/' + store.product!.id + '/expert-reviews/all';
        const {data, status} = await useFetch<reviewType[]>(
            url, {
                key: 'product-reviews-' + (store.product!.id),
                lazy: true,
                getCachedData(key) {
                    return nuxtApp.payload.data[key] || nuxtApp.static.data[key]
                }
            }
        );
        if (data.value) {
            reviews.value = data.value;
        }
    }

    const displayedReviews = computed(() => {
        if (showAllReviews.value) {
            return reviews.value;
        } else {
            return reviews.value.slice(0, 1);
        }
    });

    const convertDescription = function (content: string) {
        content = content.toString()
            .replace('--row--', '<div class="flex">')
            .replace('--end row--', '</div>')
            .replace('<img',"<img alt=''")
            .replace('<span class="ql-cursor">﻿﻿﻿﻿﻿﻿﻿﻿</span>', '');

        content = content.replace(/style="[^"]*"/g, '');

        content = content.replace(/<img[^>]*>/g, function (imgTag) {
            return `<div class="image-div"><div>${imgTag}</div></div>`;
        });

        return content;
    }

    watch(() => store.product, () => {
        if (store.product) {
            getReviews();
        }
    });


    watch(() => reviews.value, () => {
        console.log('reviews');
        console.log(reviews.value);
        if (!reviews.value) {
            store.removeContent('expert-reviews');
        }
        if (reviews.value.length == 0) {
            if (reviews.value.length == 0) {
                store.removeContent('expert-reviews');
            }
        }
    });

    watch(()=>store.descriptionOffcanvas,()=>{
        if(store.descriptionOffcanvas=='show'){
            showAllReviews.value=true;
        }
        else{
            showAllReviews.value=false;
        }
    });

    return {
        loading,
        showAllReviews,
        store,
        reviews,
        displayedReviews,
        convertDescription
    }
}